/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import com.google.appinventor.components.runtime.errors.YailRuntimeError;
import com.google.appinventor.components.runtime.util.JsonUtil;
import com.google.appinventor.components.runtime.util.YailNumberToString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.json.JSONException;

public class YailList {
    private static final String LOG_TAG = "YailList";
    private ArrayList<Object> items = new ArrayList();

    public YailList() {
    }

    private YailList(Object object) {
        this.items.add(object);
    }

    public static YailList makeEmptyList() {
        return new YailList();
    }

    public static YailList makeList(Object[] objects) {
        YailList newYailList = new YailList();
        for (Object item : objects) {
            newYailList.items.add(item);
        }
        return newYailList;
    }

    public static YailList makeList(List vals) {
        YailList list = new YailList();
        list.items = new ArrayList(vals);
        return list;
    }

    public static YailList makeList(Collection vals) {
        YailList list = new YailList();
        list.items = new ArrayList(vals);
        return list;
    }

    public Object[] toArray() {
        return this.items.toArray();
    }

    public String[] toStringArray() {
        String[] stringArray = new String[this.items.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            Object item = this.items.get(i);
            stringArray[i] = item.toString();
        }
        return stringArray;
    }

    public static String YailListElementToString(Object element) {
        if (Number.class.isInstance(element)) {
            return YailNumberToString.format(((Number)element).doubleValue());
        }
        return String.valueOf(element);
    }

    public Object get(int index) {
        return this.items.get(index - 1);
    }

    public String toJSONString() {
        try {
            StringBuilder json = new StringBuilder();
            String separator = "";
            json.append('[');
            int size = this.items.size();
            for (int i = 0; i < size; ++i) {
                Object value = this.items.get(i);
                json.append(separator).append(JsonUtil.getJsonRepresentation(value));
                separator = ",";
            }
            json.append(']');
            return json.toString();
        }
        catch (JSONException e) {
            throw new YailRuntimeError("List failed to convert to JSON.", "JSON Creation Error.");
        }
    }

    public int size() {
        return this.items.size();
    }

    public String toString() {
        return this.items.toString();
    }

    public String getString(int index) {
        return this.items.get(index - 1).toString();
    }

    public Object getObject(int index) {
        return this.items.get(index - 1);
    }
}

