/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import android.util.Log;
import com.google.appinventor.components.runtime.util.AsyncCallbackPair;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceUtil {
    private static final WebServiceUtil INSTANCE = new WebServiceUtil();
    private static final String LOG_TAG = "WebServiceUtil";
    private static HttpClient httpClient = null;
    private static Object httpClientSynchronizer = new Object();

    private WebServiceUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebServiceUtil getInstance() {
        Object object = httpClientSynchronizer;
        synchronized (object) {
            if (httpClient == null) {
                SchemeRegistry schemeRegistry = new SchemeRegistry();
                schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
                schemeRegistry.register(new Scheme("https", (SocketFactory)SSLSocketFactory.getSocketFactory(), 443));
                BasicHttpParams params = new BasicHttpParams();
                HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)20000);
                HttpConnectionParams.setSoTimeout((HttpParams)params, (int)20000);
                ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)20);
                ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
                httpClient = new DefaultHttpClient((ClientConnectionManager)manager, (HttpParams)params);
            }
        }
        return INSTANCE;
    }

    public void postCommandReturningArray(String serviceURL, String commandName, List<NameValuePair> params, final AsyncCallbackPair<JSONArray> callback) {
        AsyncCallbackPair<String> thisCallback = new AsyncCallbackPair<String>(){

            @Override
            public void onSuccess(String httpResponseString) {
                try {
                    callback.onSuccess(new JSONArray(httpResponseString));
                }
                catch (JSONException e) {
                    callback.onFailure(e.getMessage());
                }
            }

            @Override
            public void onFailure(String failureMessage) {
                callback.onFailure(failureMessage);
            }
        };
        this.postCommand(serviceURL, commandName, params, thisCallback);
    }

    public void postCommandReturningObject(String serviceURL, String commandName, List<NameValuePair> params, final AsyncCallbackPair<JSONObject> callback) {
        AsyncCallbackPair<String> thisCallback = new AsyncCallbackPair<String>(){

            @Override
            public void onSuccess(String httpResponseString) {
                try {
                    callback.onSuccess(new JSONObject(httpResponseString));
                }
                catch (JSONException e) {
                    callback.onFailure(e.getMessage());
                }
            }

            @Override
            public void onFailure(String failureMessage) {
                callback.onFailure(failureMessage);
            }
        };
        this.postCommand(serviceURL, commandName, params, thisCallback);
    }

    public void postCommand(String serviceURL, String commandName, List<NameValuePair> params, AsyncCallbackPair<String> callback) {
        Log.d((String)LOG_TAG, (String)("Posting " + commandName + " to " + serviceURL + " with arguments " + params));
        if (serviceURL == null || serviceURL.equals("")) {
            callback.onFailure("No service url to post command to.");
        }
        HttpPost httpPost = new HttpPost(serviceURL + "/" + commandName);
        if (params == null) {
            params = new ArrayList<NameValuePair>();
        }
        try {
            BasicResponseHandler responseHandler = new BasicResponseHandler();
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            httpPost.setHeader("Accept", "application/json");
            String httpResponseString = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
            callback.onSuccess(httpResponseString);
        }
        catch (UnsupportedEncodingException e) {
            Log.w((String)LOG_TAG, (Throwable)e);
            callback.onFailure("Failed to encode params for web service call.");
        }
        catch (ClientProtocolException e) {
            Log.w((String)LOG_TAG, (Throwable)e);
            callback.onFailure("Communication with the web service encountered a protocol exception.");
        }
        catch (IOException e) {
            Log.w((String)LOG_TAG, (Throwable)e);
            callback.onFailure("Communication with the web service timed out.");
        }
    }
}

