/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TableRow;

public final class ViewUtil {
    private ViewUtil() {
    }

    private static int calculatePixels(View view, int sizeInDP) {
        return (int)(view.getContext().getResources().getDisplayMetrics().density * (float)sizeInDP);
    }

    public static void setChildWidthForHorizontalLayout(View view, int width) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams instanceof LinearLayout.LayoutParams) {
            LinearLayout.LayoutParams linearLayoutParams = (LinearLayout.LayoutParams)layoutParams;
            switch (width) {
                case -1: {
                    linearLayoutParams.width = -2;
                    linearLayoutParams.weight = 0.0f;
                    break;
                }
                case -2: {
                    linearLayoutParams.width = 0;
                    linearLayoutParams.weight = 1.0f;
                    break;
                }
                default: {
                    linearLayoutParams.width = ViewUtil.calculatePixels(view, width);
                    linearLayoutParams.weight = 0.0f;
                }
            }
            view.requestLayout();
        } else {
            Log.e((String)"ViewUtil", (String)"The view does not have linear layout parameters");
        }
    }

    public static void setChildHeightForHorizontalLayout(View view, int height) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams instanceof LinearLayout.LayoutParams) {
            LinearLayout.LayoutParams linearLayoutParams = (LinearLayout.LayoutParams)layoutParams;
            switch (height) {
                case -1: {
                    linearLayoutParams.height = -2;
                    break;
                }
                case -2: {
                    linearLayoutParams.height = -1;
                    break;
                }
                default: {
                    linearLayoutParams.height = ViewUtil.calculatePixels(view, height);
                }
            }
            view.requestLayout();
        } else {
            Log.e((String)"ViewUtil", (String)"The view does not have linear layout parameters");
        }
    }

    public static void setChildWidthForVerticalLayout(View view, int width) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams instanceof LinearLayout.LayoutParams) {
            LinearLayout.LayoutParams linearLayoutParams = (LinearLayout.LayoutParams)layoutParams;
            switch (width) {
                case -1: {
                    linearLayoutParams.width = -2;
                    break;
                }
                case -2: {
                    linearLayoutParams.width = -1;
                    break;
                }
                default: {
                    linearLayoutParams.width = ViewUtil.calculatePixels(view, width);
                }
            }
            view.requestLayout();
        } else {
            Log.e((String)"ViewUtil", (String)"The view does not have linear layout parameters");
        }
    }

    public static void setChildHeightForVerticalLayout(View view, int height) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams instanceof LinearLayout.LayoutParams) {
            LinearLayout.LayoutParams linearLayoutParams = (LinearLayout.LayoutParams)layoutParams;
            switch (height) {
                case -1: {
                    linearLayoutParams.height = -2;
                    linearLayoutParams.weight = 0.0f;
                    break;
                }
                case -2: {
                    linearLayoutParams.height = 0;
                    linearLayoutParams.weight = 1.0f;
                    break;
                }
                default: {
                    linearLayoutParams.height = ViewUtil.calculatePixels(view, height);
                    linearLayoutParams.weight = 0.0f;
                }
            }
            view.requestLayout();
        } else {
            Log.e((String)"ViewUtil", (String)"The view does not have linear layout parameters");
        }
    }

    public static void setChildWidthForTableLayout(View view, int width) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams instanceof TableRow.LayoutParams) {
            TableRow.LayoutParams tableLayoutParams = (TableRow.LayoutParams)layoutParams;
            switch (width) {
                case -1: {
                    tableLayoutParams.width = -2;
                    break;
                }
                case -2: {
                    tableLayoutParams.width = -1;
                    break;
                }
                default: {
                    tableLayoutParams.width = ViewUtil.calculatePixels(view, width);
                }
            }
            view.requestLayout();
        } else {
            Log.e((String)"ViewUtil", (String)"The view does not have table layout parameters");
        }
    }

    public static void setChildHeightForTableLayout(View view, int height) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams instanceof TableRow.LayoutParams) {
            TableRow.LayoutParams tableLayoutParams = (TableRow.LayoutParams)layoutParams;
            switch (height) {
                case -1: {
                    tableLayoutParams.height = -2;
                    break;
                }
                case -2: {
                    tableLayoutParams.height = -1;
                    break;
                }
                default: {
                    tableLayoutParams.height = ViewUtil.calculatePixels(view, height);
                }
            }
            view.requestLayout();
        } else {
            Log.e((String)"ViewUtil", (String)"The view does not have table layout parameters");
        }
    }

    public static void setBackgroundImage(View view, Drawable drawable2) {
        view.setBackgroundDrawable(drawable2);
        view.requestLayout();
    }

    public static void setImage(ImageView view, Drawable drawable2) {
        view.setImageDrawable(drawable2);
        if (drawable2 != null) {
            view.setAdjustViewBounds(true);
        }
        view.requestLayout();
    }

    public static void setBackgroundDrawable(View view, Drawable drawable2) {
        view.setBackgroundDrawable(drawable2);
        view.invalidate();
    }
}

