/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import android.util.Log;
import com.google.appinventor.components.runtime.util.BiggerFuture;
import gnu.expr.Language;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Procedure0;
import gnu.mapping.TtyInPort;
import gnu.mapping.Values;
import gnu.text.FilePath;
import gnu.text.Path;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import kawa.Shell;
import kawa.Telnet;
import kawa.TelnetInputStream;
import kawa.TelnetOutputStream;

public class TelnetRepl
extends Procedure0 {
    Socket socket;
    Language language;
    private static final int REPL_STACK_SIZE = 262144;

    public TelnetRepl(Language language, Socket socket) {
        this.language = language;
        this.socket = socket;
    }

    public Object apply0() {
        Thread thread = Thread.currentThread();
        ClassLoader contextClassLoader = thread.getContextClassLoader();
        if (contextClassLoader == null) {
            thread.setContextClassLoader(Telnet.class.getClassLoader());
        }
        try {
            Shell.run((Language)this.language, (Environment)Environment.getCurrent());
            Values values = Values.empty;
            return values;
        }
        catch (RuntimeException e) {
            Log.d((String)"TelnetRepl", (String)("Repl is exiting with error " + e.getMessage()));
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Thread serve(Language language, Socket client) throws IOException {
        Telnet conn = new Telnet(client, true);
        TelnetOutputStream sout = conn.getOutputStream();
        TelnetInputStream sin = conn.getInputStream();
        OutPort out = new OutPort((OutputStream)sout, (Path)FilePath.valueOf((String)"/dev/stdout"));
        TtyInPort in = new TtyInPort((InputStream)sin, (Path)FilePath.valueOf((String)"/dev/stdin"), out);
        BiggerFuture thread = new BiggerFuture((Procedure)new TelnetRepl(language, client), (InPort)in, out, out, "Telnet Repl Thread", 262144L);
        thread.start();
        return thread;
    }
}

