/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.telephony.PhoneNumberUtils;
import android.telephony.gsm.SmsMessage;
import android.util.Log;
import com.google.appinventor.components.runtime.ReplForm;
import com.google.appinventor.components.runtime.Texting;

public class SmsBroadcastReceiver
extends BroadcastReceiver {
    public static final String TAG = "SmsBroadcastReceiver";
    public static final int NOTIFICATION_ID = 8647;

    public void onReceive(Context context, Intent intent) {
        Log.i((String)TAG, (String)"onReceive");
        String phone = this.getPhoneNumber(intent);
        String msg = this.getMessage(intent);
        Log.i((String)TAG, (String)("Received " + phone + " : " + msg));
        int receivingEnabled = Texting.isReceivingEnabled(context);
        if (receivingEnabled == 1) {
            Log.i((String)TAG, (String)(context.getApplicationInfo().packageName + " Receiving is not enabled, ignoring message."));
            return;
        }
        if ((receivingEnabled == 2 || this.isRepl(context)) && !Texting.isRunning()) {
            Log.i((String)TAG, (String)(context.getApplicationInfo().packageName + " Texting isn't running, and either receivingEnabled is FOREGROUND or we are the repl."));
            return;
        }
        Texting.handledReceivedMessage(context, phone, msg);
        if (Texting.isRunning()) {
            Log.i((String)TAG, (String)(context.getApplicationInfo().packageName + " App in Foreground, delivering message."));
        } else {
            Log.i((String)TAG, (String)(context.getApplicationInfo().packageName + " Texting isn't running, but receivingEnabled == 2, sending notification."));
            this.sendNotification(context, phone, msg);
        }
    }

    private String getPhoneNumber(Intent intent) {
        String phone = "";
        if (intent.getAction().equals("com.google.android.apps.googlevoice.SMS_RECEIVED")) {
            phone = intent.getExtras().getString("com.google.android.apps.googlevoice.PHONE_NUMBER");
            phone = PhoneNumberUtils.formatNumber((String)phone);
        } else {
            Object[] pdus;
            for (Object pdu : pdus = (Object[])intent.getExtras().get("pdus")) {
                SmsMessage smsMsg = SmsMessage.createFromPdu((byte[])((byte[])pdu));
                phone = smsMsg.getOriginatingAddress();
                phone = PhoneNumberUtils.formatNumber((String)phone);
            }
        }
        return phone;
    }

    private String getMessage(Intent intent) {
        String msg = "";
        if (intent.getAction().equals("com.google.android.apps.googlevoice.SMS_RECEIVED")) {
            msg = intent.getExtras().getString("com.google.android.apps.googlevoice.TEXT");
        } else {
            Object[] pdus;
            for (Object pdu : pdus = (Object[])intent.getExtras().get("pdus")) {
                SmsMessage smsMsg = SmsMessage.createFromPdu((byte[])((byte[])pdu));
                msg = smsMsg.getMessageBody();
            }
        }
        return msg;
    }

    private void sendNotification(Context context, String phone, String msg) {
        Log.i((String)TAG, (String)("sendingNotification " + phone + ":" + msg));
        String packageName = context.getPackageName();
        Log.i((String)TAG, (String)("Package name : " + packageName));
        Intent newIntent = null;
        try {
            String classname = packageName + ".Screen1";
            newIntent = new Intent(context, Class.forName(classname));
            newIntent.setAction("android.intent.action.MAIN");
            newIntent.addCategory("android.intent.category.LAUNCHER");
            newIntent.addFlags(0x30000000);
            NotificationManager nm = (NotificationManager)context.getSystemService("notification");
            Notification note = new Notification(17301648, (CharSequence)(phone + " : " + msg), System.currentTimeMillis());
            note.flags |= 0x10;
            note.defaults |= 1;
            PendingIntent activity = PendingIntent.getActivity((Context)context, (int)0, (Intent)newIntent, (int)0x8000000);
            note.setLatestEventInfo(context, (CharSequence)("Sms from " + phone), (CharSequence)msg, activity);
            note.number = Texting.getCachedMsgCount();
            nm.notify(null, 8647, note);
            Log.i((String)TAG, (String)("Notification sent, classname: " + classname));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private boolean isRepl(Context context) {
        try {
            String packageName = context.getPackageName();
            String classname = packageName + ".Screen1";
            Class<?> appClass = Class.forName(classname);
            Class<?> superClass = appClass.getSuperclass();
            return superClass.equals(ReplForm.class);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }
}

