/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import android.content.Context;
import android.graphics.Point;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.google.appinventor.components.runtime.util.JellybeanUtil;
import com.google.appinventor.components.runtime.util.SdkLevel;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ScreenDensityUtil {
    private static final String LOG_TAG = "ScreenDensityUtil";
    public static final int DEFAULT_NORMAL_SHORT_DIMENSION = 320;
    public static final float MAXIMUM_ASPECT_RATIO = 1.7791667f;

    private ScreenDensityUtil() {
    }

    public static float computeCompatibleScaling(Context context) {
        float scale;
        int newHeight;
        int newWidth;
        int longSize;
        int shortSize;
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        Point rawDims = new Point();
        ScreenDensityUtil.getRawScreenDim(context, rawDims);
        int width = rawDims.x;
        int height = rawDims.y;
        if (width < height) {
            shortSize = width;
            longSize = height;
        } else {
            shortSize = height;
            longSize = width;
        }
        int newShortSize = (int)(320.0f * dm.density + 0.5f);
        float aspect = (float)longSize / (float)shortSize;
        if (aspect > 1.7791667f) {
            aspect = 1.7791667f;
        }
        int newLongSize = (int)((float)newShortSize * aspect + 0.5f);
        if (width < height) {
            newWidth = newShortSize;
            newHeight = newLongSize;
        } else {
            newWidth = newLongSize;
            newHeight = newShortSize;
        }
        float sw = (float)width / (float)newWidth;
        float sh = (float)height / (float)newHeight;
        float f = scale = sw < sh ? sw : sh;
        if (scale < 1.0f) {
            scale = 1.0f;
        }
        return scale;
    }

    public static void getRawScreenDim(Context context, Point outSize) {
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        int sdkLevel = SdkLevel.getLevel();
        if (sdkLevel >= 17) {
            JellybeanUtil.getRealSize(display, outSize);
        } else if (sdkLevel > 10) {
            try {
                Method getRawH = Display.class.getMethod("getRawHeight", new Class[0]);
                Method getRawW = Display.class.getMethod("getRawWidth", new Class[0]);
                try {
                    outSize.x = (Integer)getRawW.invoke((Object)display, new Object[0]);
                    outSize.y = (Integer)getRawH.invoke((Object)display, new Object[0]);
                }
                catch (IllegalArgumentException e) {
                    Log.e((String)LOG_TAG, (String)"Error reading raw screen size", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    Log.e((String)LOG_TAG, (String)"Error reading raw screen size", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    Log.e((String)LOG_TAG, (String)"Error reading raw screen size", (Throwable)e);
                }
            }
            catch (NoSuchMethodException e) {
                Log.e((String)LOG_TAG, (String)"Error reading raw screen size", (Throwable)e);
            }
        } else {
            outSize.x = display.getWidth();
            outSize.y = display.getHeight();
        }
    }
}

