/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import android.util.Log;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RetValManager {
    private static final String LOG_TAG = "RetValManager";
    private static final Object semaphore = new Object();
    private static final long TENSECONDS = 10000L;
    private static ArrayList<JSONObject> currentArray = new ArrayList(10);

    private RetValManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendReturnValue(String blockid, String ok, String item) {
        Object object = semaphore;
        synchronized (object) {
            JSONObject retval = new JSONObject();
            try {
                retval.put("status", (Object)ok);
                retval.put("type", (Object)"return");
                retval.put("value", (Object)item);
                retval.put("blockid", (Object)blockid);
            }
            catch (JSONException e) {
                Log.e((String)LOG_TAG, (String)"Error building retval", (Throwable)e);
                return;
            }
            boolean sendNotify = currentArray.isEmpty();
            currentArray.add(retval);
            if (sendNotify) {
                semaphore.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendError(String error) {
        Object object = semaphore;
        synchronized (object) {
            JSONObject retval = new JSONObject();
            try {
                retval.put("status", (Object)"OK");
                retval.put("type", (Object)"error");
                retval.put("value", (Object)error);
            }
            catch (JSONException e) {
                Log.e((String)LOG_TAG, (String)"Error building retval", (Throwable)e);
                return;
            }
            boolean sendNotify = currentArray.isEmpty();
            currentArray.add(retval);
            if (sendNotify) {
                semaphore.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushScreen(String screenName, Object value) {
        Object object = semaphore;
        synchronized (object) {
            JSONObject retval = new JSONObject();
            try {
                retval.put("status", (Object)"OK");
                retval.put("type", (Object)"pushScreen");
                retval.put("screen", (Object)screenName);
                if (value != null) {
                    retval.put("value", (Object)value.toString());
                }
            }
            catch (JSONException e) {
                Log.e((String)LOG_TAG, (String)"Error building retval", (Throwable)e);
                return;
            }
            boolean sendNotify = currentArray.isEmpty();
            currentArray.add(retval);
            if (sendNotify) {
                semaphore.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void popScreen(String value) {
        Object object = semaphore;
        synchronized (object) {
            JSONObject retval = new JSONObject();
            try {
                retval.put("status", (Object)"OK");
                retval.put("type", (Object)"popScreen");
                if (value != null) {
                    retval.put("value", (Object)value.toString());
                }
            }
            catch (JSONException e) {
                Log.e((String)LOG_TAG, (String)"Error building retval", (Throwable)e);
                return;
            }
            boolean sendNotify = currentArray.isEmpty();
            currentArray.add(retval);
            if (sendNotify) {
                semaphore.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fetch(boolean block) {
        long startTime = System.currentTimeMillis();
        Object object = semaphore;
        synchronized (object) {
            long time;
            while (currentArray.isEmpty() && block && (time = System.currentTimeMillis()) - startTime <= 9900L) {
                try {
                    semaphore.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            JSONArray arrayoutput = new JSONArray(currentArray);
            JSONObject output = new JSONObject();
            try {
                output.put("status", (Object)"OK");
                output.put("values", (Object)arrayoutput);
            }
            catch (JSONException e) {
                Log.e((String)LOG_TAG, (String)"Error fetching retvals", (Throwable)e);
                return "{\"status\" : \"BAD\", \"message\" : \"Failure in RetValManager\"}";
            }
            currentArray.clear();
            return output.toString();
        }
    }
}

