/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import android.content.Intent;
import android.net.Uri;
import android.util.Log;
import com.google.appinventor.components.runtime.Form;
import com.google.appinventor.components.runtime.util.AsynchUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class PackageInstaller {
    private static final String LOG_TAG = "PackageInstaller(AppInventor)";
    private static final String REPL_ASSET_DIR = "/sdcard/AppInventor/assets/";

    private PackageInstaller() {
    }

    public static void doPackageInstall(final Form form, final String inurl) {
        AsynchUtil.runAsynchronously(new Runnable(){

            public void run() {
                try {
                    int len;
                    URL url = new URL(inurl);
                    URLConnection conn = url.openConnection();
                    File rootDir = new File(PackageInstaller.REPL_ASSET_DIR);
                    BufferedInputStream instream = new BufferedInputStream(conn.getInputStream());
                    File apkfile = new File(rootDir + "/package.apk");
                    FileOutputStream apkOut = new FileOutputStream(apkfile);
                    byte[] buffer = new byte[32768];
                    while ((len = ((InputStream)instream).read(buffer, 0, 32768)) > 0) {
                        apkOut.write(buffer, 0, len);
                    }
                    ((InputStream)instream).close();
                    apkOut.close();
                    Log.d((String)PackageInstaller.LOG_TAG, (String)("About to Install package from " + inurl));
                    Intent intent = new Intent("android.intent.action.VIEW");
                    Uri packageuri = Uri.fromFile((File)new File(rootDir + "/package.apk"));
                    intent.setDataAndType(packageuri, "application/vnd.android.package-archive");
                    form.startActivity(intent);
                }
                catch (Exception e) {
                    form.dispatchErrorOccurredEvent(form, "PackageInstaller", 1101, inurl);
                }
            }
        });
    }
}

