/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

public class OrientationSensorUtil {
    private OrientationSensorUtil() {
    }

    static float mod(float dividend, float quotient) {
        float result = dividend % quotient;
        if (result == 0.0f || Math.signum(dividend) == Math.signum(quotient)) {
            return result;
        }
        return result + quotient;
    }

    public static float normalizeAzimuth(float azimuth) {
        return OrientationSensorUtil.mod(azimuth, 360.0f);
    }

    public static float normalizePitch(float pitch) {
        return OrientationSensorUtil.mod(pitch + 180.0f, 360.0f) - 180.0f;
    }

    public static float normalizeRoll(float roll) {
        roll = Math.min(roll, 180.0f);
        if ((roll = Math.max(roll, -180.0f)) >= -90.0f && roll <= 90.0f) {
            return roll;
        }
        if ((roll = 180.0f - roll) >= 270.0f) {
            roll -= 360.0f;
        }
        return roll;
    }
}

