/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.extensions.android2.auth.GoogleAccountManager;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuth2Helper {
    public static final String TAG = "OAuthHelper";
    public static final String PREF_AUTH_TOKEN = "authToken";
    public static final String PREF_ACCOUNT_NAME = "accountName";
    private static String errorMessage = "Error during OAuth";

    public String getRefreshedAuthToken(Activity activity, String authTokenType) {
        Log.i((String)TAG, (String)"getRefreshedAuthToken()");
        if (this.isUiThread()) {
            throw new IllegalArgumentException("Can't get authtoken from UI thread");
        }
        SharedPreferences settings = activity.getPreferences(0);
        String accountName = settings.getString(PREF_ACCOUNT_NAME, null);
        String authToken = settings.getString(PREF_AUTH_TOKEN, null);
        GoogleCredential credential = new GoogleCredential();
        credential.setAccessToken(authToken);
        AccountManagerFuture<Bundle> future = this.getAccountManagerResult(activity, credential, authTokenType, accountName);
        try {
            Bundle authTokenBundle = (Bundle)future.getResult();
            authToken = authTokenBundle.get("authtoken").toString();
            this.persistCredentials(settings, authTokenBundle.getString("authAccount"), authToken);
        }
        catch (OperationCanceledException e) {
            e.printStackTrace();
            OAuth2Helper.resetAccountCredential(activity);
            errorMessage = "Error: operation cancelled";
        }
        catch (AuthenticatorException e) {
            e.printStackTrace();
            errorMessage = "Error: Authenticator error";
        }
        catch (IOException e) {
            e.printStackTrace();
            errorMessage = "Error: I/O error";
        }
        return authToken;
    }

    private AccountManagerFuture<Bundle> getAccountManagerResult(Activity activity, GoogleCredential credential, String authTokenType, String accountName) {
        AccountManagerFuture future = null;
        GoogleAccountManager accountManager = new GoogleAccountManager((Context)activity);
        accountManager.invalidateAuthToken(credential.getAccessToken());
        AccountManager.get((Context)activity).invalidateAuthToken(authTokenType, null);
        Account account = accountManager.getAccountByName(accountName);
        if (account != null) {
            Log.i((String)TAG, (String)"Getting token by account");
            future = accountManager.getAccountManager().getAuthToken(account, authTokenType, true, null, null);
        } else {
            Log.i((String)TAG, (String)"Getting token by features, possibly prompting user to select an account");
            future = accountManager.getAccountManager().getAuthTokenByFeatures("com.google", authTokenType, null, activity, null, null, null, null);
        }
        return future;
    }

    private boolean isUiThread() {
        return Looper.getMainLooper().getThread().equals(Thread.currentThread());
    }

    private void persistCredentials(SharedPreferences settings, String accountName, String authToken) {
        Log.i((String)TAG, (String)("Persisting credentials, acct =" + accountName));
        SharedPreferences.Editor editor = settings.edit();
        editor.putString(PREF_ACCOUNT_NAME, accountName);
        editor.putString(PREF_AUTH_TOKEN, authToken);
        editor.commit();
    }

    public static void resetAccountCredential(Activity activity) {
        Log.i((String)TAG, (String)"Reset credentials");
        SharedPreferences settings = activity.getPreferences(0);
        SharedPreferences.Editor editor2 = settings.edit();
        editor2.remove(PREF_AUTH_TOKEN);
        editor2.remove(PREF_ACCOUNT_NAME);
        editor2.commit();
    }

    public static String getErrorMessage() {
        Log.i((String)TAG, (String)("getErrorMessage = " + errorMessage));
        return errorMessage;
    }
}

