/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import android.util.Log;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class NanoHTTPD {
    private static final String LOG_TAG = "AppInvHTTPD";
    public static final String HTTP_OK = "200 OK";
    public static final String HTTP_PARTIALCONTENT = "206 Partial Content";
    public static final String HTTP_RANGE_NOT_SATISFIABLE = "416 Requested Range Not Satisfiable";
    public static final String HTTP_REDIRECT = "301 Moved Permanently";
    public static final String HTTP_NOTMODIFIED = "304 Not Modified";
    public static final String HTTP_FORBIDDEN = "403 Forbidden";
    public static final String HTTP_NOTFOUND = "404 Not Found";
    public static final String HTTP_BADREQUEST = "400 Bad Request";
    public static final String HTTP_INTERNALERROR = "500 Internal Server Error";
    public static final String HTTP_NOTIMPLEMENTED = "501 Not Implemented";
    public static final String MIME_PLAINTEXT = "text/plain";
    public static final String MIME_HTML = "text/html";
    public static final String MIME_DEFAULT_BINARY = "application/octet-stream";
    public static final String MIME_XML = "text/xml";
    private static final int REPL_STACK_SIZE = 262144;
    private ThreadPoolExecutor myExecutor = new ThreadPoolExecutor(2, 10, 5L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new myThreadFactory());
    private int myTcpPort;
    private final ServerSocket myServerSocket;
    private Thread myThread;
    private File myRootDir;
    private static Hashtable theMimeTypes = new Hashtable();
    private static int theBufferSize;
    protected static PrintStream myOut;
    protected static PrintStream myErr;
    private static SimpleDateFormat gmtFrmt;
    private static final String LICENCE = "Copyright (C) 2001,2005-2011 by Jarno Elonen <elonen@iki.fi>\nand Copyright (C) 2010 by Konstantinos Togias <info@ktogias.gr>\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions\nare met:\n\nRedistributions of source code must retain the above copyright notice,\nthis list of conditions and the following disclaimer. Redistributions in\nbinary form must reproduce the above copyright notice, this list of\nconditions and the following disclaimer in the documentation and/or other\nmaterials provided with the distribution. The name of the author may not\nbe used to endorse or promote products derived from this software without\nspecific prior written permission. \n \nTHIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR\nIMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\nOF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.\nIN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,\nINCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT\nNOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\nDATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\nTHEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\nOF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.";

    public Response serve(String uri, String method, Properties header, Properties parms, Properties files, Socket mySocket) {
        String value;
        myOut.println(method + " '" + uri + "' ");
        Enumeration<?> e = header.propertyNames();
        while (e.hasMoreElements()) {
            value = (String)e.nextElement();
            myOut.println("  HDR: '" + value + "' = '" + header.getProperty(value) + "'");
        }
        e = parms.propertyNames();
        while (e.hasMoreElements()) {
            value = (String)e.nextElement();
            myOut.println("  PRM: '" + value + "' = '" + parms.getProperty(value) + "'");
        }
        e = files.propertyNames();
        while (e.hasMoreElements()) {
            value = (String)e.nextElement();
            myOut.println("  UPLOADED: '" + value + "' = '" + files.getProperty(value) + "'");
        }
        return this.serveFile(uri, header, this.myRootDir, true);
    }

    public NanoHTTPD(int port, File wwwroot) throws IOException {
        this.myTcpPort = port;
        this.myRootDir = wwwroot;
        this.myServerSocket = new ServerSocket(this.myTcpPort);
        this.myThread = new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        new HTTPSession(NanoHTTPD.this.myServerSocket.accept());
                    }
                }
                catch (IOException iOException) {
                    return;
                }
            }
        });
        this.myThread.setDaemon(true);
        this.myThread.start();
    }

    public void stop() {
        try {
            this.myServerSocket.close();
            this.myThread.join();
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        myOut.println("NanoHTTPD 1.25 (C) 2001,2005-2011 Jarno Elonen and (C) 2010 Konstantinos Togias\n(Command line options: [-p port] [-d root-dir] [--licence])\n");
        int port = 80;
        File wwwroot = new File(".").getAbsoluteFile();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-p")) {
                port = Integer.parseInt(args[i + 1]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-d")) {
                wwwroot = new File(args[i + 1]).getAbsoluteFile();
                continue;
            }
            if (!args[i].toLowerCase().endsWith("licence")) continue;
            myOut.println("Copyright (C) 2001,2005-2011 by Jarno Elonen <elonen@iki.fi>\nand Copyright (C) 2010 by Konstantinos Togias <info@ktogias.gr>\n\nRedistribution and use in source and binary forms, with or without\nmodification, are permitted provided that the following conditions\nare met:\n\nRedistributions of source code must retain the above copyright notice,\nthis list of conditions and the following disclaimer. Redistributions in\nbinary form must reproduce the above copyright notice, this list of\nconditions and the following disclaimer in the documentation and/or other\nmaterials provided with the distribution. The name of the author may not\nbe used to endorse or promote products derived from this software without\nspecific prior written permission. \n \nTHIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR\nIMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES\nOF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.\nIN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,\nINCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT\nNOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,\nDATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY\nTHEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT\n(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE\nOF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n");
            break;
        }
        try {
            new NanoHTTPD(port, wwwroot);
        }
        catch (IOException ioe) {
            myErr.println("Couldn't start server:\n" + ioe);
            System.exit(-1);
        }
        myOut.println("Now serving files in port " + port + " from \"" + wwwroot + "\"");
        myOut.println("Hit Enter to stop.\n");
        try {
            System.in.read();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String encodeUri(String uri) {
        String newUri = "";
        StringTokenizer st = new StringTokenizer(uri, "/ ", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("/")) {
                newUri = newUri + "/";
                continue;
            }
            if (tok.equals(" ")) {
                newUri = newUri + "%20";
                continue;
            }
            newUri = newUri + URLEncoder.encode(tok);
        }
        return newUri;
    }

    public Response serveFile(String uri, Properties header, File homeDir, boolean allowDirectoryListing) {
        Response res;
        block35: {
            res = null;
            if (!homeDir.isDirectory()) {
                res = new Response(HTTP_INTERNALERROR, MIME_PLAINTEXT, "INTERNAL ERRROR: serveFile(): given homeDir is not a directory.");
            }
            if (res == null) {
                if ((uri = uri.trim().replace(File.separatorChar, '/')).indexOf(63) >= 0) {
                    uri = uri.substring(0, uri.indexOf(63));
                }
                if (uri.startsWith("..") || uri.endsWith("..") || uri.indexOf("../") >= 0) {
                    res = new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "FORBIDDEN: Won't serve ../ for security reasons.");
                }
            }
            File f = new File(homeDir, uri);
            if (res == null && !f.exists()) {
                res = new Response(HTTP_NOTFOUND, MIME_PLAINTEXT, "Error 404, file not found.");
            }
            if (res == null && f.isDirectory()) {
                if (!uri.endsWith("/")) {
                    uri = uri + "/";
                    res = new Response(HTTP_REDIRECT, MIME_HTML, "<html><body>Redirected: <a href=\"" + uri + "\">" + uri + "</a></body></html>");
                    res.addHeader("Location", uri);
                }
                if (res == null) {
                    if (new File(f, "index.html").exists()) {
                        f = new File(homeDir, uri + "/index.html");
                    } else if (new File(f, "index.htm").exists()) {
                        f = new File(homeDir, uri + "/index.htm");
                    } else if (allowDirectoryListing && f.canRead()) {
                        String u;
                        int slash;
                        String[] files = f.list();
                        String msg = "<html><body><h1>Directory " + uri + "</h1><br/>";
                        if (uri.length() > 1 && (slash = (u = uri.substring(0, uri.length() - 1)).lastIndexOf(47)) >= 0 && slash < u.length()) {
                            msg = msg + "<b><a href=\"" + uri.substring(0, slash + 1) + "\">..</a></b><br/>";
                        }
                        if (files != null) {
                            for (int i = 0; i < files.length; ++i) {
                                File curFile = new File(f, files[i]);
                                boolean dir = curFile.isDirectory();
                                if (dir) {
                                    msg = msg + "<b>";
                                    int n = i;
                                    files[n] = files[n] + "/";
                                }
                                msg = msg + "<a href=\"" + this.encodeUri(uri + files[i]) + "\">" + files[i] + "</a>";
                                if (curFile.isFile()) {
                                    long len = curFile.length();
                                    msg = msg + " &nbsp;<font size=2>(";
                                    msg = len < 1024L ? msg + len + " bytes" : (len < 0x100000L ? msg + len / 1024L + "." + len % 1024L / 10L % 100L + " KB" : msg + len / 0x100000L + "." + len % 0x100000L / 10L % 100L + " MB");
                                    msg = msg + ")</font>";
                                }
                                msg = msg + "<br/>";
                                if (!dir) continue;
                                msg = msg + "</b>";
                            }
                        }
                        msg = msg + "</body></html>";
                        res = new Response(HTTP_OK, MIME_HTML, msg);
                    } else {
                        res = new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "FORBIDDEN: No directory listing.");
                    }
                }
            }
            try {
                if (res != null) break block35;
                String mime = null;
                int dot = f.getCanonicalPath().lastIndexOf(46);
                if (dot >= 0) {
                    mime = (String)theMimeTypes.get(f.getCanonicalPath().substring(dot + 1).toLowerCase());
                }
                if (mime == null) {
                    mime = MIME_DEFAULT_BINARY;
                }
                String etag = Integer.toHexString((f.getAbsolutePath() + f.lastModified() + "" + f.length()).hashCode());
                long startFrom = 0L;
                long endAt = -1L;
                String range = header.getProperty("range");
                if (range != null && range.startsWith("bytes=")) {
                    range = range.substring("bytes=".length());
                    int minus = range.indexOf(45);
                    try {
                        if (minus > 0) {
                            startFrom = Long.parseLong(range.substring(0, minus));
                            endAt = Long.parseLong(range.substring(minus + 1));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                long fileLen = f.length();
                if (range != null && startFrom >= 0L) {
                    if (startFrom >= fileLen) {
                        res = new Response(HTTP_RANGE_NOT_SATISFIABLE, MIME_PLAINTEXT, "");
                        res.addHeader("Content-Range", "bytes 0-0/" + fileLen);
                        res.addHeader("ETag", etag);
                    } else {
                        long newLen;
                        if (endAt < 0L) {
                            endAt = fileLen - 1L;
                        }
                        if ((newLen = endAt - startFrom + 1L) < 0L) {
                            newLen = 0L;
                        }
                        final long dataLen = newLen;
                        FileInputStream fis = new FileInputStream(f){

                            public int available() throws IOException {
                                return (int)dataLen;
                            }
                        };
                        fis.skip(startFrom);
                        res = new Response(HTTP_PARTIALCONTENT, mime, fis);
                        res.addHeader("Content-Length", "" + dataLen);
                        res.addHeader("Content-Range", "bytes " + startFrom + "-" + endAt + "/" + fileLen);
                        res.addHeader("ETag", etag);
                    }
                } else if (etag.equals(header.getProperty("if-none-match"))) {
                    res = new Response(HTTP_NOTMODIFIED, mime, "");
                } else {
                    res = new Response(HTTP_OK, mime, new FileInputStream(f));
                    res.addHeader("Content-Length", "" + fileLen);
                    res.addHeader("ETag", etag);
                }
            }
            catch (IOException ioe) {
                res = new Response(HTTP_FORBIDDEN, MIME_PLAINTEXT, "FORBIDDEN: Reading file failed.");
            }
        }
        res.addHeader("Accept-Ranges", "bytes");
        return res;
    }

    static {
        StringTokenizer st = new StringTokenizer("css            text/css htm            text/html html           text/html xml            text/xml txt            text/plain asc            text/plain gif            image/gif jpg            image/jpeg jpeg           image/jpeg png            image/png mp3            audio/mpeg m3u            audio/mpeg-url mp4            video/mp4 ogv            video/ogg flv            video/x-flv mov            video/quicktime swf            application/x-shockwave-flash js                     application/javascript pdf            application/pdf doc            application/msword ogg            application/x-ogg zip            application/octet-stream exe            application/octet-stream class          application/octet-stream ");
        while (st.hasMoreTokens()) {
            theMimeTypes.put(st.nextToken(), st.nextToken());
        }
        theBufferSize = 16384;
        myOut = System.out;
        myErr = System.err;
        gmtFrmt = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        gmtFrmt.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private class HTTPSession
    implements Runnable {
        private Socket mySocket;

        public HTTPSession(Socket s) {
            this.mySocket = s;
            Log.d((String)NanoHTTPD.LOG_TAG, (String)("NanoHTTPD: getPoolSize() = " + NanoHTTPD.this.myExecutor.getPoolSize()));
            NanoHTTPD.this.myExecutor.execute(this);
        }

        public void run() {
            try {
                Response r;
                int splitbyte;
                InputStream is = this.mySocket.getInputStream();
                if (is == null) {
                    return;
                }
                int bufsize = 8192;
                byte[] buf = new byte[bufsize];
                int rlen = is.read(buf, 0, bufsize);
                if (rlen <= 0) {
                    return;
                }
                ByteArrayInputStream hbis = new ByteArrayInputStream(buf, 0, rlen);
                BufferedReader hin = new BufferedReader(new InputStreamReader(hbis));
                Properties pre = new Properties();
                Properties parms = new Properties();
                Properties header = new Properties();
                Properties files = new Properties();
                this.decodeHeader(hin, pre, parms, header);
                String method = pre.getProperty("method");
                String uri = pre.getProperty("uri");
                long size = Long.MAX_VALUE;
                String contentLength = header.getProperty("content-length");
                if (contentLength != null) {
                    try {
                        size = Integer.parseInt(contentLength);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                boolean sbfound = false;
                for (splitbyte = 0; splitbyte < rlen; ++splitbyte) {
                    if (buf[splitbyte] != 13 || buf[++splitbyte] != 10 || buf[++splitbyte] != 13 || buf[++splitbyte] != 10) continue;
                    sbfound = true;
                    break;
                }
                ByteArrayOutputStream f = new ByteArrayOutputStream();
                if (++splitbyte < rlen) {
                    f.write(buf, splitbyte, rlen - splitbyte);
                }
                if (splitbyte < rlen) {
                    size -= (long)(rlen - splitbyte + 1);
                } else if (!sbfound || size == Long.MAX_VALUE) {
                    size = 0L;
                }
                buf = new byte[512];
                while (rlen >= 0 && size > 0L) {
                    rlen = is.read(buf, 0, 512);
                    size -= (long)rlen;
                    if (rlen <= 0) continue;
                    f.write(buf, 0, rlen);
                }
                byte[] fbuf = f.toByteArray();
                ByteArrayInputStream bin = new ByteArrayInputStream(fbuf);
                BufferedReader in = new BufferedReader(new InputStreamReader(bin));
                if (method.equalsIgnoreCase("POST")) {
                    String contentType = "";
                    String contentTypeHeader = header.getProperty("content-type");
                    StringTokenizer st = new StringTokenizer(contentTypeHeader, "; ");
                    if (st.hasMoreTokens()) {
                        contentType = st.nextToken();
                    }
                    if (contentType.equalsIgnoreCase("multipart/form-data")) {
                        String boundaryExp;
                        if (!st.hasMoreTokens()) {
                            this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Content type is multipart/form-data but boundary missing. Usage: GET /example/file.html");
                        }
                        if ((st = new StringTokenizer(boundaryExp = st.nextToken(), "=")).countTokens() != 2) {
                            this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Content type is multipart/form-data but boundary syntax error. Usage: GET /example/file.html");
                        }
                        st.nextToken();
                        String boundary = st.nextToken();
                        this.decodeMultipartData(boundary, fbuf, in, parms, files);
                    } else {
                        String postLine = "";
                        char[] pbuf = new char[512];
                        int read = in.read(pbuf);
                        while (read >= 0 && !postLine.endsWith("\r\n")) {
                            postLine = postLine + String.valueOf(pbuf, 0, read);
                            read = in.read(pbuf);
                        }
                        postLine = postLine.trim();
                        this.decodeParms(postLine, parms);
                    }
                }
                if (method.equalsIgnoreCase("PUT")) {
                    files.put("content", this.saveTmpFile(fbuf, 0, f.size()));
                }
                if ((r = NanoHTTPD.this.serve(uri, method, header, parms, files, this.mySocket)) == null) {
                    this.sendError(NanoHTTPD.HTTP_INTERNALERROR, "SERVER INTERNAL ERROR: Serve() returned a null response.");
                } else {
                    this.sendResponse(r.status, r.mimeType, r.header, r.data);
                }
                in.close();
                is.close();
            }
            catch (IOException ioe) {
                try {
                    this.sendError(NanoHTTPD.HTTP_INTERNALERROR, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
                }
                catch (Throwable throwable) {}
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private void decodeHeader(BufferedReader in, Properties pre, Properties parms, Properties header) throws InterruptedException {
            try {
                String uri;
                int qmi;
                String inLine = in.readLine();
                if (inLine == null) {
                    return;
                }
                StringTokenizer st = new StringTokenizer(inLine);
                if (!st.hasMoreTokens()) {
                    this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Syntax error. Usage: GET /example/file.html");
                }
                String method = st.nextToken();
                pre.put("method", method);
                if (!st.hasMoreTokens()) {
                    this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Missing URI. Usage: GET /example/file.html");
                }
                if ((qmi = (uri = st.nextToken()).indexOf(63)) >= 0) {
                    this.decodeParms(uri.substring(qmi + 1), parms);
                    uri = this.decodePercent(uri.substring(0, qmi));
                } else {
                    uri = this.decodePercent(uri);
                }
                if (st.hasMoreTokens()) {
                    String line = in.readLine();
                    while (line != null && line.trim().length() > 0) {
                        int p = line.indexOf(58);
                        if (p >= 0) {
                            header.put(line.substring(0, p).trim().toLowerCase(), line.substring(p + 1).trim());
                        }
                        line = in.readLine();
                    }
                }
                pre.put("uri", uri);
            }
            catch (IOException ioe) {
                this.sendError(NanoHTTPD.HTTP_INTERNALERROR, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
            }
        }

        private void decodeMultipartData(String boundary, byte[] fbuf, BufferedReader in, Properties parms, Properties files) throws InterruptedException {
            try {
                int[] bpositions = this.getBoundaryPositions(fbuf, boundary.getBytes());
                int boundarycount = 1;
                String mpline = in.readLine();
                while (mpline != null) {
                    if (mpline.indexOf(boundary) == -1) {
                        this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Content type is multipart/form-data but next chunk does not start with boundary. Usage: GET /example/file.html");
                    }
                    ++boundarycount;
                    Properties item = new Properties();
                    mpline = in.readLine();
                    while (mpline != null && mpline.trim().length() > 0) {
                        int p = mpline.indexOf(58);
                        if (p != -1) {
                            item.put(mpline.substring(0, p).trim().toLowerCase(), mpline.substring(p + 1).trim());
                        }
                        mpline = in.readLine();
                    }
                    if (mpline == null) continue;
                    String contentDisposition = item.getProperty("content-disposition");
                    if (contentDisposition == null) {
                        this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Content type is multipart/form-data but no content-disposition info found. Usage: GET /example/file.html");
                    }
                    StringTokenizer st = new StringTokenizer(contentDisposition, "; ");
                    Properties disposition = new Properties();
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        int p = token.indexOf(61);
                        if (p == -1) continue;
                        disposition.put(token.substring(0, p).trim().toLowerCase(), token.substring(p + 1).trim());
                    }
                    String pname = disposition.getProperty("name");
                    pname = pname.substring(1, pname.length() - 1);
                    String value = "";
                    if (item.getProperty("content-type") == null) {
                        while (mpline != null && mpline.indexOf(boundary) == -1) {
                            mpline = in.readLine();
                            if (mpline == null) continue;
                            int d = mpline.indexOf(boundary);
                            if (d == -1) {
                                value = value + mpline;
                                continue;
                            }
                            value = value + mpline.substring(0, d - 2);
                        }
                    } else {
                        if (boundarycount > bpositions.length) {
                            this.sendError(NanoHTTPD.HTTP_INTERNALERROR, "Error processing request");
                        }
                        int offset = this.stripMultipartHeaders(fbuf, bpositions[boundarycount - 2]);
                        String path = this.saveTmpFile(fbuf, offset, bpositions[boundarycount - 1] - offset - 4);
                        files.put(pname, path);
                        value = disposition.getProperty("filename");
                        value = value.substring(1, value.length() - 1);
                        while ((mpline = in.readLine()) != null && mpline.indexOf(boundary) == -1) {
                        }
                    }
                    parms.put(pname, value);
                }
            }
            catch (IOException ioe) {
                this.sendError(NanoHTTPD.HTTP_INTERNALERROR, "SERVER INTERNAL ERROR: IOException: " + ioe.getMessage());
            }
        }

        public int[] getBoundaryPositions(byte[] b, byte[] boundary) {
            int matchcount = 0;
            int matchbyte = -1;
            Vector<Integer> matchbytes = new Vector<Integer>();
            for (int i = 0; i < b.length; ++i) {
                if (b[i] == boundary[matchcount]) {
                    if (matchcount == 0) {
                        matchbyte = i;
                    }
                    if (++matchcount != boundary.length) continue;
                    matchbytes.addElement(new Integer(matchbyte));
                    matchcount = 0;
                    matchbyte = -1;
                    continue;
                }
                i -= matchcount;
                matchcount = 0;
                matchbyte = -1;
            }
            int[] ret = new int[matchbytes.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = (Integer)matchbytes.elementAt(i);
            }
            return ret;
        }

        private String saveTmpFile(byte[] b, int offset, int len) {
            String path = "";
            if (len > 0) {
                String tmpdir = System.getProperty("java.io.tmpdir");
                try {
                    File temp = File.createTempFile("NanoHTTPD", "", new File(tmpdir));
                    FileOutputStream fstream = new FileOutputStream(temp);
                    ((OutputStream)fstream).write(b, offset, len);
                    ((OutputStream)fstream).close();
                    path = temp.getAbsolutePath();
                }
                catch (Exception e) {
                    myErr.println("Error: " + e.getMessage());
                }
            }
            return path;
        }

        private int stripMultipartHeaders(byte[] b, int offset) {
            int i = 0;
            i = offset;
            while (i < b.length && (b[i] != 13 || b[++i] != 10 || b[++i] != 13 || b[++i] != 10)) {
                ++i;
            }
            return i + 1;
        }

        private String decodePercent(String str) throws InterruptedException {
            try {
                StringBuffer sb = new StringBuffer();
                block6: for (int i = 0; i < str.length(); ++i) {
                    char c = str.charAt(i);
                    switch (c) {
                        case '+': {
                            sb.append(' ');
                            continue block6;
                        }
                        case '%': {
                            sb.append((char)Integer.parseInt(str.substring(i + 1, i + 3), 16));
                            i += 2;
                            continue block6;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                return sb.toString();
            }
            catch (Exception e) {
                this.sendError(NanoHTTPD.HTTP_BADREQUEST, "BAD REQUEST: Bad percent-encoding.");
                return null;
            }
        }

        private void decodeParms(String parms, Properties p) throws InterruptedException {
            if (parms == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(parms, "&");
            while (st.hasMoreTokens()) {
                String e = st.nextToken();
                int sep = e.indexOf(61);
                if (sep < 0) continue;
                p.put(this.decodePercent(e.substring(0, sep)).trim(), this.decodePercent(e.substring(sep + 1)));
            }
        }

        private void sendError(String status, String msg) throws InterruptedException {
            this.sendResponse(status, NanoHTTPD.MIME_PLAINTEXT, null, new ByteArrayInputStream(msg.getBytes()));
            throw new InterruptedException();
        }

        private void sendResponse(String status, String mime, Properties header, InputStream data) {
            try {
                if (status == null) {
                    throw new Error("sendResponse(): Status can't be null.");
                }
                OutputStream out = this.mySocket.getOutputStream();
                PrintWriter pw = new PrintWriter(out);
                pw.print("HTTP/1.0 " + status + " \r\n");
                if (mime != null) {
                    pw.print("Content-Type: " + mime + "\r\n");
                }
                if (header == null || header.getProperty("Date") == null) {
                    pw.print("Date: " + gmtFrmt.format(new Date()) + "\r\n");
                }
                if (header != null) {
                    Enumeration<Object> e = header.keys();
                    while (e.hasMoreElements()) {
                        String key = (String)e.nextElement();
                        String value = header.getProperty(key);
                        pw.print(key + ": " + value + "\r\n");
                    }
                }
                pw.print("\r\n");
                pw.flush();
                if (data != null) {
                    int read;
                    byte[] buff = new byte[theBufferSize];
                    for (int pending = data.available(); pending > 0 && (read = data.read(buff, 0, pending > theBufferSize ? theBufferSize : pending)) > 0; pending -= read) {
                        out.write(buff, 0, read);
                    }
                }
                out.flush();
                out.close();
                if (data != null) {
                    data.close();
                }
            }
            catch (IOException ioe) {
                try {
                    this.mySocket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private class myThreadFactory
    implements ThreadFactory {
        private myThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread retval = new Thread(new ThreadGroup("biggerstack"), r, "HTTPD Session", 262144L);
            retval.setDaemon(true);
            return retval;
        }
    }

    public class Response {
        public String status;
        public String mimeType;
        public InputStream data;
        public Properties header = new Properties();

        public Response() {
            this.status = NanoHTTPD.HTTP_OK;
        }

        public Response(String status, String mimeType, InputStream data) {
            this.status = status;
            this.mimeType = mimeType;
            this.data = data;
        }

        public Response(String status, String mimeType, String txt) {
            this.status = status;
            this.mimeType = mimeType;
            try {
                this.data = new ByteArrayInputStream(txt.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
        }

        public void addHeader(String name, String value) {
            this.header.put(name, value);
        }
    }
}

