/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.media.MediaPlayer;
import android.media.SoundPool;
import android.net.Uri;
import android.os.Environment;
import android.provider.Contacts;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import android.widget.VideoView;
import com.google.appinventor.components.runtime.Form;
import com.google.appinventor.components.runtime.ReplForm;
import com.google.appinventor.components.runtime.util.FileUtil;
import com.google.appinventor.components.runtime.util.HoneycombMR1Util;
import com.google.appinventor.components.runtime.util.SdkLevel;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MediaUtil {
    private static final String LOG_TAG = "MediaUtil";
    private static final String REPL_ASSET_DIR = "/sdcard/AppInventor/assets/";
    private static final Map<String, File> tempFileMap = new HashMap<String, File>();
    private static ConcurrentHashMap<String, String> pathCache = new ConcurrentHashMap(2);

    private MediaUtil() {
    }

    private static String replAssetPath(String assetName) {
        return REPL_ASSET_DIR + assetName;
    }

    static String fileUrlToFilePath(String mediaPath) throws IOException {
        try {
            return new File(new URL(mediaPath).toURI()).getAbsolutePath();
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Unable to determine file path of file url " + mediaPath);
        }
        catch (Exception e) {
            throw new IOException("Unable to determine file path of file url " + mediaPath);
        }
    }

    private static MediaSource determineMediaSource(Form form, String mediaPath) {
        if (mediaPath.startsWith("/sdcard/") || mediaPath.startsWith(Environment.getExternalStorageDirectory().getAbsolutePath())) {
            return MediaSource.SDCARD;
        }
        if (mediaPath.startsWith("content://contacts/")) {
            return MediaSource.CONTACT_URI;
        }
        if (mediaPath.startsWith("content://")) {
            return MediaSource.CONTENT_URI;
        }
        try {
            new URL(mediaPath);
            if (mediaPath.startsWith("file:")) {
                return MediaSource.FILE_URL;
            }
            return MediaSource.URL;
        }
        catch (MalformedURLException malformedURLException) {
            if (form instanceof ReplForm) {
                if (((ReplForm)form).isAssetsLoaded()) {
                    return MediaSource.REPL_ASSET;
                }
                return MediaSource.ASSET;
            }
            return MediaSource.ASSET;
        }
    }

    private static String findCaseinsensitivePath(Form form, String mediaPath) throws IOException {
        if (!pathCache.containsKey(mediaPath)) {
            String newPath = MediaUtil.findCaseinsensitivePathWithoutCache(form, mediaPath);
            if (newPath == null) {
                return null;
            }
            pathCache.put(mediaPath, newPath);
        }
        return pathCache.get(mediaPath);
    }

    private static String findCaseinsensitivePathWithoutCache(Form form, String mediaPath) throws IOException {
        String[] mediaPathlist = form.getAssets().list("");
        int l = Array.getLength(mediaPathlist);
        for (int i = 0; i < l; ++i) {
            String temp = mediaPathlist[i];
            if (!temp.equalsIgnoreCase(mediaPath)) continue;
            return temp;
        }
        return null;
    }

    private static InputStream getAssetsIgnoreCaseInputStream(Form form, String mediaPath) throws IOException {
        try {
            return form.getAssets().open(mediaPath);
        }
        catch (IOException e) {
            String path = MediaUtil.findCaseinsensitivePath(form, mediaPath);
            if (path == null) {
                throw e;
            }
            return form.getAssets().open(path);
        }
    }

    private static InputStream openMedia(Form form, String mediaPath, MediaSource mediaSource) throws IOException {
        switch (mediaSource) {
            case ASSET: {
                return MediaUtil.getAssetsIgnoreCaseInputStream(form, mediaPath);
            }
            case REPL_ASSET: {
                return new FileInputStream(MediaUtil.replAssetPath(mediaPath));
            }
            case SDCARD: {
                return new FileInputStream(mediaPath);
            }
            case FILE_URL: 
            case URL: {
                return new URL(mediaPath).openStream();
            }
            case CONTENT_URI: {
                return form.getContentResolver().openInputStream(Uri.parse((String)mediaPath));
            }
            case CONTACT_URI: {
                InputStream is = null;
                is = SdkLevel.getLevel() >= 12 ? HoneycombMR1Util.openContactPhotoInputStreamHelper(form.getContentResolver(), Uri.parse((String)mediaPath)) : Contacts.People.openContactPhotoInputStream((ContentResolver)form.getContentResolver(), (Uri)Uri.parse((String)mediaPath));
                if (is != null) {
                    return is;
                }
                throw new IOException("Unable to open contact photo " + mediaPath + ".");
            }
        }
        throw new IOException("Unable to open media " + mediaPath + ".");
    }

    public static InputStream openMedia(Form form, String mediaPath) throws IOException {
        return MediaUtil.openMedia(form, mediaPath, MediaUtil.determineMediaSource(form, mediaPath));
    }

    public static File copyMediaToTempFile(Form form, String mediaPath) throws IOException {
        MediaSource mediaSource = MediaUtil.determineMediaSource(form, mediaPath);
        return MediaUtil.copyMediaToTempFile(form, mediaPath, mediaSource);
    }

    private static File copyMediaToTempFile(Form form, String mediaPath, MediaSource mediaSource) throws IOException {
        InputStream in = MediaUtil.openMedia(form, mediaPath, mediaSource);
        File file = null;
        try {
            file = File.createTempFile("AI_Media_", null);
            file.deleteOnExit();
            FileUtil.writeStreamToFile(in, file.getAbsolutePath());
            File file2 = file;
            return file2;
        }
        catch (IOException e) {
            if (file != null) {
                Log.e((String)LOG_TAG, (String)("Could not copy media " + mediaPath + " to temp file " + file.getAbsolutePath()));
                file.delete();
            } else {
                Log.e((String)LOG_TAG, (String)("Could not copy media " + mediaPath + " to temp file."));
            }
            throw e;
        }
        finally {
            in.close();
        }
    }

    private static File cacheMediaTempFile(Form form, String mediaPath, MediaSource mediaSource) throws IOException {
        File tempFile = tempFileMap.get(mediaPath);
        if (tempFile == null || !tempFile.exists()) {
            Log.i((String)LOG_TAG, (String)("Copying media " + mediaPath + " to temp file..."));
            tempFile = MediaUtil.copyMediaToTempFile(form, mediaPath, mediaSource);
            Log.i((String)LOG_TAG, (String)("Finished copying media " + mediaPath + " to temp file " + tempFile.getAbsolutePath()));
            tempFileMap.put(mediaPath, tempFile);
        }
        return tempFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BitmapDrawable getBitmapDrawable(Form form, String mediaPath) throws IOException {
        BitmapFactory.Options options;
        InputStream is1;
        if (mediaPath == null || mediaPath.length() == 0) {
            return null;
        }
        MediaSource mediaSource = MediaUtil.determineMediaSource(form, mediaPath);
        try {
            is1 = MediaUtil.openMedia(form, mediaPath, mediaSource);
        }
        catch (IOException e) {
            if (mediaSource == MediaSource.CONTACT_URI) {
                return new BitmapDrawable(BitmapFactory.decodeResource((Resources)form.getResources(), (int)17301606, null));
            }
            throw e;
        }
        try {
            options = MediaUtil.getBitmapOptions(form, is1, mediaPath);
        }
        finally {
            is1.close();
        }
        InputStream is2 = MediaUtil.openMedia(form, mediaPath, mediaSource);
        try {
            Log.d((String)LOG_TAG, (String)("mediaPath = " + mediaPath));
            BitmapDrawable originalBitmapDrawable = new BitmapDrawable(MediaUtil.decodeStream(is2, null, options));
            originalBitmapDrawable.setTargetDensity(form.getResources().getDisplayMetrics());
            if (options.inSampleSize != 1 || form.deviceDensity() == 1.0f) {
                BitmapDrawable bitmapDrawable = originalBitmapDrawable;
                return bitmapDrawable;
            }
            int scaledWidth = (int)(form.deviceDensity() * (float)originalBitmapDrawable.getIntrinsicWidth());
            int scaledHeight = (int)(form.deviceDensity() * (float)originalBitmapDrawable.getIntrinsicHeight());
            Log.d((String)LOG_TAG, (String)("form.deviceDensity() = " + form.deviceDensity()));
            Log.d((String)LOG_TAG, (String)("originalBitmapDrawable.getIntrinsicWidth() = " + originalBitmapDrawable.getIntrinsicWidth()));
            Log.d((String)LOG_TAG, (String)("originalBitmapDrawable.getIntrinsicHeight() = " + originalBitmapDrawable.getIntrinsicHeight()));
            Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)originalBitmapDrawable.getBitmap(), (int)scaledWidth, (int)scaledHeight, (boolean)false);
            BitmapDrawable scaledBitmapDrawable = new BitmapDrawable(scaledBitmap);
            scaledBitmapDrawable.setTargetDensity(form.getResources().getDisplayMetrics());
            originalBitmapDrawable = null;
            System.gc();
            BitmapDrawable bitmapDrawable = scaledBitmapDrawable;
            return bitmapDrawable;
        }
        finally {
            if (is2 != null) {
                is2.close();
            }
        }
    }

    private static Bitmap decodeStream(InputStream is, Rect outPadding, BitmapFactory.Options opts) {
        return BitmapFactory.decodeStream((InputStream)new FlushedInputStream(is), (Rect)outPadding, (BitmapFactory.Options)opts);
    }

    private static BitmapFactory.Options getBitmapOptions(Form form, InputStream is, String mediaPath) {
        int maxHeight;
        int maxWidth;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        MediaUtil.decodeStream(is, null, options);
        int imageWidth = options.outWidth;
        int imageHeight = options.outHeight;
        Display display = ((WindowManager)form.getSystemService("window")).getDefaultDisplay();
        if (form.getCompatibilityMode()) {
            maxWidth = 720;
            maxHeight = 840;
        } else {
            maxWidth = (int)((float)display.getWidth() / form.deviceDensity());
            maxHeight = (int)((float)display.getHeight() / form.deviceDensity());
        }
        int sampleSize = 1;
        while (imageWidth / sampleSize > maxWidth && imageHeight / sampleSize > maxHeight) {
            sampleSize *= 2;
        }
        options = new BitmapFactory.Options();
        Log.d((String)LOG_TAG, (String)("getBitmapOptions: sampleSize = " + sampleSize + " mediaPath = " + mediaPath + " maxWidth = " + maxWidth + " maxHeight = " + maxHeight + " display width = " + display.getWidth() + " display height = " + display.getHeight()));
        options.inSampleSize = sampleSize;
        return options;
    }

    private static AssetFileDescriptor getAssetsIgnoreCaseAfd(Form form, String mediaPath) throws IOException {
        try {
            return form.getAssets().openFd(mediaPath);
        }
        catch (IOException e) {
            String path = MediaUtil.findCaseinsensitivePath(form, mediaPath);
            if (path == null) {
                throw e;
            }
            return form.getAssets().openFd(path);
        }
    }

    public static int loadSoundPool(SoundPool soundPool, Form form, String mediaPath) throws IOException {
        MediaSource mediaSource = MediaUtil.determineMediaSource(form, mediaPath);
        switch (mediaSource) {
            case ASSET: {
                return soundPool.load(MediaUtil.getAssetsIgnoreCaseAfd(form, mediaPath), 1);
            }
            case REPL_ASSET: {
                return soundPool.load(MediaUtil.replAssetPath(mediaPath), 1);
            }
            case SDCARD: {
                return soundPool.load(mediaPath, 1);
            }
            case FILE_URL: {
                return soundPool.load(MediaUtil.fileUrlToFilePath(mediaPath), 1);
            }
            case URL: 
            case CONTENT_URI: {
                File tempFile = MediaUtil.cacheMediaTempFile(form, mediaPath, mediaSource);
                return soundPool.load(tempFile.getAbsolutePath(), 1);
            }
            case CONTACT_URI: {
                throw new IOException("Unable to load audio for contact " + mediaPath + ".");
            }
        }
        throw new IOException("Unable to load audio " + mediaPath + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadMediaPlayer(MediaPlayer mediaPlayer, Form form, String mediaPath) throws IOException {
        MediaSource mediaSource = MediaUtil.determineMediaSource(form, mediaPath);
        switch (mediaSource) {
            case ASSET: {
                AssetFileDescriptor afd = MediaUtil.getAssetsIgnoreCaseAfd(form, mediaPath);
                try {
                    FileDescriptor fd = afd.getFileDescriptor();
                    long offset = afd.getStartOffset();
                    long length = afd.getLength();
                    mediaPlayer.setDataSource(fd, offset, length);
                }
                finally {
                    afd.close();
                }
                return;
            }
            case REPL_ASSET: {
                mediaPlayer.setDataSource(MediaUtil.replAssetPath(mediaPath));
                return;
            }
            case SDCARD: {
                mediaPlayer.setDataSource(mediaPath);
                return;
            }
            case FILE_URL: {
                mediaPlayer.setDataSource(MediaUtil.fileUrlToFilePath(mediaPath));
                return;
            }
            case URL: {
                mediaPlayer.setDataSource(mediaPath);
                return;
            }
            case CONTENT_URI: {
                mediaPlayer.setDataSource((Context)form, Uri.parse((String)mediaPath));
                return;
            }
            case CONTACT_URI: {
                throw new IOException("Unable to load audio or video for contact " + mediaPath + ".");
            }
        }
        throw new IOException("Unable to load audio or video " + mediaPath + ".");
    }

    public static void loadVideoView(VideoView videoView, Form form, String mediaPath) throws IOException {
        MediaSource mediaSource = MediaUtil.determineMediaSource(form, mediaPath);
        switch (mediaSource) {
            case ASSET: 
            case URL: {
                File tempFile = MediaUtil.cacheMediaTempFile(form, mediaPath, mediaSource);
                videoView.setVideoPath(tempFile.getAbsolutePath());
                return;
            }
            case REPL_ASSET: {
                videoView.setVideoPath(MediaUtil.replAssetPath(mediaPath));
                return;
            }
            case SDCARD: {
                videoView.setVideoPath(mediaPath);
                return;
            }
            case FILE_URL: {
                videoView.setVideoPath(MediaUtil.fileUrlToFilePath(mediaPath));
                return;
            }
            case CONTENT_URI: {
                videoView.setVideoURI(Uri.parse((String)mediaPath));
                return;
            }
            case CONTACT_URI: {
                throw new IOException("Unable to load video for contact " + mediaPath + ".");
            }
        }
        throw new IOException("Unable to load video " + mediaPath + ".");
    }

    private static class FlushedInputStream
    extends FilterInputStream {
        public FlushedInputStream(InputStream inputStream) {
            super(inputStream);
        }

        public long skip(long n) throws IOException {
            long totalBytesSkipped;
            long bytesSkipped;
            for (totalBytesSkipped = 0L; totalBytesSkipped < n; totalBytesSkipped += bytesSkipped) {
                bytesSkipped = this.in.skip(n - totalBytesSkipped);
                if (bytesSkipped != 0L) continue;
                if (this.read() < 0) break;
                bytesSkipped = 1L;
            }
            return totalBytesSkipped;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MediaSource {
        ASSET,
        REPL_ASSET,
        SDCARD,
        FILE_URL,
        URL,
        CONTENT_URI,
        CONTACT_URI;

    }
}

