/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import com.google.appinventor.components.runtime.util.YailList;
import gnu.lists.FString;
import gnu.math.IntFraction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUtil {
    private JsonUtil() {
    }

    public static List<String> getStringListFromJsonArray(JSONArray jArray) throws JSONException {
        ArrayList<String> returnList = new ArrayList<String>();
        for (int i = 0; i < jArray.length(); ++i) {
            String val = jArray.getString(i);
            returnList.add(val);
        }
        return returnList;
    }

    public static List<Object> getListFromJsonArray(JSONArray jArray) throws JSONException {
        ArrayList<Object> returnList = new ArrayList<Object>();
        for (int i = 0; i < jArray.length(); ++i) {
            returnList.add(JsonUtil.convertJsonItem(jArray.get(i)));
        }
        return returnList;
    }

    public static List<Object> getListFromJsonObject(JSONObject jObject) throws JSONException {
        ArrayList<Object> returnList = new ArrayList<Object>();
        Iterator keys = jObject.keys();
        ArrayList keysList = new ArrayList();
        while (keys.hasNext()) {
            keysList.add(keys.next());
        }
        Collections.sort(keysList);
        for (String key : keysList) {
            ArrayList<Object> nestedList = new ArrayList<Object>();
            nestedList.add(key);
            nestedList.add(JsonUtil.convertJsonItem(jObject.get(key)));
            returnList.add(nestedList);
        }
        return returnList;
    }

    public static Object convertJsonItem(Object o) throws JSONException {
        if (o == null) {
            return "null";
        }
        if (o instanceof JSONObject) {
            return JsonUtil.getListFromJsonObject((JSONObject)o);
        }
        if (o instanceof JSONArray) {
            return JsonUtil.getListFromJsonArray((JSONArray)o);
        }
        if (o.equals(Boolean.FALSE) || o instanceof String && ((String)o).equalsIgnoreCase("false")) {
            return false;
        }
        if (o.equals(Boolean.TRUE) || o instanceof String && ((String)o).equalsIgnoreCase("true")) {
            return true;
        }
        if (o instanceof Number) {
            return o;
        }
        return o.toString();
    }

    public static String getJsonRepresentation(Object value) throws JSONException {
        if (value == null || value.equals(null)) {
            return "null";
        }
        if (value instanceof FString) {
            return JSONObject.quote((String)value.toString());
        }
        if (value instanceof YailList) {
            return ((YailList)value).toJSONString();
        }
        if (value instanceof IntFraction) {
            return JSONObject.numberToString((Number)((IntFraction)value).doubleValue());
        }
        if (value instanceof Number) {
            return JSONObject.numberToString((Number)((Number)value));
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            String separator = "";
            for (Object o : (Object[])value) {
                sb.append(separator).append(JsonUtil.getJsonRepresentation(o));
                separator = ",";
            }
            sb.append("]");
            return sb.toString();
        }
        return JSONObject.quote((String)value.toString());
    }

    public static Object getObjectFromJson(String jsonString) throws JSONException {
        if (jsonString == null || jsonString.equals("")) {
            return "";
        }
        Object value = new JSONTokener(jsonString).nextValue();
        if (value == null || value.equals(null)) {
            return null;
        }
        if (value instanceof String || value instanceof Number || value instanceof Boolean) {
            return value;
        }
        if (value instanceof JSONArray) {
            return JsonUtil.getListFromJsonArray((JSONArray)value);
        }
        if (value instanceof JSONObject) {
            return JsonUtil.getListFromJsonObject((JSONObject)value);
        }
        throw new JSONException("Invalid JSON string.");
    }
}

