/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.speech.tts.TextToSpeech;
import android.util.Log;
import com.google.appinventor.components.runtime.util.ITextToSpeech;
import java.util.HashMap;
import java.util.Locale;

public class InternalTextToSpeech
implements ITextToSpeech {
    private static final String LOG_TAG = "InternalTTS";
    private final Activity activity;
    private final ITextToSpeech.TextToSpeechCallback callback;
    private TextToSpeech tts;
    private volatile boolean isTtsInitialized;
    private Handler mHandler = new Handler();
    private int nextUtteranceId = 1;
    private int ttsRetryDelay = 500;
    private int ttsMaxRetries = 20;

    public InternalTextToSpeech(Activity activity, ITextToSpeech.TextToSpeechCallback callback) {
        this.activity = activity;
        this.callback = callback;
        this.initializeTts();
    }

    private void initializeTts() {
        if (this.tts == null) {
            Log.d((String)LOG_TAG, (String)"INTERNAL TTS is reinitializing");
            this.tts = new TextToSpeech((Context)this.activity, new TextToSpeech.OnInitListener(){

                public void onInit(int status) {
                    if (status == 0) {
                        InternalTextToSpeech.this.isTtsInitialized = true;
                    }
                }
            });
        }
    }

    public void speak(String message, Locale loc) {
        Log.d((String)LOG_TAG, (String)"Internal TTS got speak");
        this.speak(message, loc, 0);
    }

    public boolean isInitialized() {
        return this.isTtsInitialized;
    }

    private void speak(final String message, final Locale loc, final int retries) {
        Log.d((String)LOG_TAG, (String)("InternalTTS speak called, message = " + message));
        if (retries > this.ttsMaxRetries) {
            Log.d((String)LOG_TAG, (String)"max number of speak retries exceeded: speak will fail");
            this.callback.onFailure();
        }
        if (this.isTtsInitialized) {
            Log.d((String)LOG_TAG, (String)("TTS initialized after " + retries + " retries."));
            this.tts.setLanguage(loc);
            this.tts.setOnUtteranceCompletedListener(new TextToSpeech.OnUtteranceCompletedListener(){

                public void onUtteranceCompleted(String utteranceId) {
                    InternalTextToSpeech.this.activity.runOnUiThread(new Runnable(){

                        public void run() {
                            InternalTextToSpeech.this.callback.onSuccess();
                        }
                    });
                }
            });
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("utteranceId", Integer.toString(this.nextUtteranceId++));
            int result = this.tts.speak(message, 0, params);
            if (result == -1) {
                Log.d((String)LOG_TAG, (String)"speak called and tts.speak result was an error");
                this.callback.onFailure();
            }
        } else {
            Log.d((String)LOG_TAG, (String)"speak called when TTS not initialized");
            this.mHandler.postDelayed(new Runnable(){

                public void run() {
                    Log.d((String)InternalTextToSpeech.LOG_TAG, (String)("delaying call to speak.  Retries is: " + retries + " Message is: " + message));
                    InternalTextToSpeech.this.speak(message, loc, retries + 1);
                }
            }, (long)this.ttsRetryDelay);
        }
    }

    public void onStop() {
        Log.d((String)LOG_TAG, (String)"Internal TTS got onStop");
    }

    public void onDestroy() {
        Log.d((String)LOG_TAG, (String)"Internal TTS got onDestroy");
        if (this.tts != null) {
            this.tts.shutdown();
            this.isTtsInitialized = false;
            this.tts = null;
        }
    }

    public void onResume() {
        Log.d((String)LOG_TAG, (String)"Internal TTS got onResume");
        this.initializeTts();
    }

    public void setPitch(float pitch) {
        this.tts.setPitch(pitch);
    }

    public void setSpeechRate(float speechRate) {
        this.tts.setSpeechRate(speechRate);
    }

    public int isLanguageAvailable(Locale loc) {
        return this.tts.isLanguageAvailable(loc);
    }
}

