/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.Ndef;
import android.nfc.tech.NdefFormatable;
import android.os.Parcelable;
import android.util.Log;
import com.google.appinventor.components.runtime.NearField;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookieStore;
import java.nio.charset.Charset;
import java.util.Locale;

public class GingerbreadUtil {
    private GingerbreadUtil() {
    }

    public static CookieHandler newCookieManager() {
        return new CookieManager();
    }

    public static boolean clearCookies(CookieHandler cookieHandler) {
        CookieManager cookieManager;
        CookieStore cookieStore;
        if (cookieHandler instanceof CookieManager && (cookieStore = (cookieManager = (CookieManager)cookieHandler).getCookieStore()) != null) {
            cookieStore.removeAll();
            return true;
        }
        return false;
    }

    public static NfcAdapter newNfcAdapter(Context context) {
        return NfcAdapter.getDefaultAdapter((Context)context);
    }

    public static void enableNFCWriteMode(Activity activity, NfcAdapter nfcAdapter, String textToWrite) {
        NdefRecord textRecord = GingerbreadUtil.createTextRecord(textToWrite, true);
        NdefMessage msg = new NdefMessage(new NdefRecord[]{textRecord});
        nfcAdapter.enableForegroundNdefPush(activity, msg);
    }

    public static void disableNFCAdapter(Activity activity, NfcAdapter nfcAdapter) {
        nfcAdapter.disableForegroundNdefPush(activity);
    }

    public static NdefRecord createTextRecord(String payload, boolean encodeInUtf8) {
        byte[] langBytes = Locale.getDefault().getLanguage().getBytes(Charset.forName("US-ASCII"));
        Charset utfEncoding = encodeInUtf8 ? Charset.forName("UTF-8") : Charset.forName("UTF-16");
        byte[] textBytes = payload.getBytes(utfEncoding);
        int utfBit = encodeInUtf8 ? 0 : 128;
        char status = (char)(utfBit + langBytes.length);
        byte[] data = new byte[1 + langBytes.length + textBytes.length];
        data[0] = (byte)status;
        System.arraycopy(langBytes, 0, data, 1, langBytes.length);
        System.arraycopy(textBytes, 0, data, 1 + langBytes.length, textBytes.length);
        NdefRecord record = new NdefRecord(1, NdefRecord.RTD_TEXT, new byte[0], data);
        return record;
    }

    public static void resolveNFCIntent(Intent intent, NearField nfc) {
        String action = intent.getAction();
        if ("android.nfc.action.NDEF_DISCOVERED".equals(action)) {
            if (nfc.ReadMode()) {
                NdefMessage[] msgs;
                Parcelable[] rawMsgs = intent.getParcelableArrayExtra("android.nfc.extra.NDEF_MESSAGES");
                if (rawMsgs != null) {
                    msgs = new NdefMessage[rawMsgs.length];
                    for (int i = 0; i < rawMsgs.length; ++i) {
                        msgs[i] = (NdefMessage)rawMsgs[i];
                    }
                } else {
                    byte[] empty = new byte[]{};
                    NdefRecord record = new NdefRecord(5, empty, empty, empty);
                    NdefMessage msg = new NdefMessage(new NdefRecord[]{record});
                    msgs = new NdefMessage[]{msg};
                }
                byte[] payload = msgs[0].getRecords()[0].getPayload();
                String message = new String(payload).substring(3);
                nfc.TagRead(message);
            } else {
                Tag detectedTag = (Tag)intent.getParcelableExtra("android.nfc.extra.TAG");
                NdefMessage msg = null;
                if (nfc.WriteType() == 1) {
                    NdefRecord textRecord = GingerbreadUtil.createTextRecord(nfc.TextToWrite(), true);
                    msg = new NdefMessage(new NdefRecord[]{textRecord});
                }
                if (GingerbreadUtil.writeNFCTag(msg, detectedTag)) {
                    nfc.TagWritten();
                }
            }
        } else {
            Log.e((String)"nearfield", (String)("Unknown intent " + intent));
        }
    }

    public static boolean writeNFCTag(NdefMessage message, Tag tag) {
        int size = message.toByteArray().length;
        try {
            Ndef ndef = Ndef.get((Tag)tag);
            if (ndef != null) {
                ndef.connect();
                if (!ndef.isWritable()) {
                    return false;
                }
                if (ndef.getMaxSize() < size) {
                    return false;
                }
                ndef.writeNdefMessage(message);
                return true;
            }
            NdefFormatable format = NdefFormatable.get((Tag)tag);
            if (format != null) {
                try {
                    format.connect();
                    format.format(message);
                    return true;
                }
                catch (IOException e) {
                    return false;
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

