/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import com.google.appinventor.components.runtime.util.PlayerListDelta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameInstance {
    private String instanceId;
    private String leader;
    private List<String> players = new ArrayList<String>(0);
    private Map<String, String> messageTimes = new HashMap<String, String>();

    public GameInstance(String instanceId) {
        this.instanceId = instanceId;
        this.leader = "";
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getLeader() {
        return this.leader;
    }

    public void setLeader(String leader) {
        this.leader = leader;
    }

    public PlayerListDelta setPlayers(List<String> newPlayersList) {
        if (newPlayersList.equals(this.players)) {
            return PlayerListDelta.NO_CHANGE;
        }
        List<String> removed = this.players;
        ArrayList<String> added = new ArrayList<String>(newPlayersList);
        this.players = new ArrayList<String>(newPlayersList);
        added.removeAll(removed);
        removed.removeAll(newPlayersList);
        if (added.size() == 0 && removed.size() == 0) {
            return PlayerListDelta.NO_CHANGE;
        }
        return new PlayerListDelta(removed, added);
    }

    public List<String> getPlayers() {
        return this.players;
    }

    public String getMessageTime(String type) {
        if (this.messageTimes.containsKey(type)) {
            return this.messageTimes.get(type);
        }
        return "";
    }

    public void putMessageTime(String type, String time) {
        this.messageTimes.put(type, time);
    }
}

