/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import android.app.Dialog;
import android.content.Context;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.MediaController;
import android.widget.VideoView;
import com.google.appinventor.components.runtime.Form;
import com.google.appinventor.components.runtime.VideoPlayer;
import com.google.appinventor.components.runtime.util.CustomMediaController;
import com.google.appinventor.components.runtime.util.MediaUtil;
import com.google.appinventor.components.runtime.util.SdkLevel;
import java.io.IOException;

public class FullScreenVideoUtil
implements MediaPlayer.OnCompletionListener,
MediaPlayer.OnPreparedListener {
    public static final int FULLSCREEN_VIDEO_DIALOG_FLAG = 189;
    public static final int FULLSCREEN_VIDEO_ACTION_SEEK = 190;
    public static final int FULLSCREEN_VIDEO_ACTION_PLAY = 191;
    public static final int FULLSCREEN_VIDEO_ACTION_PAUSE = 192;
    public static final int FULLSCREEN_VIDEO_ACTION_STOP = 193;
    public static final int FULLSCREEN_VIDEO_ACTION_SOURCE = 194;
    public static final int FULLSCREEN_VIDEO_ACTION_FULLSCREEN = 195;
    public static final int FULLSCREEN_VIDEO_ACTION_DURATION = 196;
    public static final String VIDEOPLAYER_FULLSCREEN = "FullScreenKey";
    public static final String VIDEOPLAYER_PLAYING = "PlayingKey";
    public static final String VIDEOPLAYER_POSITION = "PositionKey";
    public static final String VIDEOPLAYER_SOURCE = "SourceKey";
    public static final String ACTION_SUCESS = "ActionSuccess";
    public static final String ACTION_DATA = "ActionData";
    private Dialog mFullScreenVideoDialog;
    private FrameLayout mFullScreenVideoHolder;
    private VideoView mFullScreenVideoView;
    private CustomMediaController mFullScreenVideoController;
    private FrameLayout.LayoutParams mMediaControllerParams = new FrameLayout.LayoutParams(-1, -2, 80);
    private Form mForm;
    private VideoPlayer mFullScreenPlayer = null;
    private Bundle mFullScreenVideoBundle;
    private Handler mHandler;

    public FullScreenVideoUtil(Form form, Handler handler) {
        this.mForm = form;
        this.mHandler = handler;
        this.mFullScreenVideoDialog = SdkLevel.getLevel() > 4 ? new Dialog((Context)this.mForm, 16973831){

            public void onBackPressed() {
                Bundle values = new Bundle();
                values.putInt(FullScreenVideoUtil.VIDEOPLAYER_POSITION, FullScreenVideoUtil.this.mFullScreenVideoView.getCurrentPosition());
                values.putBoolean(FullScreenVideoUtil.VIDEOPLAYER_PLAYING, FullScreenVideoUtil.this.mFullScreenVideoView.isPlaying());
                values.putString(FullScreenVideoUtil.VIDEOPLAYER_SOURCE, FullScreenVideoUtil.this.mFullScreenVideoBundle.getString(FullScreenVideoUtil.VIDEOPLAYER_SOURCE));
                FullScreenVideoUtil.this.mFullScreenPlayer.fullScreenKilled(values);
                super.onBackPressed();
            }

            public void onStart() {
                super.onStart();
                FullScreenVideoUtil.this.startDialog();
            }
        } : new Dialog((Context)this.mForm, 16973831){

            protected void onStop() {
                Bundle values = new Bundle();
                values.putInt(FullScreenVideoUtil.VIDEOPLAYER_POSITION, FullScreenVideoUtil.this.mFullScreenVideoView.getCurrentPosition());
                values.putBoolean(FullScreenVideoUtil.VIDEOPLAYER_PLAYING, FullScreenVideoUtil.this.mFullScreenVideoView.isPlaying());
                values.putString(FullScreenVideoUtil.VIDEOPLAYER_SOURCE, FullScreenVideoUtil.this.mFullScreenVideoBundle.getString(FullScreenVideoUtil.VIDEOPLAYER_SOURCE));
                FullScreenVideoUtil.this.mFullScreenPlayer.fullScreenKilled(values);
                super.onStop();
            }

            public void onStart() {
                super.onStart();
                FullScreenVideoUtil.this.startDialog();
            }
        };
    }

    public synchronized Bundle performAction(int action, VideoPlayer source, Object data) {
        Log.i((String)"Form.fullScreenVideoAction", (String)("Actions:" + action + " Source:" + source + ": Current Source:" + this.mFullScreenPlayer + " Data:" + data));
        Bundle result = new Bundle();
        result.putBoolean(ACTION_SUCESS, true);
        if (source == this.mFullScreenPlayer) {
            switch (action) {
                case 195: {
                    return this.doFullScreenVideoAction(source, (Bundle)data);
                }
                case 192: {
                    if (this.showing()) {
                        this.mFullScreenVideoView.pause();
                        return result;
                    }
                    result.putBoolean(ACTION_SUCESS, false);
                    return result;
                }
                case 191: {
                    if (this.showing()) {
                        this.mFullScreenVideoView.start();
                        return result;
                    }
                    result.putBoolean(ACTION_SUCESS, false);
                    return result;
                }
                case 190: {
                    if (this.showing()) {
                        this.mFullScreenVideoView.seekTo(((Integer)data).intValue());
                        return result;
                    }
                    result.putBoolean(ACTION_SUCESS, false);
                    return result;
                }
                case 193: {
                    if (this.showing()) {
                        this.mFullScreenVideoView.stopPlayback();
                        return result;
                    }
                    result.putBoolean(ACTION_SUCESS, false);
                    return result;
                }
                case 194: {
                    if (this.showing()) {
                        result.putBoolean(ACTION_SUCESS, this.setSource((String)data, true));
                        return result;
                    }
                    result.putBoolean(ACTION_SUCESS, false);
                    return result;
                }
                case 196: {
                    if (this.showing()) {
                        result.putInt(ACTION_DATA, this.mFullScreenVideoView.getDuration());
                        return result;
                    }
                    result.putBoolean(ACTION_SUCESS, false);
                    return result;
                }
            }
        } else if (action == 195) {
            if (this.showing() && this.mFullScreenPlayer != null) {
                Bundle values = new Bundle();
                values.putInt(VIDEOPLAYER_POSITION, this.mFullScreenVideoView.getCurrentPosition());
                values.putBoolean(VIDEOPLAYER_PLAYING, this.mFullScreenVideoView.isPlaying());
                values.putString(VIDEOPLAYER_SOURCE, this.mFullScreenVideoBundle.getString(VIDEOPLAYER_SOURCE));
                this.mFullScreenPlayer.fullScreenKilled(values);
            }
            return this.doFullScreenVideoAction(source, (Bundle)data);
        }
        result.putBoolean(ACTION_SUCESS, false);
        return result;
    }

    private Bundle doFullScreenVideoAction(VideoPlayer source, Bundle data) {
        Log.i((String)"Form.doFullScreenVideoAction", (String)("Source:" + source + " Data:" + data));
        Bundle result = new Bundle();
        result.putBoolean(ACTION_SUCESS, true);
        if (data.getBoolean(VIDEOPLAYER_FULLSCREEN)) {
            this.mFullScreenPlayer = source;
            this.mFullScreenVideoBundle = data;
            if (!this.mFullScreenVideoDialog.isShowing()) {
                this.mForm.showDialog(189);
                return result;
            }
            this.mFullScreenVideoView.pause();
            result.putBoolean(ACTION_SUCESS, this.setSource(this.mFullScreenVideoBundle.getString(VIDEOPLAYER_SOURCE), false));
            return result;
        }
        if (this.showing()) {
            result.putBoolean(VIDEOPLAYER_PLAYING, this.mFullScreenVideoView.isPlaying());
            result.putInt(VIDEOPLAYER_POSITION, this.mFullScreenVideoView.getCurrentPosition());
            result.putString(VIDEOPLAYER_SOURCE, this.mFullScreenVideoBundle.getString(VIDEOPLAYER_SOURCE));
            this.mFullScreenPlayer = null;
            this.mFullScreenVideoBundle = null;
            this.mForm.dismissDialog(189);
            return result;
        }
        result.putBoolean(ACTION_SUCESS, false);
        return result;
    }

    public Dialog createFullScreenVideoDialog() {
        if (this.mFullScreenVideoBundle == null) {
            Log.i((String)"Form.createFullScreenVideoDialog", (String)"mFullScreenVideoBundle is null");
        }
        this.mFullScreenVideoView = new VideoView((Context)this.mForm);
        this.mFullScreenVideoHolder = new FrameLayout((Context)this.mForm);
        this.mFullScreenVideoController = new CustomMediaController((Context)this.mForm);
        this.mFullScreenVideoView.setId(this.mFullScreenVideoView.hashCode());
        this.mFullScreenVideoHolder.setId(this.mFullScreenVideoHolder.hashCode());
        this.mFullScreenVideoView.setMediaController((MediaController)this.mFullScreenVideoController);
        this.mFullScreenVideoView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View arg0, MotionEvent arg1) {
                Log.i((String)"FullScreenVideoUtil..onTouch", (String)"Video Touched!!");
                return false;
            }
        });
        this.mFullScreenVideoController.setAnchorView((View)this.mFullScreenVideoView);
        String orientation = this.mForm.ScreenOrientation();
        if (orientation.equals("landscape") || orientation.equals("sensorLandscape") || orientation.equals("reverseLandscape")) {
            this.mFullScreenVideoView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1, 17));
        } else {
            this.mFullScreenVideoView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2, 17));
        }
        this.mFullScreenVideoHolder.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mFullScreenVideoHolder.addView((View)this.mFullScreenVideoView);
        this.mFullScreenVideoController.addTo((ViewGroup)this.mFullScreenVideoHolder, (ViewGroup.LayoutParams)this.mMediaControllerParams);
        this.mFullScreenVideoDialog.setContentView((View)this.mFullScreenVideoHolder);
        return this.mFullScreenVideoDialog;
    }

    public void prepareFullScreenVideoDialog(Dialog dia) {
        this.mFullScreenVideoView.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
        this.mFullScreenVideoView.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
    }

    public boolean dialogInitialized() {
        return this.mFullScreenVideoDialog != null;
    }

    public boolean showing() {
        return this.dialogInitialized() && this.mFullScreenVideoDialog.isShowing();
    }

    public boolean setSource(String source, boolean clearSeek) {
        try {
            if (clearSeek) {
                this.mFullScreenVideoBundle.putInt(VIDEOPLAYER_POSITION, 0);
            }
            MediaUtil.loadVideoView(this.mFullScreenVideoView, this.mForm, source);
            this.mFullScreenVideoBundle.putString(VIDEOPLAYER_SOURCE, source);
            return true;
        }
        catch (IOException e) {
            this.mForm.dispatchErrorOccurredEvent(this.mFullScreenPlayer, "Source", 701, source);
            return false;
        }
    }

    public void onCompletion(MediaPlayer arg0) {
        if (this.mFullScreenPlayer != null) {
            this.mFullScreenPlayer.Completed();
        }
    }

    public void onPrepared(MediaPlayer arg0) {
        Log.i((String)"FullScreenVideoUtil..onPrepared", (String)("Seeking to:" + this.mFullScreenVideoBundle.getInt(VIDEOPLAYER_POSITION)));
        this.mFullScreenVideoView.seekTo(this.mFullScreenVideoBundle.getInt(VIDEOPLAYER_POSITION));
        if (this.mFullScreenVideoBundle.getBoolean(VIDEOPLAYER_PLAYING)) {
            this.mFullScreenVideoView.start();
        } else {
            this.mFullScreenVideoView.start();
            this.mHandler.postDelayed(new Runnable(){

                public void run() {
                    FullScreenVideoUtil.this.mFullScreenVideoView.pause();
                }
            }, 100L);
        }
    }

    public void startDialog() {
        try {
            MediaUtil.loadVideoView(this.mFullScreenVideoView, this.mForm, this.mFullScreenVideoBundle.getString(VIDEOPLAYER_SOURCE));
        }
        catch (IOException e) {
            this.mForm.dispatchErrorOccurredEvent(this.mFullScreenPlayer, "Source", 701, this.mFullScreenVideoBundle.getString(VIDEOPLAYER_SOURCE));
            return;
        }
    }
}

