/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import android.app.Activity;
import android.media.AudioManager;
import android.net.http.SslError;
import android.view.Display;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.Form;
import com.google.appinventor.components.runtime.Player;

public class FroyoUtil {
    private FroyoUtil() {
    }

    public static int getRotation(Display display) {
        return display.getRotation();
    }

    public static AudioManager setAudioManager(Activity activity) {
        return (AudioManager)activity.getSystemService("audio");
    }

    public static Object setAudioFocusChangeListener(final Player player) {
        AudioManager.OnAudioFocusChangeListener afChangeListener = new AudioManager.OnAudioFocusChangeListener(){
            private boolean playbackFlag = false;

            public void onAudioFocusChange(int focusChange) {
                switch (focusChange) {
                    case -3: 
                    case -2: {
                        if (player == null || player.playerState != Player.State.PLAYING) break;
                        player.pause();
                        this.playbackFlag = true;
                        break;
                    }
                    case -1: {
                        this.playbackFlag = false;
                        player.OtherPlayerStarted();
                        break;
                    }
                    case 1: {
                        if (player == null || !this.playbackFlag || player.playerState != Player.State.PAUSED_BY_EVENT) break;
                        player.Start();
                        this.playbackFlag = false;
                    }
                }
            }
        };
        return afChangeListener;
    }

    public static boolean focusRequestGranted(AudioManager am, Object afChangeListener) {
        int result = am.requestAudioFocus((AudioManager.OnAudioFocusChangeListener)afChangeListener, 3, 1);
        return result == 1;
    }

    public static void abandonFocus(AudioManager am, Object afChangeListener) {
        am.abandonAudioFocus((AudioManager.OnAudioFocusChangeListener)afChangeListener);
    }

    public static WebViewClient getWebViewClient(final boolean ignoreErrors, final boolean followLinks, final Form form, final Component component) {
        return new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                return !followLinks;
            }

            public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
                if (ignoreErrors) {
                    handler.proceed();
                } else {
                    handler.cancel();
                    form.dispatchErrorOccurredEvent(component, "WebView", 2501, new Object[0]);
                }
            }
        };
    }
}

