/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import android.os.Environment;
import com.google.appinventor.components.runtime.errors.RuntimeError;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class FileUtil {
    private static final String DOCUMENT_DIRECTORY = "My Documents/";
    private static final String DIRECTORY_RECORDINGS = "Recordings";
    private static final String FILENAME_PREFIX = "app_inventor_";
    private static final String DIRECTORY_PICTURES = "Pictures";
    private static final String DIRECTORY_DOWNLOADS = "Downloads";

    private FileUtil() {
    }

    public static String getFileUrl(String localFileName) {
        File file = new File(localFileName);
        return file.toURI().toString();
    }

    public static byte[] readFile(String inputFileName) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileInputStream in = new FileInputStream(inputFileName);
        try {
            FileUtil.copy(in, out);
        }
        finally {
            ((InputStream)in).close();
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadUrlToFile(String url, String outputFileName) throws IOException {
        InputStream in = new URL(url).openStream();
        try {
            String string2 = FileUtil.writeStreamToFile(in, outputFileName);
            return string2;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(byte[] array, String outputFileName) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(array);
        try {
            String string2 = FileUtil.writeStreamToFile(in, outputFileName);
            return string2;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyFile(String inputFileName, String outputFileName) throws IOException {
        FileInputStream in = new FileInputStream(inputFileName);
        try {
            String string2 = FileUtil.writeStreamToFile(in, outputFileName);
            return string2;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeStreamToFile(InputStream in, String outputFileName) throws IOException {
        File file = new File(outputFileName);
        file.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(file);
        try {
            FileUtil.copy(in, out);
            String string2 = file.toURI().toString();
            return string2;
        }
        finally {
            out.flush();
            ((OutputStream)out).close();
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int b;
        out = new BufferedOutputStream(out, 4096);
        in = new BufferedInputStream(in, 4096);
        while ((b = in.read()) != -1) {
            out.write(b);
        }
        out.flush();
    }

    public static File getPictureFile(String extension) throws IOException, FileException {
        return FileUtil.getFile(DIRECTORY_PICTURES, extension);
    }

    public static File getRecordingFile(String extension) throws IOException, FileException {
        return FileUtil.getFile(DIRECTORY_RECORDINGS, extension);
    }

    public static File getDownloadFile(String extension) throws IOException, FileException {
        return FileUtil.getFile(DIRECTORY_DOWNLOADS, extension);
    }

    private static File getFile(String category, String extension) throws IOException, FileException {
        String fileName = DOCUMENT_DIRECTORY + category + "/" + FILENAME_PREFIX + System.currentTimeMillis() + "." + extension;
        return FileUtil.getExternalFile(fileName);
    }

    public static File getExternalFile(String fileName) throws IOException, FileException {
        FileUtil.checkExternalStorageWriteable();
        File file = new File(Environment.getExternalStorageDirectory(), fileName);
        File directory = file.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Unable to create directory " + directory.getAbsolutePath());
        }
        if (file.exists() && !file.delete()) {
            throw new IOException("Cannot overwrite existing file " + file.getAbsolutePath());
        }
        return file;
    }

    public static void checkExternalStorageWriteable() throws FileException {
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state)) {
            return;
        }
        if ("mounted_ro".equals(state)) {
            throw new FileException(704);
        }
        throw new FileException(705);
    }

    public static class FileException
    extends RuntimeError {
        private final int msgNumber;

        public FileException(int errorMsgNumber) {
            this.msgNumber = errorMsgNumber;
        }

        public int getErrorMessageNumber() {
            return this.msgNumber;
        }
    }
}

