/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class Ev3BinaryParser {
    private static byte PRIMPAR_SHORT = 0;
    private static byte PRIMPAR_LONG = (byte)-128;
    private static byte PRIMPAR_CONST = 0;
    private static byte PRIMPAR_VARIABEL = (byte)64;
    private static byte PRIMPAR_LOCAL = 0;
    private static byte PRIMPAR_GLOBAL = (byte)32;
    private static byte PRIMPAR_HANDLE = (byte)16;
    private static byte PRIMPAR_ADDR = (byte)8;
    private static byte PRIMPAR_INDEX = (byte)31;
    private static byte PRIMPAR_CONST_SIGN = (byte)32;
    private static byte PRIMPAR_VALUE = (byte)63;
    private static byte PRIMPAR_BYTES = (byte)7;
    private static byte PRIMPAR_STRING_OLD = 0;
    private static byte PRIMPAR_1_BYTE = 1;
    private static byte PRIMPAR_2_BYTES = (byte)2;
    private static byte PRIMPAR_4_BYTES = (byte)3;
    private static byte PRIMPAR_STRING = (byte)4;

    public static byte[] pack(String format, Object ... values) throws IllegalArgumentException {
        String[] formatTokens = format.split("(?<=\\D)");
        FormatLiteral[] literals = new FormatLiteral[formatTokens.length];
        int index = 0;
        int bufferCapacity = 0;
        for (int i = 0; i < formatTokens.length; ++i) {
            String token = formatTokens[i];
            char symbol = token.charAt(token.length() - 1);
            int size = 1;
            boolean sizeSpecified = false;
            if (token.length() != 1) {
                size = Integer.parseInt(token.substring(0, token.length() - 1));
                sizeSpecified = true;
                if (size < 1) {
                    throw new IllegalArgumentException("Illegal format string");
                }
            }
            switch (symbol) {
                case 'x': {
                    bufferCapacity += size;
                    break;
                }
                case 'b': {
                    bufferCapacity += size;
                    index += size;
                    break;
                }
                case 'B': {
                    bufferCapacity += size;
                    ++index;
                    break;
                }
                case 'h': {
                    bufferCapacity += size * 2;
                    index += size;
                    break;
                }
                case 'H': {
                    bufferCapacity += size * 2;
                    ++index;
                    break;
                }
                case 'i': {
                    bufferCapacity += size * 4;
                    index += size;
                    break;
                }
                case 'I': {
                    bufferCapacity += size * 4;
                    ++index;
                    break;
                }
                case 'l': {
                    bufferCapacity += size * 8;
                    index += size;
                    break;
                }
                case 'L': {
                    bufferCapacity += size * 8;
                    ++index;
                    break;
                }
                case 'f': {
                    bufferCapacity += size * 4;
                    index += size;
                    break;
                }
                case 'F': {
                    bufferCapacity += size * 4;
                    ++index;
                    break;
                }
                case 's': {
                    if (size != ((String)values[index]).length()) {
                        throw new IllegalArgumentException("Illegal format string");
                    }
                    bufferCapacity += size;
                    ++index;
                    break;
                }
                case 'S': {
                    if (sizeSpecified) {
                        throw new IllegalArgumentException("Illegal format string");
                    }
                    bufferCapacity += ((String)values[index]).length() + 1;
                    ++index;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal format string");
                }
            }
            literals[i] = new FormatLiteral(symbol, size);
        }
        if (index != values.length) {
            throw new IllegalArgumentException("Illegal format string");
        }
        index = 0;
        ByteBuffer buffer = ByteBuffer.allocate(bufferCapacity);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        block35: for (FormatLiteral literal : literals) {
            switch (literal.symbol) {
                case 'x': {
                    int i;
                    for (i = 0; i < literal.size; ++i) {
                        buffer.put((byte)0);
                    }
                    continue block35;
                }
                case 'b': {
                    int i;
                    for (i = 0; i < literal.size; ++i) {
                        buffer.put((Byte)values[index]);
                        ++index;
                    }
                    continue block35;
                }
                case 'B': {
                    buffer.put((byte[])values[index]);
                    ++index;
                    continue block35;
                }
                case 'h': {
                    int i;
                    for (i = 0; i < literal.size; ++i) {
                        buffer.putShort((Short)values[index]);
                        ++index;
                    }
                    continue block35;
                }
                case 'H': {
                    int i;
                    for (i = 0; i < literal.size; ++i) {
                        buffer.putShort(((short[])values[index])[i]);
                    }
                    ++index;
                    continue block35;
                }
                case 'i': {
                    int i;
                    for (i = 0; i < literal.size; ++i) {
                        buffer.putInt((Integer)values[index]);
                        ++index;
                    }
                    continue block35;
                }
                case 'I': {
                    int i;
                    for (i = 0; i < literal.size; ++i) {
                        buffer.putInt(((int[])values[index])[i]);
                    }
                    ++index;
                    continue block35;
                }
                case 'l': {
                    int i;
                    for (i = 0; i < literal.size; ++i) {
                        buffer.putLong((Long)values[index]);
                        ++index;
                    }
                    continue block35;
                }
                case 'L': {
                    int i;
                    for (i = 0; i < literal.size; ++i) {
                        buffer.putLong(((long[])values[index])[i]);
                    }
                    ++index;
                    continue block35;
                }
                case 'f': {
                    int i;
                    for (i = 0; i < literal.size; ++i) {
                        buffer.putFloat(((Float)values[index]).floatValue());
                        ++index;
                    }
                    continue block35;
                }
                case 'F': {
                    int i;
                    for (i = 0; i < literal.size; ++i) {
                        buffer.putFloat(((float[])values[index])[i]);
                    }
                    ++index;
                    continue block35;
                }
                case 's': {
                    try {
                        buffer.put(((String)values[index]).getBytes("US-ASCII"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IllegalArgumentException();
                    }
                    ++index;
                    continue block35;
                }
                case 'S': {
                    try {
                        buffer.put(((String)values[index]).getBytes("US-ASCII"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IllegalArgumentException();
                    }
                    buffer.put((byte)0);
                    ++index;
                }
            }
        }
        return buffer.array();
    }

    public static Object[] unpack(String format, byte[] bytes) throws IllegalArgumentException {
        String[] formatTokens = format.split("(?<=\\D)");
        ArrayList<Object> decodedObjects = new ArrayList<Object>();
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        block18: for (String token : formatTokens) {
            boolean sizeSpecified = false;
            int size = 1;
            char symbol = token.charAt(token.length() - 1);
            if (token.length() > 1) {
                sizeSpecified = true;
                size = Integer.parseInt(token.substring(0, token.length() - 1));
                if (size < 1) {
                    throw new IllegalArgumentException("Illegal format string");
                }
            }
            switch (symbol) {
                case 'x': {
                    for (int i = 0; i < size; ++i) {
                        buffer.get();
                    }
                    continue block18;
                }
                case 'b': {
                    for (int i = 0; i < size; ++i) {
                        decodedObjects.add(buffer.get());
                    }
                    continue block18;
                }
                case 'B': {
                    byte[] byteArray = new byte[size];
                    buffer.get(byteArray, 0, size);
                    decodedObjects.add(byteArray);
                    continue block18;
                }
                case 'h': {
                    for (int i = 0; i < size; ++i) {
                        decodedObjects.add(buffer.getShort());
                    }
                    continue block18;
                }
                case 'H': {
                    short[] shorts = new short[size];
                    for (int i = 0; i < size; i = (int)((short)(i + 1))) {
                        shorts[i] = buffer.getShort();
                    }
                    decodedObjects.add(shorts);
                    continue block18;
                }
                case 'i': {
                    for (int i = 0; i < size; ++i) {
                        decodedObjects.add(buffer.getInt());
                    }
                    continue block18;
                }
                case 'I': {
                    int[] integers = new int[size];
                    for (int i = 0; i < size; ++i) {
                        integers[i] = buffer.getInt();
                    }
                    decodedObjects.add(integers);
                    continue block18;
                }
                case 'l': {
                    for (int i = 0; i < size; ++i) {
                        decodedObjects.add(buffer.getLong());
                    }
                    continue block18;
                }
                case 'L': {
                    long[] longs = new long[size];
                    for (int i = 0; i < size; ++i) {
                        longs[i] = buffer.getLong();
                    }
                    decodedObjects.add(longs);
                    continue block18;
                }
                case 'f': {
                    for (int i = 0; i < size; ++i) {
                        decodedObjects.add(Float.valueOf(buffer.getFloat()));
                    }
                    continue block18;
                }
                case 'F': {
                    float[] floats = new float[size];
                    for (int i = 0; i < size; ++i) {
                        floats[i] = buffer.getFloat();
                    }
                    decodedObjects.add(floats);
                    continue block18;
                }
                case 's': {
                    byte[] byteString = new byte[size];
                    buffer.get(byteString, 0, size);
                    try {
                        decodedObjects.add(new String(byteString, "US-ASCII"));
                        continue block18;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IllegalArgumentException();
                    }
                }
                case 'S': {
                    byte b;
                    if (sizeSpecified) {
                        throw new IllegalArgumentException("Illegal format string");
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((b = buffer.get()) != 0) {
                        stringBuffer.append((char)b);
                    }
                    decodedObjects.add(stringBuffer.toString());
                    continue block18;
                }
                case '$': {
                    if (sizeSpecified) {
                        throw new IllegalArgumentException("Illegal format string");
                    }
                    if (buffer.hasRemaining()) {
                        throw new IllegalArgumentException("Illegal format string");
                    }
                }
                default: {
                    throw new IllegalArgumentException("Illegal format string");
                }
            }
        }
        return decodedObjects.toArray();
    }

    public static byte[] encodeLC0(byte v) {
        if (v < -31 || v > 31) {
            throw new IllegalArgumentException("Encoded value must be in range [0, 127]");
        }
        return new byte[]{(byte)(v & PRIMPAR_VALUE)};
    }

    public static byte[] encodeLC1(byte v) {
        return new byte[]{(byte)((byte)(PRIMPAR_LONG | PRIMPAR_CONST) | PRIMPAR_1_BYTE), (byte)(v & 0xFF)};
    }

    public static byte[] encodeLC2(short v) {
        return new byte[]{(byte)((byte)(PRIMPAR_LONG | PRIMPAR_CONST) | PRIMPAR_2_BYTES), (byte)(v & 0xFF), (byte)(v >>> 8 & 0xFF)};
    }

    public static byte[] encodeLC4(int v) {
        return new byte[]{(byte)((byte)(PRIMPAR_LONG | PRIMPAR_CONST) | PRIMPAR_4_BYTES), (byte)(v & 0xFF), (byte)(v >>> 8 & 0xFF), (byte)(v >>> 16 & 0xFF), (byte)(v >>> 24 & 0xFF)};
    }

    public static byte[] encodeLV0(int i) {
        return new byte[]{(byte)(i & PRIMPAR_INDEX | PRIMPAR_SHORT | PRIMPAR_VARIABEL | PRIMPAR_LOCAL)};
    }

    public static byte[] encodeLV1(int i) {
        return new byte[]{(byte)(PRIMPAR_LONG | PRIMPAR_VARIABEL | PRIMPAR_LOCAL | PRIMPAR_1_BYTE), (byte)(i & 0xFF)};
    }

    public static byte[] encodeLV2(int i) {
        return new byte[]{(byte)(PRIMPAR_LONG | PRIMPAR_VARIABEL | PRIMPAR_LOCAL | PRIMPAR_2_BYTES), (byte)(i & 0xFF), (byte)(i >>> 8 & 0xFF)};
    }

    public static byte[] encodeLV4(int i) {
        return new byte[]{(byte)(PRIMPAR_LONG | PRIMPAR_VARIABEL | PRIMPAR_LOCAL | PRIMPAR_4_BYTES), (byte)(i & 0xFF), (byte)(i >>> 8 & 0xFF), (byte)(i >>> 16 & 0xFF), (byte)(i >>> 24 & 0xFF)};
    }

    public static byte[] encodeGV0(int i) {
        return new byte[]{(byte)(i & PRIMPAR_INDEX | PRIMPAR_SHORT | PRIMPAR_VARIABEL | PRIMPAR_GLOBAL)};
    }

    public static byte[] encodeGV1(int i) {
        return new byte[]{(byte)(PRIMPAR_LONG | PRIMPAR_VARIABEL | PRIMPAR_GLOBAL | PRIMPAR_1_BYTE), (byte)(i & 0xFF)};
    }

    public static byte[] encodeGV2(int i) {
        return new byte[]{(byte)(PRIMPAR_LONG | PRIMPAR_VARIABEL | PRIMPAR_GLOBAL | PRIMPAR_2_BYTES), (byte)(i & 0xFF), (byte)(i >>> 8 & 0xFF)};
    }

    public static byte[] encodeGV4(int i) {
        return new byte[]{(byte)(PRIMPAR_LONG | PRIMPAR_VARIABEL | PRIMPAR_GLOBAL | PRIMPAR_4_BYTES), (byte)(i & 0xFF), (byte)(i >>> 8 & 0xFF), (byte)(i >>> 16 & 0xFF), (byte)(i >>> 24 & 0xFF)};
    }

    public static byte[] encodeSystemCommand(byte command, boolean needReply, Object ... parameters) {
        int bufferCapacity = 2;
        for (Object obj : parameters) {
            if (obj instanceof Byte) {
                ++bufferCapacity;
                continue;
            }
            if (obj instanceof Short) {
                bufferCapacity += 2;
                continue;
            }
            if (obj instanceof Integer) {
                bufferCapacity += 4;
                continue;
            }
            if (obj instanceof String) {
                bufferCapacity += ((String)obj).length() + 1;
                continue;
            }
            throw new IllegalArgumentException("Parameters should be one of the class types: Byte, Short, Integer, String");
        }
        ByteBuffer buffer = ByteBuffer.allocate(bufferCapacity);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(needReply ? (byte)1 : -127);
        buffer.put(command);
        for (Object obj : parameters) {
            if (obj instanceof Byte) {
                buffer.put((Byte)obj);
                continue;
            }
            if (obj instanceof Short) {
                buffer.putShort((Short)obj);
                continue;
            }
            if (obj instanceof Integer) {
                buffer.putInt((Integer)obj);
                continue;
            }
            if (obj instanceof String) {
                try {
                    buffer.put(((String)obj).getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("Non-ASCII string encoding is not supported");
                }
                buffer.put((byte)0);
                continue;
            }
            throw new IllegalArgumentException("Parameters should be one of the class types: Byte, Short, Integer, String");
        }
        return buffer.array();
    }

    public static byte[] encodeDirectCommand(byte opcode, boolean needReply, int globalAllocation, int localAllocation, String paramFormat, Object ... parameters) {
        if (globalAllocation < 0 || globalAllocation > 1023 || localAllocation < 0 || localAllocation > 63 || paramFormat.length() != parameters.length) {
            throw new IllegalArgumentException();
        }
        ArrayList<byte[]> payloads = new ArrayList<byte[]>();
        block8: for (int i = 0; i < paramFormat.length(); ++i) {
            char letter = paramFormat.charAt(i);
            Object obj = parameters[i];
            switch (letter) {
                case 'c': {
                    if (obj instanceof Byte) {
                        if ((Byte)obj <= 31 && (Byte)obj >= -31) {
                            payloads.add(Ev3BinaryParser.encodeLC0((Byte)obj));
                            continue block8;
                        }
                        payloads.add(Ev3BinaryParser.encodeLC1((Byte)obj));
                        continue block8;
                    }
                    if (obj instanceof Short) {
                        payloads.add(Ev3BinaryParser.encodeLC2((Short)obj));
                        continue block8;
                    }
                    if (obj instanceof Integer) {
                        payloads.add(Ev3BinaryParser.encodeLC4((Integer)obj));
                        continue block8;
                    }
                    throw new IllegalArgumentException();
                }
                case 'l': {
                    if (obj instanceof Byte) {
                        if ((Byte)obj <= 31 && (Byte)obj >= -31) {
                            payloads.add(Ev3BinaryParser.encodeLV0(((Byte)obj).byteValue()));
                            continue block8;
                        }
                        payloads.add(Ev3BinaryParser.encodeLV1(((Byte)obj).byteValue()));
                        continue block8;
                    }
                    if (obj instanceof Short) {
                        payloads.add(Ev3BinaryParser.encodeLV2(((Short)obj).shortValue()));
                        continue block8;
                    }
                    if (obj instanceof Integer) {
                        payloads.add(Ev3BinaryParser.encodeLV4((Integer)obj));
                        continue block8;
                    }
                    throw new IllegalArgumentException();
                }
                case 'g': {
                    if (obj instanceof Byte) {
                        if ((Byte)obj <= 31 && (Byte)obj >= -31) {
                            payloads.add(Ev3BinaryParser.encodeGV0(((Byte)obj).byteValue()));
                            continue block8;
                        }
                        payloads.add(Ev3BinaryParser.encodeGV1(((Byte)obj).byteValue()));
                        continue block8;
                    }
                    if (obj instanceof Short) {
                        payloads.add(Ev3BinaryParser.encodeGV2(((Short)obj).shortValue()));
                        continue block8;
                    }
                    if (obj instanceof Integer) {
                        payloads.add(Ev3BinaryParser.encodeGV4((Integer)obj));
                        continue block8;
                    }
                    throw new IllegalArgumentException();
                }
                case 's': {
                    if (!(obj instanceof String)) {
                        throw new IllegalArgumentException();
                    }
                    try {
                        payloads.add(((String)obj + '\u0000').getBytes("US-ASCII"));
                        continue block8;
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IllegalArgumentException();
                    }
                }
                default: {
                    throw new IllegalArgumentException("Illegal format string");
                }
            }
        }
        int bufferCapacity = 4;
        for (byte[] array : payloads) {
            bufferCapacity += array.length;
        }
        ByteBuffer buffer = ByteBuffer.allocate(bufferCapacity);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put(needReply ? (byte)0 : -128);
        buffer.put(new byte[]{(byte)(globalAllocation & 0xFF), (byte)(globalAllocation >>> 8 & 3 | localAllocation << 2)});
        buffer.put(opcode);
        for (byte[] array : payloads) {
            buffer.put(array);
        }
        return buffer.array();
    }

    private static class FormatLiteral {
        public char symbol;
        public int size;

        public FormatLiteral(char symbol, int size) {
            this.symbol = symbol;
            this.size = size;
        }
    }
}

