/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import com.google.appinventor.components.runtime.errors.YailRuntimeError;
import com.google.appinventor.components.runtime.util.YailList;

public class ElementsUtil {
    public static YailList elementsFromString(String itemString) {
        YailList items = new YailList();
        if (itemString.length() > 0) {
            items = YailList.makeList(itemString.split(" *, *"));
        }
        return items;
    }

    public static YailList elements(YailList itemList, String componentName) {
        String[] objects = itemList.toStringArray();
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] instanceof String) continue;
            throw new YailRuntimeError("Items passed to " + componentName + " must be Strings", "Error");
        }
        return itemList;
    }

    public static int selectionIndex(int index, YailList items) {
        if (index <= 0 || index > items.size()) {
            return 0;
        }
        return index;
    }

    public static String setSelectionFromIndex(int index, YailList items) {
        if (index == 0) {
            return "";
        }
        return items.getString(index - 1);
    }

    public static int setSelectedIndexFromValue(String value, YailList items) {
        for (int i = 0; i < items.size(); ++i) {
            if (!items.getString(i).equals(value)) continue;
            return i + 1;
        }
        return 0;
    }
}

