/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import com.google.appinventor.components.runtime.collect.Lists;
import com.google.appinventor.components.runtime.util.YailList;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public final class CsvUtil {
    private CsvUtil() {
    }

    public static YailList fromCsvTable(String csvString) throws Exception {
        CsvParser csvParser = new CsvParser(new StringReader(csvString));
        ArrayList<YailList> csvList = new ArrayList<YailList>();
        while (csvParser.hasNext()) {
            csvList.add(YailList.makeList((List)csvParser.next()));
        }
        csvParser.throwAnyProblem();
        return YailList.makeList(csvList);
    }

    public static YailList fromCsvRow(String csvString) throws Exception {
        CsvParser csvParser = new CsvParser(new StringReader(csvString));
        if (csvParser.hasNext()) {
            YailList row = YailList.makeList((List)csvParser.next());
            if (csvParser.hasNext()) {
                throw new IllegalArgumentException("CSV text has multiple rows. Expected just one row.");
            }
            csvParser.throwAnyProblem();
            return row;
        }
        throw new IllegalArgumentException("CSV text cannot be parsed as a row.");
    }

    public static String toCsvRow(YailList csvRow) {
        StringBuilder csvStringBuilder = new StringBuilder();
        CsvUtil.makeCsvRow(csvRow, csvStringBuilder);
        return csvStringBuilder.toString();
    }

    public static String toCsvTable(YailList csvList) {
        StringBuilder csvStringBuilder = new StringBuilder();
        for (Object rowObj : csvList.toArray()) {
            CsvUtil.makeCsvRow((YailList)rowObj, csvStringBuilder);
            csvStringBuilder.append("\r\n");
        }
        return csvStringBuilder.toString();
    }

    private static void makeCsvRow(YailList row, StringBuilder csvStringBuilder) {
        String fieldDelim = "";
        for (Object fieldObj : row.toArray()) {
            String field = fieldObj.toString();
            field = field.replaceAll("\"", "\"\"");
            csvStringBuilder.append(fieldDelim).append("\"").append(field).append("\"");
            fieldDelim = ",";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CsvParser
    implements Iterator<List<String>> {
        private final Pattern ESCAPED_QUOTE_PATTERN = Pattern.compile("\"\"");
        private final char[] buf = new char[10240];
        private final Reader in;
        private int pos;
        private int limit;
        private boolean opened = true;
        private int cellLength = -1;
        private int delimitedCellLength = -1;
        private Exception lastException;
        private long previouslyRead;

        public CsvParser(Reader in) {
            this.in = in;
        }

        public void skip(long charPosition) throws IOException {
            int n;
            while (charPosition > 0L && (n = this.in.read(this.buf, 0, Math.min((int)charPosition, this.buf.length))) >= 0) {
                this.previouslyRead += (long)n;
                charPosition -= (long)n;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.limit == 0) {
                this.fill();
            }
            return (this.pos < this.limit || this.indexAfterCompactionAndFilling(this.pos) < this.limit) && this.lookingAtCell();
        }

        @Override
        public ArrayList<String> next() {
            boolean haveMoreData;
            boolean trailingComma;
            ArrayList<String> result = Lists.newArrayList();
            do {
                if (this.buf[this.pos] != '\"') {
                    result.add(new String(this.buf, this.pos, this.cellLength).trim());
                } else {
                    String cell = new String(this.buf, this.pos + 1, this.cellLength - 2);
                    result.add(this.ESCAPED_QUOTE_PATTERN.matcher(cell).replaceAll("\"").trim());
                }
                trailingComma = this.delimitedCellLength > 0 && this.buf[this.pos + this.delimitedCellLength - 1] == ',';
                this.pos += this.delimitedCellLength;
                this.cellLength = -1;
                this.delimitedCellLength = -1;
                boolean bl = haveMoreData = this.pos < this.limit || this.indexAfterCompactionAndFilling(this.pos) < this.limit;
            } while (trailingComma && haveMoreData && this.lookingAtCell());
            return result;
        }

        public long getCharPosition() {
            return this.previouslyRead + (long)this.pos;
        }

        private int indexAfterCompactionAndFilling(int i) {
            if (this.pos > 0) {
                i = this.compact(i);
            }
            this.fill();
            return i;
        }

        private int compact(int i) {
            int oldPos = this.pos;
            this.pos = 0;
            int toMove = this.limit - oldPos;
            if (toMove > 0) {
                System.arraycopy(this.buf, oldPos, this.buf, 0, toMove);
            }
            this.limit -= oldPos;
            this.previouslyRead += (long)oldPos;
            return i - oldPos;
        }

        private void fill() {
            int toFill = this.buf.length - this.limit;
            while (this.opened && toFill > 0) {
                try {
                    int n = this.in.read(this.buf, this.limit, toFill);
                    if (n == -1) {
                        this.opened = false;
                        continue;
                    }
                    this.limit += n;
                    toFill -= n;
                }
                catch (IOException e) {
                    this.lastException = e;
                    this.opened = false;
                }
            }
        }

        private boolean lookingAtCell() {
            return this.buf[this.pos] == '\"' ? this.findUnescapedEndQuote(this.pos + 1) : this.findUnquotedCellEnd(this.pos);
        }

        private boolean findUnescapedEndQuote(int i) {
            while (i < this.limit || (i = this.indexAfterCompactionAndFilling(i)) < this.limit) {
                if (this.buf[i] == '\"' && ((i = this.checkedIndex(i + 1)) == this.limit || this.buf[i] != '\"')) {
                    this.cellLength = i - this.pos;
                    return this.findDelimOrEnd(i);
                }
                ++i;
            }
            this.lastException = new IllegalArgumentException("Syntax Error. unclosed quoted cell");
            return false;
        }

        private boolean findDelimOrEnd(int i) {
            while (i < this.limit || (i = this.indexAfterCompactionAndFilling(i)) < this.limit) {
                switch (this.buf[i]) {
                    case '\t': 
                    case ' ': {
                        break;
                    }
                    case '\r': {
                        int j = this.checkedIndex(i + 1);
                        this.delimitedCellLength = (this.buf[j] == '\n' ? this.checkedIndex(j + 1) : j) - this.pos;
                        return true;
                    }
                    case '\n': 
                    case ',': {
                        this.delimitedCellLength = this.checkedIndex(i + 1) - this.pos;
                        return true;
                    }
                    default: {
                        this.lastException = new IOException("Syntax Error: non-whitespace between closing quote and delimiter or end");
                        return false;
                    }
                }
                ++i;
            }
            this.delimitedCellLength = this.limit - this.pos;
            return true;
        }

        private int checkedIndex(int i) {
            return i < this.limit ? i : this.indexAfterCompactionAndFilling(i);
        }

        private boolean findUnquotedCellEnd(int i) {
            while (i < this.limit || (i = this.indexAfterCompactionAndFilling(i)) < this.limit) {
                switch (this.buf[i]) {
                    case '\n': 
                    case ',': {
                        this.cellLength = i - this.pos;
                        this.delimitedCellLength = this.cellLength + 1;
                        return true;
                    }
                    case '\r': {
                        this.cellLength = i - this.pos;
                        int j = this.checkedIndex(i + 1);
                        this.delimitedCellLength = (this.buf[j] == '\n' ? this.checkedIndex(j + 1) : j) - this.pos;
                        return true;
                    }
                    case '\"': {
                        this.lastException = new IllegalArgumentException("Syntax Error: quote in unquoted cell");
                        return false;
                    }
                }
                ++i;
            }
            this.delimitedCellLength = this.cellLength = this.limit - this.pos;
            return true;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void throwAnyProblem() throws Exception {
            if (this.lastException != null) {
                throw this.lastException;
            }
        }
    }
}

