/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import com.google.appinventor.components.runtime.util.AccountChooser;
import com.google.appinventor.components.runtime.util.IClientLoginHelper;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class ClientLoginHelper
implements IClientLoginHelper {
    private static final String LOG_TAG = "ClientLoginHelper";
    private static final String ACCOUNT_TYPE = "com.google";
    private static final String AUTHORIZATION_HEADER_PREFIX = "GoogleLogin auth=";
    private String service;
    private HttpClient client;
    private Activity activity;
    private AccountManager accountManager;
    private AccountChooser accountChooser;
    private String authToken;
    private boolean initialized = false;

    public ClientLoginHelper(Activity activity, String service, String prompt, HttpClient client) {
        this.service = service;
        this.client = client == null ? new DefaultHttpClient() : client;
        this.activity = activity;
        this.accountManager = AccountManager.get((Context)activity);
        this.accountChooser = new AccountChooser(activity, service, prompt, service);
    }

    private void initialize() throws ClientProtocolException {
        if (!this.initialized) {
            Log.i((String)LOG_TAG, (String)"initializing");
            if (this.isUiThread()) {
                throw new IllegalArgumentException("Can't initialize login helper from UI thread");
            }
            this.authToken = this.getAuthToken();
            this.initialized = true;
        }
    }

    private boolean isUiThread() {
        return Looper.getMainLooper().getThread().equals(Thread.currentThread());
    }

    public HttpResponse execute(HttpUriRequest request) throws ClientProtocolException, IOException {
        this.initialize();
        ClientLoginHelper.addGoogleAuthHeader(request, this.authToken);
        HttpResponse response = this.client.execute(request);
        if (response.getStatusLine().getStatusCode() == 401) {
            Log.i((String)LOG_TAG, (String)("Invalid token: " + this.authToken));
            this.accountManager.invalidateAuthToken(ACCOUNT_TYPE, this.authToken);
            this.authToken = this.getAuthToken();
            ClientLoginHelper.removeGoogleAuthHeaders(request);
            ClientLoginHelper.addGoogleAuthHeader(request, this.authToken);
            Log.i((String)LOG_TAG, (String)("new token: " + this.authToken));
            response = this.client.execute(request);
        }
        return response;
    }

    public void forgetAccountName() {
        this.accountChooser.forgetAccountName();
    }

    private static void addGoogleAuthHeader(HttpUriRequest request, String token) {
        if (token != null) {
            Log.i((String)LOG_TAG, (String)("adding auth token token: " + token));
            request.addHeader("Authorization", AUTHORIZATION_HEADER_PREFIX + token);
        }
    }

    private static void removeGoogleAuthHeaders(HttpUriRequest request) {
        for (Header header : request.getAllHeaders()) {
            if (!header.getName().equalsIgnoreCase("Authorization") || !header.getValue().startsWith(AUTHORIZATION_HEADER_PREFIX)) continue;
            Log.i((String)LOG_TAG, (String)("Removing header:" + header));
            request.removeHeader(header);
        }
    }

    public String getAuthToken() throws ClientProtocolException {
        Account account = this.accountChooser.findAccount();
        if (account != null) {
            AccountManagerFuture future = this.accountManager.getAuthToken(account, this.service, null, this.activity, null, null);
            Log.i((String)LOG_TAG, (String)("Have account, auth token: " + future));
            try {
                Bundle result = (Bundle)future.getResult();
                return result.getString("authtoken");
            }
            catch (AuthenticatorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (OperationCanceledException e) {
                e.printStackTrace();
            }
        }
        throw new ClientProtocolException("Can't get valid authentication token");
    }
}

