/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BluetoothReflection {
    private static final int BOND_BONDED = 12;

    private BluetoothReflection() {
    }

    public static Object getBluetoothAdapter() {
        Class<?> bluetoothAdapterClass;
        try {
            bluetoothAdapterClass = Class.forName("android.bluetooth.BluetoothAdapter");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return BluetoothReflection.invokeStaticMethod(BluetoothReflection.getMethod(bluetoothAdapterClass, "getDefaultAdapter"));
    }

    public static boolean isBluetoothEnabled(Object bluetoothAdapter) {
        return (Boolean)BluetoothReflection.invokeMethod(BluetoothReflection.getMethod(bluetoothAdapter.getClass(), "isEnabled"), bluetoothAdapter, new Object[0]);
    }

    public static Set getBondedDevices(Object bluetoothAdapter) {
        return (Set)BluetoothReflection.invokeMethod(BluetoothReflection.getMethod(bluetoothAdapter.getClass(), "getBondedDevices"), bluetoothAdapter, new Object[0]);
    }

    public static boolean checkBluetoothAddress(Object bluetoothAdapter, String address) {
        return (Boolean)BluetoothReflection.invokeMethod(BluetoothReflection.getMethod(bluetoothAdapter.getClass(), "checkBluetoothAddress", String.class), bluetoothAdapter, address);
    }

    public static Object getRemoteDevice(Object bluetoothAdapter, String address) throws IllegalArgumentException {
        return BluetoothReflection.invokeMethodThrowsIllegalArgumentException(BluetoothReflection.getMethod(bluetoothAdapter.getClass(), "getRemoteDevice", String.class), bluetoothAdapter, address);
    }

    public static Object listenUsingRfcommWithServiceRecord(Object bluetoothAdapter, String name, UUID uuid) throws IOException {
        return BluetoothReflection.invokeMethodThrowsIOException(BluetoothReflection.getMethod(bluetoothAdapter.getClass(), "listenUsingRfcommWithServiceRecord", String.class, UUID.class), bluetoothAdapter, name, uuid);
    }

    public static Object listenUsingInsecureRfcommWithServiceRecord(Object bluetoothAdapter, String name, UUID uuid) throws IOException {
        return BluetoothReflection.invokeMethodThrowsIOException(BluetoothReflection.getMethod(bluetoothAdapter.getClass(), "listenUsingInsecureRfcommWithServiceRecord", String.class, UUID.class), bluetoothAdapter, name, uuid);
    }

    public static String getBluetoothDeviceName(Object bluetoothDevice) {
        return (String)BluetoothReflection.invokeMethod(BluetoothReflection.getMethod(bluetoothDevice.getClass(), "getName"), bluetoothDevice, new Object[0]);
    }

    public static String getBluetoothDeviceAddress(Object bluetoothDevice) {
        return (String)BluetoothReflection.invokeMethod(BluetoothReflection.getMethod(bluetoothDevice.getClass(), "getAddress"), bluetoothDevice, new Object[0]);
    }

    public static boolean isBonded(Object bluetoothDevice) {
        int bondState = (Integer)BluetoothReflection.invokeMethod(BluetoothReflection.getMethod(bluetoothDevice.getClass(), "getBondState"), bluetoothDevice, new Object[0]);
        return bondState == 12;
    }

    public static Object getBluetoothClass(Object bluetoothDevice) {
        return BluetoothReflection.invokeMethod(BluetoothReflection.getMethod(bluetoothDevice.getClass(), "getBluetoothClass"), bluetoothDevice, new Object[0]);
    }

    public static Object createRfcommSocketToServiceRecord(Object bluetoothDevice, UUID uuid) throws IOException {
        return BluetoothReflection.invokeMethodThrowsIOException(BluetoothReflection.getMethod(bluetoothDevice.getClass(), "createRfcommSocketToServiceRecord", UUID.class), bluetoothDevice, uuid);
    }

    public static Object createInsecureRfcommSocketToServiceRecord(Object bluetoothDevice, UUID uuid) throws IOException {
        return BluetoothReflection.invokeMethodThrowsIOException(BluetoothReflection.getMethod(bluetoothDevice.getClass(), "createInsecureRfcommSocketToServiceRecord", UUID.class), bluetoothDevice, uuid);
    }

    public static int getDeviceClass(Object bluetoothClass) {
        return (Integer)BluetoothReflection.invokeMethod(BluetoothReflection.getMethod(bluetoothClass.getClass(), "getDeviceClass"), bluetoothClass, new Object[0]);
    }

    public static void connectToBluetoothSocket(Object bluetoothSocket) throws IOException {
        BluetoothReflection.invokeMethodThrowsIOException(BluetoothReflection.getMethod(bluetoothSocket.getClass(), "connect"), bluetoothSocket, new Object[0]);
    }

    public static InputStream getInputStream(Object bluetoothSocket) throws IOException {
        return (InputStream)BluetoothReflection.invokeMethodThrowsIOException(BluetoothReflection.getMethod(bluetoothSocket.getClass(), "getInputStream"), bluetoothSocket, new Object[0]);
    }

    public static OutputStream getOutputStream(Object bluetoothSocket) throws IOException {
        return (OutputStream)BluetoothReflection.invokeMethodThrowsIOException(BluetoothReflection.getMethod(bluetoothSocket.getClass(), "getOutputStream"), bluetoothSocket, new Object[0]);
    }

    public static void closeBluetoothSocket(Object bluetoothSocket) throws IOException {
        BluetoothReflection.invokeMethodThrowsIOException(BluetoothReflection.getMethod(bluetoothSocket.getClass(), "close"), bluetoothSocket, new Object[0]);
    }

    public static Object accept(Object bluetoothServerSocket) throws IOException {
        return BluetoothReflection.invokeMethodThrowsIOException(BluetoothReflection.getMethod(bluetoothServerSocket.getClass(), "accept"), bluetoothServerSocket, new Object[0]);
    }

    public static void closeBluetoothServerSocket(Object bluetoothServerSocket) throws IOException {
        BluetoothReflection.invokeMethodThrowsIOException(BluetoothReflection.getMethod(bluetoothServerSocket.getClass(), "close"), bluetoothServerSocket, new Object[0]);
    }

    private static Method getMethod(Class clazz, String name) {
        try {
            return clazz.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static Method getMethod(Class clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static Object invokeStaticMethod(Method method) {
        try {
            return method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            cause.printStackTrace();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private static Object invokeMethod(Method method, Object thisObject, Object ... args) {
        try {
            return method.invoke(thisObject, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            cause.printStackTrace();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    private static Object invokeMethodThrowsIllegalArgumentException(Method method, Object thisObject, Object ... args) throws IllegalArgumentException {
        try {
            return method.invoke(thisObject, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            cause.printStackTrace();
            if (cause instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e);
        }
    }

    private static Object invokeMethodThrowsIOException(Method method, Object thisObject, Object ... args) throws IOException {
        try {
            return method.invoke(thisObject, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            cause.printStackTrace();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(e);
        }
    }
}

