/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import com.google.appinventor.components.runtime.ReplForm;
import com.google.appinventor.components.runtime.util.EclairUtil;
import com.google.appinventor.components.runtime.util.NanoHTTPD;
import com.google.appinventor.components.runtime.util.PackageInstaller;
import com.google.appinventor.components.runtime.util.RetValManager;
import com.google.appinventor.components.runtime.util.SdkLevel;
import gnu.expr.Language;
import gnu.expr.ModuleExp;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.Properties;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kawa.standard.Scheme;

public class AppInvHTTPD
extends NanoHTTPD {
    private File rootDir;
    private Language scheme;
    private ReplForm form;
    private boolean secure;
    private static final int YAV_SKEW_FORWARD = 1;
    private static final int YAV_SKEW_BACKWARD = 4;
    private static final String LOG_TAG = "AppInvHTTPD";
    private static byte[] hmacKey;
    private static int seq;
    private static final String MIME_JSON = "application/json";
    private final Handler androidUIHandler = new Handler();

    public AppInvHTTPD(int port, File wwwroot, boolean secure, ReplForm form) throws IOException {
        super(port, wwwroot);
        this.rootDir = wwwroot;
        this.scheme = Scheme.getInstance((String)"scheme");
        this.form = form;
        this.secure = secure;
        ModuleExp.mustNeverCompile();
    }

    public NanoHTTPD.Response serve(String uri, String method, Properties header, Properties parms, Properties files, Socket mySocket) {
        NanoHTTPD.Response res;
        String value;
        Enumeration<?> e;
        InetAddress myAddress;
        String hostAddress;
        Log.d((String)LOG_TAG, (String)(method + " '" + uri + "' "));
        if (this.secure && !(hostAddress = (myAddress = mySocket.getInetAddress()).getHostAddress()).equals("127.0.0.1")) {
            Log.d((String)LOG_TAG, (String)("Debug: hostAddress = " + hostAddress + " while in secure mode, closing connection."));
            NanoHTTPD.Response res2 = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", MIME_JSON, "{\"status\" : \"BAD\", \"message\" : \"Security Error: Invalid Source Location " + hostAddress + "\"}");
            res2.addHeader("Access-Control-Allow-Origin", "*");
            res2.addHeader("Access-Control-Allow-Headers", "origin, content-type");
            res2.addHeader("Access-Control-Allow-Methods", "POST,OPTIONS,GET,HEAD,PUT");
            res2.addHeader("Allow", "POST,OPTIONS,GET,HEAD,PUT");
            return res2;
        }
        if (method.equals("OPTIONS")) {
            e = header.propertyNames();
            while (e.hasMoreElements()) {
                value = (String)e.nextElement();
                Log.d((String)LOG_TAG, (String)("  HDR: '" + value + "' = '" + header.getProperty(value) + "'"));
            }
            NanoHTTPD.Response res3 = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", "text/plain", "OK");
            res3.addHeader("Access-Control-Allow-Origin", "*");
            res3.addHeader("Access-Control-Allow-Headers", "origin, content-type");
            res3.addHeader("Access-Control-Allow-Methods", "POST,OPTIONS,GET,HEAD,PUT");
            res3.addHeader("Allow", "POST,OPTIONS,GET,HEAD,PUT");
            return res3;
        }
        if (uri.equals("/_newblocks")) {
            NanoHTTPD.Response res4;
            String inSeq = parms.getProperty("seq", "0");
            int iseq = Integer.parseInt(inSeq);
            String blockid = parms.getProperty("blockid");
            String code = parms.getProperty("code");
            String inMac = parms.getProperty("mac", "no key provided");
            String compMac = "";
            String input_code = code;
            if (hmacKey != null) {
                try {
                    Mac hmacSha1 = Mac.getInstance("HmacSHA1");
                    SecretKeySpec key = new SecretKeySpec(hmacKey, "RAW");
                    hmacSha1.init(key);
                    byte[] tmpMac = hmacSha1.doFinal((code + inSeq + blockid).getBytes());
                    StringBuffer sb = new StringBuffer(tmpMac.length * 2);
                    Formatter formatter = new Formatter(sb);
                    for (byte b : tmpMac) {
                        formatter.format("%02x", b);
                    }
                    compMac = sb.toString();
                }
                catch (Exception e2) {
                    Log.e((String)LOG_TAG, (String)"Error working with hmac", (Throwable)e2);
                    this.form.dispatchErrorOccurredEvent(this.form, LOG_TAG, 1801, "Exception working on HMAC");
                    NanoHTTPD.Response res5 = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", "text/plain", "NOT");
                    return res5;
                }
                Log.d((String)LOG_TAG, (String)("Incoming Mac = " + inMac));
                Log.d((String)LOG_TAG, (String)("Computed Mac = " + compMac));
                Log.d((String)LOG_TAG, (String)("Incoming seq = " + inSeq));
                Log.d((String)LOG_TAG, (String)("Computed seq = " + seq));
                Log.d((String)LOG_TAG, (String)("blockid = " + blockid));
                if (!inMac.equals(compMac)) {
                    Log.e((String)LOG_TAG, (String)"Hmac does not match");
                    this.form.dispatchErrorOccurredEvent(this.form, LOG_TAG, 1801, "Invalid HMAC");
                    res4 = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", MIME_JSON, "{\"status\" : \"BAD\", \"message\" : \"Security Error: Invalid MAC\"}");
                    return res4;
                }
                if (seq != iseq && seq != iseq + 1) {
                    Log.e((String)LOG_TAG, (String)"Seq does not match");
                    this.form.dispatchErrorOccurredEvent(this.form, LOG_TAG, 1801, "Invalid Seq");
                    res4 = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", MIME_JSON, "{\"status\" : \"BAD\", \"message\" : \"Security Error: Invalid Seq\"}");
                    return res4;
                }
                if (seq == iseq + 1) {
                    Log.e((String)LOG_TAG, (String)"Seq Fixup Invoked");
                }
            } else {
                Log.e((String)LOG_TAG, (String)"No HMAC Key");
                this.form.dispatchErrorOccurredEvent(this.form, LOG_TAG, 1801, "No HMAC Key");
                NanoHTTPD.Response res6 = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", MIME_JSON, "{\"status\" : \"BAD\", \"message\" : \"Security Error: No HMAC Key\"}");
                return res6;
            }
            seq = iseq + 1;
            code = "(begin (require <com.google.youngandroid.runtime>) (process-repl-input " + blockid + " (begin " + code + " )))";
            Log.d((String)LOG_TAG, (String)("To Eval: " + code));
            this.form.loadComponents();
            try {
                if (input_code.equals("#f")) {
                    Log.e((String)LOG_TAG, (String)"Skipping evaluation of #f");
                } else {
                    this.scheme.eval(code);
                }
                res4 = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", MIME_JSON, RetValManager.fetch(false));
            }
            catch (Throwable ex) {
                Log.e((String)LOG_TAG, (String)"newblocks: Scheme Failure", (Throwable)ex);
                RetValManager.appendReturnValue(blockid, "BAD", ex.toString());
                res4 = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", MIME_JSON, RetValManager.fetch(false));
            }
            res4.addHeader("Access-Control-Allow-Origin", "*");
            res4.addHeader("Access-Control-Allow-Headers", "origin, content-type");
            res4.addHeader("Access-Control-Allow-Methods", "POST,OPTIONS,GET,HEAD,PUT");
            res4.addHeader("Allow", "POST,OPTIONS,GET,HEAD,PUT");
            return res4;
        }
        if (uri.equals("/_values")) {
            res = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", MIME_JSON, RetValManager.fetch(true));
            res.addHeader("Access-Control-Allow-Origin", "*");
            res.addHeader("Access-Control-Allow-Headers", "origin, content-type");
            res.addHeader("Access-Control-Allow-Methods", "POST,OPTIONS,GET,HEAD,PUT");
            res.addHeader("Allow", "POST,OPTIONS,GET,HEAD,PUT");
            return res;
        }
        if (uri.equals("/_getversion")) {
            try {
                String packageName = this.form.getPackageName();
                PackageInfo pInfo = this.form.getPackageManager().getPackageInfo(packageName, 0);
                String installer = SdkLevel.getLevel() >= 5 ? EclairUtil.getInstallerPackageName("edu.mit.appinventor.aicompanion3", this.form) : "Not Known";
                String versionName = pInfo.versionName;
                if (installer == null) {
                    installer = "Not Known";
                }
                res = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", MIME_JSON, "{\"version\" : \"" + versionName + "\", \"fingerprint\" : \"" + Build.FINGERPRINT + "\"," + " \"installer\" : \"" + installer + "\", \"package\" : \"" + packageName + "\", \"fqcn\" : true }");
            }
            catch (PackageManager.NameNotFoundException n) {
                n.printStackTrace();
                res = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", MIME_JSON, "{\"verison\" : \"Unknown\"");
            }
            res.addHeader("Access-Control-Allow-Origin", "*");
            res.addHeader("Access-Control-Allow-Headers", "origin, content-type");
            res.addHeader("Access-Control-Allow-Methods", "POST,OPTIONS,GET,HEAD,PUT");
            res.addHeader("Allow", "POST,OPTIONS,GET,HEAD,PUT");
            if (this.secure) {
                seq = 1;
                this.androidUIHandler.post(new Runnable(){

                    public void run() {
                        AppInvHTTPD.this.form.clear();
                    }
                });
            }
            return res;
        }
        if (uri.equals("/_update") || uri.equals("/_install")) {
            String url = parms.getProperty("url", "");
            String inMac = parms.getProperty("mac", "");
            if (!url.equals("") && hmacKey != null && !inMac.equals("")) {
                NanoHTTPD.Response res7;
                String compMac;
                try {
                    SecretKeySpec key = new SecretKeySpec(hmacKey, "RAW");
                    Mac hmacSha1 = Mac.getInstance("HmacSHA1");
                    hmacSha1.init(key);
                    byte[] tmpMac = hmacSha1.doFinal(url.getBytes());
                    StringBuffer sb = new StringBuffer(tmpMac.length * 2);
                    Formatter formatter = new Formatter(sb);
                    for (byte b : tmpMac) {
                        formatter.format("%02x", b);
                    }
                    compMac = sb.toString();
                }
                catch (Exception e3) {
                    Log.e((String)LOG_TAG, (String)"Error verifying update", (Throwable)e3);
                    this.form.dispatchErrorOccurredEvent(this.form, LOG_TAG, 1801, "Exception working on HMAC for update");
                    NanoHTTPD.Response res8 = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", MIME_JSON, "{\"status\" : \"BAD\", \"message\" : \"Security Error: Exception processing MAC\"}");
                    res8.addHeader("Access-Control-Allow-Origin", "*");
                    res8.addHeader("Access-Control-Allow-Headers", "origin, content-type");
                    res8.addHeader("Access-Control-Allow-Methods", "POST,OPTIONS,GET,HEAD,PUT");
                    res8.addHeader("Allow", "POST,OPTIONS,GET,HEAD,PUT");
                    return res8;
                }
                Log.d((String)LOG_TAG, (String)("Incoming Mac (update) = " + inMac));
                Log.d((String)LOG_TAG, (String)("Computed Mac (update) = " + compMac));
                if (!inMac.equals(compMac)) {
                    Log.e((String)LOG_TAG, (String)"Hmac does not match");
                    this.form.dispatchErrorOccurredEvent(this.form, LOG_TAG, 1801, "Invalid HMAC (update)");
                    res7 = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", MIME_JSON, "{\"status\" : \"BAD\", \"message\" : \"Security Error: Invalid MAC\"}");
                    res7.addHeader("Access-Control-Allow-Origin", "*");
                    res7.addHeader("Access-Control-Allow-Headers", "origin, content-type");
                    res7.addHeader("Access-Control-Allow-Methods", "POST,OPTIONS,GET,HEAD,PUT");
                    res7.addHeader("Allow", "POST,OPTIONS,GET,HEAD,PUT");
                    return res7;
                }
                this.doPackageUpdate(url);
                res7 = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", MIME_JSON, "{\"status\" : \"OK\", \"message\" : \"Update Should Happen\"}");
                res7.addHeader("Access-Control-Allow-Origin", "*");
                res7.addHeader("Access-Control-Allow-Headers", "origin, content-type");
                res7.addHeader("Access-Control-Allow-Methods", "POST,OPTIONS,GET,HEAD,PUT");
                res7.addHeader("Allow", "POST,OPTIONS,GET,HEAD,PUT");
                return res7;
            }
            NanoHTTPD.Response res9 = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", MIME_JSON, "{\"status\" : \"BAD\", \"message\" : \"Missing Parameters\"}");
            res9.addHeader("Access-Control-Allow-Origin", "*");
            res9.addHeader("Access-Control-Allow-Headers", "origin, content-type");
            res9.addHeader("Access-Control-Allow-Methods", "POST,OPTIONS,GET,HEAD,PUT");
            res9.addHeader("Allow", "POST,OPTIONS,GET,HEAD,PUT");
            return res9;
        }
        if (uri.equals("/_package")) {
            String packageapk = parms.getProperty("package", null);
            if (packageapk == null) {
                res = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", "text/plain", "NOT OK");
                return res;
            }
            Log.d((String)LOG_TAG, (String)(this.rootDir + "/" + packageapk));
            Intent intent = new Intent("android.intent.action.VIEW");
            Uri packageuri = Uri.fromFile((File)new File(this.rootDir + "/" + packageapk));
            intent.setDataAndType(packageuri, "application/vnd.android.package-archive");
            this.form.startActivity(intent);
            res = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", "text/plain", "OK");
            res.addHeader("Access-Control-Allow-Origin", "*");
            res.addHeader("Access-Control-Allow-Headers", "origin, content-type");
            res.addHeader("Access-Control-Allow-Methods", "POST,OPTIONS,GET,HEAD,PUT");
            res.addHeader("Allow", "POST,OPTIONS,GET,HEAD,PUT");
            return res;
        }
        if (method.equals("PUT")) {
            NanoHTTPD.Response res10;
            Boolean error = false;
            String tmpFileName = files.getProperty("content", null);
            if (tmpFileName != null) {
                File fileFrom = new File(tmpFileName);
                String filename = parms.getProperty("filename", null);
                if (filename != null && (filename.startsWith("..") || filename.endsWith("..") || filename.indexOf("../") >= 0)) {
                    Log.d((String)LOG_TAG, (String)(" Ignoring invalid filename: " + filename));
                    filename = null;
                }
                if (filename != null) {
                    File fileTo = new File(this.rootDir + "/" + filename);
                    File parentFileTo = fileTo.getParentFile();
                    if (!parentFileTo.exists()) {
                        parentFileTo.mkdirs();
                    }
                    if (!fileFrom.renameTo(fileTo)) {
                        this.copyFile(fileFrom, fileTo);
                        fileFrom.delete();
                    }
                } else {
                    fileFrom.delete();
                    Log.e((String)LOG_TAG, (String)"Received content without a file name!");
                    error = true;
                }
            } else {
                Log.e((String)LOG_TAG, (String)"Received PUT without content.");
                error = true;
            }
            if (error.booleanValue()) {
                res10 = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", "text/plain", "NOTOK");
                res10.addHeader("Access-Control-Allow-Origin", "*");
                res10.addHeader("Access-Control-Allow-Headers", "origin, content-type");
                res10.addHeader("Access-Control-Allow-Methods", "POST,OPTIONS,GET,HEAD,PUT");
                res10.addHeader("Allow", "POST,OPTIONS,GET,HEAD,PUT");
                return res10;
            }
            res10 = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", "text/plain", "OK");
            res10.addHeader("Access-Control-Allow-Origin", "*");
            res10.addHeader("Access-Control-Allow-Headers", "origin, content-type");
            res10.addHeader("Access-Control-Allow-Methods", "POST,OPTIONS,GET,HEAD,PUT");
            res10.addHeader("Allow", "POST,OPTIONS,GET,HEAD,PUT");
            return res10;
        }
        e = header.propertyNames();
        while (e.hasMoreElements()) {
            value = (String)e.nextElement();
            Log.d((String)LOG_TAG, (String)("  HDR: '" + value + "' = '" + header.getProperty(value) + "'"));
        }
        e = parms.propertyNames();
        while (e.hasMoreElements()) {
            value = (String)e.nextElement();
            Log.d((String)LOG_TAG, (String)("  PRM: '" + value + "' = '" + parms.getProperty(value) + "'"));
        }
        e = files.propertyNames();
        if (e.hasMoreElements()) {
            String fieldname = (String)e.nextElement();
            String tempLocation = files.getProperty(fieldname);
            String filename = parms.getProperty(fieldname);
            if (filename.startsWith("..") || filename.endsWith("..") || filename.indexOf("../") >= 0) {
                Log.d((String)LOG_TAG, (String)(" Ignoring invalid filename: " + filename));
                filename = null;
            }
            File fileFrom = new File(tempLocation);
            if (filename == null) {
                fileFrom.delete();
            } else {
                File fileTo = new File(this.rootDir + "/" + filename);
                if (!fileFrom.renameTo(fileTo)) {
                    this.copyFile(fileFrom, fileTo);
                    fileFrom.delete();
                }
            }
            Log.d((String)LOG_TAG, (String)(" UPLOADED: '" + filename + "' was at '" + tempLocation + "'"));
            NanoHTTPD.Response res11 = new NanoHTTPD.Response((NanoHTTPD)this, "200 OK", "text/plain", "OK");
            res11.addHeader("Access-Control-Allow-Origin", "*");
            res11.addHeader("Access-Control-Allow-Headers", "origin, content-type");
            res11.addHeader("Access-Control-Allow-Methods", "POST,OPTIONS,GET,HEAD,PUT");
            res11.addHeader("Allow", "POST,OPTIONS,GET,HEAD,PUT");
            return res11;
        }
        return this.serveFile(uri, header, this.rootDir, true);
    }

    private void copyFile(File infile, File outfile) {
        try {
            int len;
            FileInputStream in = new FileInputStream(infile);
            FileOutputStream out = new FileOutputStream(outfile);
            byte[] buffer = new byte[32768];
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void setHmacKey(String inputKey) {
        hmacKey = inputKey.getBytes();
        seq = 1;
    }

    private void doPackageUpdate(String inurl) {
        PackageInstaller.doPackageInstall(this.form, inurl);
    }

    public void resetSeq() {
        seq = 1;
    }
}

