/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.util;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.text.Html;
import android.util.Log;
import java.io.IOException;
import java.util.concurrent.SynchronousQueue;

public class AccountChooser {
    private static final String NO_ACCOUNT = "";
    private static final String LOG_TAG = "AccountChooser";
    private static final String ACCOUNT_PREFERENCE = "account";
    private static final String ACCOUNT_TYPE = "com.google";
    private AccountManager accountManager;
    private String service;
    private String preferencesKey;
    private Activity activity;
    private String chooseAccountPrompt;

    public AccountChooser(Activity activity, String service, String title, String key) {
        this.activity = activity;
        this.service = service;
        this.chooseAccountPrompt = title;
        this.preferencesKey = key;
        this.accountManager = AccountManager.get((Context)activity);
    }

    public Account findAccount() {
        Account account;
        Account[] accounts = this.accountManager.getAccountsByType(ACCOUNT_TYPE);
        if (accounts.length == 1) {
            this.persistAccountName(accounts[0].name);
            return accounts[0];
        }
        if (accounts.length == 0) {
            String accountName = this.createAccount();
            if (accountName != null) {
                this.persistAccountName(accountName);
                return this.accountManager.getAccountsByType(ACCOUNT_TYPE)[0];
            }
            Log.i((String)LOG_TAG, (String)"User failed to create a valid account");
            return null;
        }
        String accountName = this.getPersistedAccountName();
        if (accountName != null && (account = this.chooseAccount(accountName, accounts)) != null) {
            return account;
        }
        accountName = this.selectAccount(accounts);
        if (accountName != null) {
            this.persistAccountName(accountName);
            return this.chooseAccount(accountName, accounts);
        }
        Log.i((String)LOG_TAG, (String)"User failed to choose an account");
        return null;
    }

    private Account chooseAccount(String accountName, Account[] accounts) {
        for (Account account : accounts) {
            if (!account.name.equals(accountName)) continue;
            Log.i((String)LOG_TAG, (String)("chose account: " + accountName));
            return account;
        }
        return null;
    }

    private String createAccount() {
        Log.i((String)LOG_TAG, (String)"Adding auth token account ...");
        AccountManagerFuture future = this.accountManager.addAccount(ACCOUNT_TYPE, this.service, null, null, this.activity, null, null);
        try {
            Bundle result = (Bundle)future.getResult();
            String accountName = result.getString("authAccount");
            Log.i((String)LOG_TAG, (String)("created: " + accountName));
            return accountName;
        }
        catch (OperationCanceledException e) {
            e.printStackTrace();
        }
        catch (AuthenticatorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String selectAccount(Account[] accounts) {
        SynchronousQueue<String> queue = new SynchronousQueue<String>();
        SelectAccount select = new SelectAccount(accounts, queue);
        select.start();
        Log.i((String)LOG_TAG, (String)"Select: waiting for user...");
        String account = null;
        try {
            account = queue.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Log.i((String)LOG_TAG, (String)("Selected: " + account));
        return account == NO_ACCOUNT ? null : account;
    }

    private SharedPreferences getPreferences() {
        return this.activity.getSharedPreferences(this.preferencesKey, 0);
    }

    private String getPersistedAccountName() {
        return this.getPreferences().getString(ACCOUNT_PREFERENCE, null);
    }

    private void persistAccountName(String accountName) {
        Log.i((String)LOG_TAG, (String)("persisting account: " + accountName));
        this.getPreferences().edit().putString(ACCOUNT_PREFERENCE, accountName).commit();
    }

    public void forgetAccountName() {
        this.getPreferences().edit().remove(ACCOUNT_PREFERENCE).commit();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SelectAccount
    extends Thread
    implements DialogInterface.OnClickListener,
    DialogInterface.OnCancelListener {
        private String[] accountNames;
        private SynchronousQueue<String> queue;

        SelectAccount(Account[] accounts, SynchronousQueue<String> queue) {
            this.queue = queue;
            this.accountNames = new String[accounts.length];
            for (int i = 0; i < accounts.length; ++i) {
                this.accountNames[i] = accounts[i].name;
            }
        }

        @Override
        public void run() {
            AccountChooser.this.activity.runOnUiThread(new Runnable(){

                public void run() {
                    AlertDialog.Builder ab = new AlertDialog.Builder((Context)AccountChooser.this.activity).setTitle((CharSequence)Html.fromHtml((String)AccountChooser.this.chooseAccountPrompt)).setOnCancelListener((DialogInterface.OnCancelListener)SelectAccount.this).setSingleChoiceItems((CharSequence[])SelectAccount.this.accountNames, -1, (DialogInterface.OnClickListener)SelectAccount.this);
                    ab.show();
                    Log.i((String)AccountChooser.LOG_TAG, (String)"Dialog showing!");
                }
            });
        }

        public void onClick(DialogInterface dialog, int button) {
            try {
                if (button >= 0) {
                    String account = this.accountNames[button];
                    Log.i((String)AccountChooser.LOG_TAG, (String)("Chose: " + account));
                    this.queue.put(account);
                } else {
                    this.queue.put(AccountChooser.NO_ACCOUNT);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            dialog.dismiss();
        }

        public void onCancel(DialogInterface dialog) {
            Log.i((String)AccountChooser.LOG_TAG, (String)"Chose: canceled");
            this.onClick(dialog, -1);
        }
    }
}

