/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.multidex;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.GregorianCalendar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

class ZipEntryReader {
    static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final int GPBF_ENCRYPTED_FLAG = 1;
    private static final int GPBF_UNSUPPORTED_MASK = 1;
    private static final long CENSIG = 33639248L;

    ZipEntryReader() {
    }

    static ZipEntry readEntry(ByteBuffer in) throws IOException {
        int sig = in.getInt();
        if ((long)sig != 33639248L) {
            throw new ZipException("Central Directory Entry not found");
        }
        in.position(8);
        int gpbf = in.getShort() & 0xFFFF;
        if ((gpbf & 1) != 0) {
            throw new ZipException("Invalid General Purpose Bit Flag: " + gpbf);
        }
        int compressionMethod = in.getShort() & 0xFFFF;
        int time = in.getShort() & 0xFFFF;
        int modDate = in.getShort() & 0xFFFF;
        long crc = (long)in.getInt() & 0xFFFFFFFFL;
        long compressedSize = (long)in.getInt() & 0xFFFFFFFFL;
        long size = (long)in.getInt() & 0xFFFFFFFFL;
        int nameLength = in.getShort() & 0xFFFF;
        int extraLength = in.getShort() & 0xFFFF;
        int commentByteCount = in.getShort() & 0xFFFF;
        in.position(42);
        long localHeaderRelOffset = (long)in.getInt() & 0xFFFFFFFFL;
        byte[] nameBytes = new byte[nameLength];
        in.get(nameBytes, 0, nameBytes.length);
        String name = new String(nameBytes, 0, nameBytes.length, UTF_8);
        ZipEntry entry = new ZipEntry(name);
        entry.setMethod(compressionMethod);
        entry.setTime(ZipEntryReader.getTime(time, modDate));
        entry.setCrc(crc);
        entry.setCompressedSize(compressedSize);
        entry.setSize(size);
        if (commentByteCount > 0) {
            byte[] commentBytes = new byte[commentByteCount];
            in.get(commentBytes, 0, commentByteCount);
            entry.setComment(new String(commentBytes, 0, commentBytes.length, UTF_8));
        }
        if (extraLength > 0) {
            byte[] extra = new byte[extraLength];
            in.get(extra, 0, extraLength);
            entry.setExtra(extra);
        }
        return entry;
    }

    private static long getTime(int time, int modDate) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(14, 0);
        cal.set(1980 + (modDate >> 9 & 0x7F), (modDate >> 5 & 0xF) - 1, modDate & 0x1F, time >> 11 & 0x1F, time >> 5 & 0x3F, (time & 0x1F) << 1);
        return cal.getTime().getTime();
    }
}

