/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime.multidex;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.util.Log;
import com.google.appinventor.components.runtime.multidex.ZipUtil;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MultiDexExtractor {
    private static final String TAG = "MultiDex";
    private static final String DEX_PREFIX = "classes";
    private static final String DEX_SUFFIX = ".dex";
    private static final String EXTRACTED_NAME_EXT = ".classes";
    private static final String EXTRACTED_SUFFIX = ".zip";
    private static final int MAX_EXTRACT_ATTEMPTS = 3;
    private static final String PREFS_FILE = "multidex.version";
    private static final String KEY_TIME_STAMP = "timestamp";
    private static final String KEY_CRC = "crc";
    private static final String KEY_DEX_NUMBER = "dex.number";
    private static final int BUFFER_SIZE = 16384;
    private static final long NO_VALUE = -1L;
    private static Method sApplyMethod;

    MultiDexExtractor() {
    }

    public static boolean mustLoad(Context context, ApplicationInfo applicationInfo) {
        File sourceApk = new File(applicationInfo.sourceDir);
        try {
            long currentCrc = MultiDexExtractor.getZipCrc(sourceApk);
            if (MultiDexExtractor.isModified(context, sourceApk, currentCrc)) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    static List<File> load(Context context, ApplicationInfo applicationInfo, File dexDir, boolean forceReload) throws IOException {
        List<File> files;
        Log.i((String)TAG, (String)("MultiDexExtractor.load(" + applicationInfo.sourceDir + ", " + forceReload + ")"));
        File sourceApk = new File(applicationInfo.sourceDir);
        long currentCrc = MultiDexExtractor.getZipCrc(sourceApk);
        if (!forceReload && !MultiDexExtractor.isModified(context, sourceApk, currentCrc)) {
            try {
                files = MultiDexExtractor.loadExistingExtractions(context, sourceApk, dexDir);
            }
            catch (IOException ioe) {
                Log.w((String)TAG, (String)"Failed to reload existing extracted secondary dex files, falling back to fresh extraction", (Throwable)ioe);
                files = MultiDexExtractor.performExtractions(sourceApk, dexDir);
                MultiDexExtractor.putStoredApkInfo(context, MultiDexExtractor.getTimeStamp(sourceApk), currentCrc, files.size() + 1);
            }
        } else {
            Log.i((String)TAG, (String)"Detected that extraction must be performed.");
            files = MultiDexExtractor.performExtractions(sourceApk, dexDir);
            MultiDexExtractor.putStoredApkInfo(context, MultiDexExtractor.getTimeStamp(sourceApk), currentCrc, files.size() + 1);
        }
        Log.i((String)TAG, (String)("load found " + files.size() + " secondary dex files"));
        return files;
    }

    private static List<File> loadExistingExtractions(Context context, File sourceApk, File dexDir) throws IOException {
        Log.i((String)TAG, (String)"loading existing secondary dex files");
        String extractedFilePrefix = sourceApk.getName() + EXTRACTED_NAME_EXT;
        int totalDexNumber = MultiDexExtractor.getMultiDexPreferences(context).getInt(KEY_DEX_NUMBER, 1);
        ArrayList<File> files = new ArrayList<File>(totalDexNumber);
        for (int secondaryNumber = 2; secondaryNumber <= totalDexNumber; ++secondaryNumber) {
            String fileName = extractedFilePrefix + secondaryNumber + EXTRACTED_SUFFIX;
            File extractedFile = new File(dexDir, fileName);
            if (extractedFile.isFile()) {
                files.add(extractedFile);
                if (MultiDexExtractor.verifyZipFile(extractedFile)) continue;
                Log.i((String)TAG, (String)("Invalid zip file: " + extractedFile));
                throw new IOException("Invalid ZIP file.");
            }
            throw new IOException("Missing extracted secondary dex file '" + extractedFile.getPath() + "'");
        }
        return files;
    }

    private static boolean isModified(Context context, File archive, long currentCrc) {
        SharedPreferences prefs = MultiDexExtractor.getMultiDexPreferences(context);
        return prefs.getLong(KEY_TIME_STAMP, -1L) != MultiDexExtractor.getTimeStamp(archive) || prefs.getLong(KEY_CRC, -1L) != currentCrc;
    }

    private static long getTimeStamp(File archive) {
        long timeStamp = archive.lastModified();
        if (timeStamp == -1L) {
            --timeStamp;
        }
        return timeStamp;
    }

    private static long getZipCrc(File archive) throws IOException {
        long computedValue = ZipUtil.getZipCrc(archive);
        if (computedValue == -1L) {
            --computedValue;
        }
        return computedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<File> performExtractions(File sourceApk, File dexDir) throws IOException {
        String extractedFilePrefix = sourceApk.getName() + EXTRACTED_NAME_EXT;
        MultiDexExtractor.prepareDexDir(dexDir, extractedFilePrefix);
        ArrayList<File> files = new ArrayList<File>();
        ZipFile apk = new ZipFile(sourceApk);
        try {
            int secondaryNumber = 2;
            ZipEntry dexFile = apk.getEntry(DEX_PREFIX + secondaryNumber + DEX_SUFFIX);
            while (dexFile != null) {
                String fileName = extractedFilePrefix + secondaryNumber + EXTRACTED_SUFFIX;
                File extractedFile = new File(dexDir, fileName);
                files.add(extractedFile);
                Log.i((String)TAG, (String)("Extraction is needed for file " + extractedFile));
                boolean isExtractionSuccessful = false;
                for (int numAttempts = 0; numAttempts < 3 && !isExtractionSuccessful; ++numAttempts) {
                    MultiDexExtractor.extract(apk, dexFile, extractedFile, extractedFilePrefix);
                    isExtractionSuccessful = MultiDexExtractor.verifyZipFile(extractedFile);
                    Log.i((String)TAG, (String)("Extraction " + (isExtractionSuccessful ? "success" : "failed") + " - length " + extractedFile.getAbsolutePath() + ": " + extractedFile.length()));
                    if (isExtractionSuccessful) continue;
                    extractedFile.delete();
                    if (!extractedFile.exists()) continue;
                    Log.w((String)TAG, (String)("Failed to delete corrupted secondary dex '" + extractedFile.getPath() + "'"));
                }
                if (!isExtractionSuccessful) {
                    throw new IOException("Could not create zip file " + extractedFile.getAbsolutePath() + " for secondary dex (" + secondaryNumber + ")");
                }
                dexFile = apk.getEntry(DEX_PREFIX + ++secondaryNumber + DEX_SUFFIX);
            }
        }
        finally {
            try {
                apk.close();
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Failed to close resource", (Throwable)e);
            }
        }
        return files;
    }

    private static void putStoredApkInfo(Context context, long timeStamp, long crc, int totalDexNumber) {
        SharedPreferences prefs = MultiDexExtractor.getMultiDexPreferences(context);
        SharedPreferences.Editor edit = prefs.edit();
        edit.putLong(KEY_TIME_STAMP, timeStamp);
        edit.putLong(KEY_CRC, crc);
        edit.putInt(KEY_DEX_NUMBER, totalDexNumber);
        MultiDexExtractor.apply(edit);
    }

    private static SharedPreferences getMultiDexPreferences(Context context) {
        return context.getSharedPreferences(PREFS_FILE, Build.VERSION.SDK_INT < 11 ? 0 : 4);
    }

    private static void prepareDexDir(File dexDir, final String extractedFilePrefix) throws IOException {
        dexDir.mkdirs();
        if (!dexDir.isDirectory()) {
            throw new IOException("Failed to create dex directory " + dexDir.getPath());
        }
        FileFilter filter = new FileFilter(){

            public boolean accept(File pathname) {
                return !pathname.getName().startsWith(extractedFilePrefix);
            }
        };
        File[] files = dexDir.listFiles(filter);
        if (files == null) {
            Log.w((String)TAG, (String)("Failed to list secondary dex dir content (" + dexDir.getPath() + ")."));
            return;
        }
        for (File oldFile : files) {
            Log.i((String)TAG, (String)("Trying to delete old file " + oldFile.getPath() + " of size " + oldFile.length()));
            if (!oldFile.delete()) {
                Log.w((String)TAG, (String)("Failed to delete old file " + oldFile.getPath()));
                continue;
            }
            Log.i((String)TAG, (String)("Deleted old file " + oldFile.getPath()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extract(ZipFile apk, ZipEntry dexFile, File extractTo, String extractedFilePrefix) throws IOException, FileNotFoundException {
        InputStream in = apk.getInputStream(dexFile);
        ZipOutputStream out = null;
        File tmp = File.createTempFile(extractedFilePrefix, EXTRACTED_SUFFIX, extractTo.getParentFile());
        Log.i((String)TAG, (String)("Extracting " + tmp.getPath()));
        try {
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(tmp)));
            try {
                ZipEntry classesDex = new ZipEntry("classes.dex");
                classesDex.setTime(dexFile.getTime());
                out.putNextEntry(classesDex);
                byte[] buffer = new byte[16384];
                int length = in.read(buffer);
                while (length != -1) {
                    out.write(buffer, 0, length);
                    length = in.read(buffer);
                }
                out.closeEntry();
            }
            finally {
                out.close();
            }
            Log.i((String)TAG, (String)("Renaming to " + extractTo.getPath()));
            if (!tmp.renameTo(extractTo)) {
                throw new IOException("Failed to rename \"" + tmp.getAbsolutePath() + "\" to \"" + extractTo.getAbsolutePath() + "\"");
            }
        }
        finally {
            MultiDexExtractor.closeQuietly(in);
            tmp.delete();
        }
    }

    static boolean verifyZipFile(File file) {
        try {
            ZipFile zipFile = new ZipFile(file);
            try {
                zipFile.close();
                return true;
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)("Failed to close zip file: " + file.getAbsolutePath()));
            }
        }
        catch (ZipException ex) {
            Log.w((String)TAG, (String)("File " + file.getAbsolutePath() + " is not a valid zip file."), (Throwable)ex);
        }
        catch (IOException ex) {
            Log.w((String)TAG, (String)("Got an IOException trying to open zip file: " + file.getAbsolutePath()), (Throwable)ex);
        }
        return false;
    }

    private static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Failed to close resource", (Throwable)e);
        }
    }

    private static void apply(SharedPreferences.Editor editor) {
        if (sApplyMethod != null) {
            try {
                sApplyMethod.invoke((Object)editor, new Object[0]);
                return;
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        editor.commit();
    }

    static {
        try {
            Class<SharedPreferences.Editor> cls = SharedPreferences.Editor.class;
            sApplyMethod = cls.getMethod("apply", new Class[0]);
        }
        catch (NoSuchMethodException unused) {
            sApplyMethod = null;
        }
    }
}

