/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.app.Activity;
import android.text.TextUtils;
import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesLibraries;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.common.HtmlEntities;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.collect.Lists;
import com.google.appinventor.components.runtime.collect.Maps;
import com.google.appinventor.components.runtime.util.AsynchUtil;
import com.google.appinventor.components.runtime.util.FileUtil;
import com.google.appinventor.components.runtime.util.GingerbreadUtil;
import com.google.appinventor.components.runtime.util.JsonUtil;
import com.google.appinventor.components.runtime.util.MediaUtil;
import com.google.appinventor.components.runtime.util.SdkLevel;
import com.google.appinventor.components.runtime.util.YailList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DesignerComponent(version=4, description="Non-visible component that provides functions for HTTP GET, POST, PUT, and DELETE requests.", category=ComponentCategory.CONNECTIVITY, nonVisible=true, iconName="images/web.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.INTERNET,android.permission.WRITE_EXTERNAL_STORAGE,android.permission.READ_EXTERNAL_STORAGE")
@UsesLibraries(libraries="json.jar")
public class Web
extends AndroidNonvisibleComponent
implements Component {
    private static final String LOG_TAG = "Web";
    private static final Map<String, String> mimeTypeToExtension = Maps.newHashMap();
    private final Activity activity;
    private final CookieHandler cookieHandler;
    private String urlString = "";
    private boolean allowCookies;
    private YailList requestHeaders = new YailList();
    private boolean saveResponse;
    private String responseFileName = "";

    public Web(ComponentContainer container) {
        super(container.$form());
        this.activity = container.$context();
        this.cookieHandler = SdkLevel.getLevel() >= 9 ? GingerbreadUtil.newCookieManager() : null;
    }

    protected Web() {
        super(null);
        this.activity = null;
        this.cookieHandler = null;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="The URL for the web request.")
    public String Url() {
        return this.urlString;
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty
    public void Url(String url) {
        this.urlString = url;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="The request headers, as a list of two-element sublists. The first element of each sublist represents the request header field name. The second element of each sublist represents the request header field values, either a single value or a list containing multiple values.")
    public YailList RequestHeaders() {
        return this.requestHeaders;
    }

    @SimpleProperty
    public void RequestHeaders(YailList list) {
        try {
            Web.processRequestHeaders(list);
            this.requestHeaders = list;
        }
        catch (InvalidRequestHeadersException e) {
            this.form.dispatchErrorOccurredEvent(this, "RequestHeaders", e.errorNumber, e.index);
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="Whether the cookies from a response should be saved and used in subsequent requests. Cookies are only supported on Android version 2.3 or greater.")
    public boolean AllowCookies() {
        return this.allowCookies;
    }

    @DesignerProperty(editorType="boolean", defaultValue="false")
    @SimpleProperty
    public void AllowCookies(boolean allowCookies) {
        this.allowCookies = allowCookies;
        if (allowCookies && this.cookieHandler == null) {
            this.form.dispatchErrorOccurredEvent(this, "AllowCookies", 4, new Object[0]);
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="Whether the response should be saved in a file.")
    public boolean SaveResponse() {
        return this.saveResponse;
    }

    @DesignerProperty(editorType="boolean", defaultValue="false")
    @SimpleProperty
    public void SaveResponse(boolean saveResponse) {
        this.saveResponse = saveResponse;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="The name of the file where the response should be saved. If SaveResponse is true and ResponseFileName is empty, then a new file name will be generated.")
    public String ResponseFileName() {
        return this.responseFileName;
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty
    public void ResponseFileName(String responseFileName) {
        this.responseFileName = responseFileName;
    }

    @SimpleFunction(description="Clears all cookies for this Web component.")
    public void ClearCookies() {
        if (this.cookieHandler != null) {
            GingerbreadUtil.clearCookies(this.cookieHandler);
        } else {
            this.form.dispatchErrorOccurredEvent(this, "ClearCookies", 4, new Object[0]);
        }
    }

    @SimpleFunction
    public void Get() {
        final CapturedProperties webProps = this.capturePropertyValues("Get");
        if (webProps == null) {
            return;
        }
        AsynchUtil.runAsynchronously(new Runnable(){

            public void run() {
                try {
                    Web.this.performRequest(webProps, null, null, "GET");
                }
                catch (FileUtil.FileException e) {
                    Web.this.form.dispatchErrorOccurredEvent(Web.this, "Get", e.getErrorMessageNumber(), new Object[0]);
                }
                catch (Exception e) {
                    Log.e((String)Web.LOG_TAG, (String)"ERROR_UNABLE_TO_GET", (Throwable)e);
                    Web.this.form.dispatchErrorOccurredEvent(Web.this, "Get", 1101, webProps.urlString);
                }
            }
        });
    }

    @SimpleFunction(description="Performs an HTTP POST request using the Url property and the specified text.<br>The characters of the text are encoded using UTF-8 encoding.<br>If the SaveResponse property is true, the response will be saved in a file and the GotFile event will be triggered. The responseFileName property can be used to specify the name of the file.<br>If the SaveResponse property is false, the GotText event will be triggered.")
    public void PostText(String text) {
        this.requestTextImpl(text, "UTF-8", "PostText", "POST");
    }

    @SimpleFunction(description="Performs an HTTP POST request using the Url property and the specified text.<br>The characters of the text are encoded using the given encoding.<br>If the SaveResponse property is true, the response will be saved in a file and the GotFile event will be triggered. The ResponseFileName property can be used to specify the name of the file.<br>If the SaveResponse property is false, the GotText event will be triggered.")
    public void PostTextWithEncoding(String text, String encoding) {
        this.requestTextImpl(text, encoding, "PostTextWithEncoding", "POST");
    }

    @SimpleFunction(description="Performs an HTTP POST request using the Url property and data from the specified file.<br>If the SaveResponse property is true, the response will be saved in a file and the GotFile event will be triggered. The ResponseFileName property can be used to specify the name of the file.<br>If the SaveResponse property is false, the GotText event will be triggered.")
    public void PostFile(final String path) {
        final CapturedProperties webProps = this.capturePropertyValues("PostFile");
        if (webProps == null) {
            return;
        }
        AsynchUtil.runAsynchronously(new Runnable(){

            public void run() {
                try {
                    Web.this.performRequest(webProps, null, path, "POST");
                }
                catch (FileUtil.FileException e) {
                    Web.this.form.dispatchErrorOccurredEvent(Web.this, "PostFile", e.getErrorMessageNumber(), new Object[0]);
                }
                catch (Exception e) {
                    Web.this.form.dispatchErrorOccurredEvent(Web.this, "PostFile", 1104, path, webProps.urlString);
                }
            }
        });
    }

    @SimpleFunction(description="Performs an HTTP PUT request using the Url property and the specified text.<br>The characters of the text are encoded using UTF-8 encoding.<br>If the SaveResponse property is true, the response will be saved in a file and the GotFile event will be triggered. The responseFileName property can be used to specify the name of the file.<br>If the SaveResponse property is false, the GotText event will be triggered.")
    public void PutText(String text) {
        this.requestTextImpl(text, "UTF-8", "PutText", "PUT");
    }

    @SimpleFunction(description="Performs an HTTP PUT request using the Url property and the specified text.<br>The characters of the text are encoded using the given encoding.<br>If the SaveResponse property is true, the response will be saved in a file and the GotFile event will be triggered. The ResponseFileName property can be used to specify the name of the file.<br>If the SaveResponse property is false, the GotText event will be triggered.")
    public void PutTextWithEncoding(String text, String encoding) {
        this.requestTextImpl(text, encoding, "PutTextWithEncoding", "PUT");
    }

    @SimpleFunction(description="Performs an HTTP PUT request using the Url property and data from the specified file.<br>If the SaveResponse property is true, the response will be saved in a file and the GotFile event will be triggered. The ResponseFileName property can be used to specify the name of the file.<br>If the SaveResponse property is false, the GotText event will be triggered.")
    public void PutFile(final String path) {
        final CapturedProperties webProps = this.capturePropertyValues("PutFile");
        if (webProps == null) {
            return;
        }
        AsynchUtil.runAsynchronously(new Runnable(){

            public void run() {
                try {
                    Web.this.performRequest(webProps, null, path, "PUT");
                }
                catch (FileUtil.FileException e) {
                    Web.this.form.dispatchErrorOccurredEvent(Web.this, "PutFile", e.getErrorMessageNumber(), new Object[0]);
                }
                catch (Exception e) {
                    Web.this.form.dispatchErrorOccurredEvent(Web.this, "PutFile", 1104, path, webProps.urlString);
                }
            }
        });
    }

    @SimpleFunction
    public void Delete() {
        final CapturedProperties webProps = this.capturePropertyValues("Delete");
        if (webProps == null) {
            return;
        }
        AsynchUtil.runAsynchronously(new Runnable(){

            public void run() {
                try {
                    Web.this.performRequest(webProps, null, null, "DELETE");
                }
                catch (FileUtil.FileException e) {
                    Web.this.form.dispatchErrorOccurredEvent(Web.this, "Delete", e.getErrorMessageNumber(), new Object[0]);
                }
                catch (Exception e) {
                    Web.this.form.dispatchErrorOccurredEvent(Web.this, "Delete", 1114, webProps.urlString);
                }
            }
        });
    }

    private void requestTextImpl(final String text, final String encoding, final String functionName, final String httpVerb) {
        final CapturedProperties webProps = this.capturePropertyValues(functionName);
        if (webProps == null) {
            return;
        }
        AsynchUtil.runAsynchronously(new Runnable(){

            public void run() {
                byte[] requestData;
                try {
                    requestData = encoding == null || encoding.length() == 0 ? text.getBytes("UTF-8") : text.getBytes(encoding);
                }
                catch (UnsupportedEncodingException e) {
                    Web.this.form.dispatchErrorOccurredEvent(Web.this, functionName, 1102, encoding);
                    return;
                }
                try {
                    Web.this.performRequest(webProps, requestData, null, httpVerb);
                }
                catch (FileUtil.FileException e) {
                    Web.this.form.dispatchErrorOccurredEvent(Web.this, functionName, e.getErrorMessageNumber(), new Object[0]);
                }
                catch (Exception e) {
                    Web.this.form.dispatchErrorOccurredEvent(Web.this, functionName, 1103, text, webProps.urlString);
                }
            }
        });
    }

    @SimpleEvent
    public void GotText(String url, int responseCode, String responseType, String responseContent) {
        EventDispatcher.dispatchEvent(this, "GotText", url, responseCode, responseType, responseContent);
    }

    @SimpleEvent
    public void GotFile(String url, int responseCode, String responseType, String fileName) {
        EventDispatcher.dispatchEvent(this, "GotFile", url, responseCode, responseType, fileName);
    }

    @SimpleFunction
    public String BuildRequestData(YailList list) {
        try {
            return this.buildRequestData(list);
        }
        catch (BuildRequestDataException e) {
            this.form.dispatchErrorOccurredEvent(this, "BuildRequestData", e.errorNumber, e.index);
            return "";
        }
    }

    String buildRequestData(YailList list) throws BuildRequestDataException {
        StringBuilder sb = new StringBuilder();
        String delimiter = "";
        for (int i = 0; i < list.size(); ++i) {
            YailList sublist;
            Object item = list.getObject(i);
            if (item instanceof YailList) {
                sublist = (YailList)item;
                if (sublist.size() != 2) {
                    throw new BuildRequestDataException(1113, i + 1);
                }
            } else {
                throw new BuildRequestDataException(1112, i + 1);
            }
            String name = sublist.getObject(0).toString();
            String value = sublist.getObject(1).toString();
            sb.append(delimiter).append(this.UriEncode(name)).append('=').append(this.UriEncode(value));
            delimiter = "&";
        }
        return sb.toString();
    }

    @SimpleFunction
    public String UriEncode(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)LOG_TAG, (String)"UTF-8 is unsupported?", (Throwable)e);
            return "";
        }
    }

    @SimpleFunction
    public Object JsonTextDecode(String jsonText) {
        try {
            return Web.decodeJsonText(jsonText);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, "JsonTextDecode", 1105, jsonText);
            return "";
        }
    }

    static Object decodeJsonText(String jsonText) throws IllegalArgumentException {
        try {
            return JsonUtil.getObjectFromJson(jsonText);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("jsonText is not a legal JSON value");
        }
    }

    @SimpleFunction(description="Decodes the given XML string to produce a list structure.  See the App Inventor documentation on \"Other topics, notes, and details\" for information.")
    public Object XMLTextDecode(String XmlText) {
        try {
            JSONObject json = XML.toJSONObject((String)XmlText);
            return this.JsonTextDecode(json.toString());
        }
        catch (JSONException e) {
            Log.e((String)"Exception in XMLTextDecode", (String)e.getMessage());
            this.form.dispatchErrorOccurredEvent(this, "XMLTextDecode", 1105, e.getMessage());
            return YailList.makeEmptyList();
        }
    }

    @SimpleFunction(description="Decodes the given HTML text value. HTML character entities such as &amp;amp;, &amp;lt;, &amp;gt;, &amp;apos;, and &amp;quot; are changed to &amp;, &lt;, &gt;, &#39;, and &quot;. Entities such as &amp;#xhhhh, and &amp;#nnnn are changed to the appropriate characters.")
    public String HtmlTextDecode(String htmlText) {
        try {
            return HtmlEntities.decodeHtmlText(htmlText);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, "HtmlTextDecode", 1106, htmlText);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performRequest(final CapturedProperties webProps, byte[] postData, String postFile, String httpVerb) throws IOException {
        HttpURLConnection connection = Web.openConnection(webProps, httpVerb);
        if (connection != null) {
            try {
                if (postData != null) {
                    Web.writeRequestData(connection, postData);
                } else if (postFile != null) {
                    this.writeRequestFile(connection, postFile);
                }
                final int responseCode = connection.getResponseCode();
                final String responseType = Web.getResponseType(connection);
                this.processResponseCookies(connection);
                if (this.saveResponse) {
                    final String path = Web.saveResponseContent(connection, webProps.responseFileName, responseType);
                    this.activity.runOnUiThread(new Runnable(){

                        public void run() {
                            Web.this.GotFile(webProps.urlString, responseCode, responseType, path);
                        }
                    });
                } else {
                    final String responseContent = Web.getResponseContent(connection);
                    this.activity.runOnUiThread(new Runnable(){

                        public void run() {
                            Web.this.GotText(webProps.urlString, responseCode, responseType, responseContent);
                        }
                    });
                }
            }
            finally {
                connection.disconnect();
            }
        }
    }

    private static HttpURLConnection openConnection(CapturedProperties webProps, String httpVerb) throws IOException, ClassCastException, ProtocolException {
        String name;
        HttpURLConnection connection = (HttpURLConnection)webProps.url.openConnection();
        if (httpVerb.equals("PUT") || httpVerb.equals("DELETE")) {
            connection.setRequestMethod(httpVerb);
        }
        for (Map.Entry<String, List<String>> header : webProps.requestHeaders.entrySet()) {
            name = header.getKey();
            for (String value : header.getValue()) {
                connection.addRequestProperty(name, value);
            }
        }
        if (webProps.cookies != null) {
            for (Map.Entry<String, List<String>> cookie : webProps.cookies.entrySet()) {
                name = cookie.getKey();
                for (String value : cookie.getValue()) {
                    connection.addRequestProperty(name, value);
                }
            }
        }
        return connection;
    }

    private static void writeRequestData(HttpURLConnection connection, byte[] postData) throws IOException {
        connection.setDoOutput(true);
        connection.setFixedLengthStreamingMode(postData.length);
        BufferedOutputStream out = new BufferedOutputStream(connection.getOutputStream());
        try {
            out.write(postData, 0, postData.length);
            out.flush();
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRequestFile(HttpURLConnection connection, String path) throws IOException {
        BufferedInputStream in = new BufferedInputStream(MediaUtil.openMedia(this.form, path));
        try {
            connection.setDoOutput(true);
            connection.setChunkedStreamingMode(0);
            BufferedOutputStream out = new BufferedOutputStream(connection.getOutputStream());
            try {
                int b;
                while ((b = in.read()) != -1) {
                    out.write(b);
                }
                out.flush();
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    private static String getResponseType(HttpURLConnection connection) {
        String responseType = connection.getContentType();
        return responseType != null ? responseType : "";
    }

    private void processResponseCookies(HttpURLConnection connection) {
        if (this.allowCookies && this.cookieHandler != null) {
            try {
                Map<String, List<String>> headerFields = connection.getHeaderFields();
                this.cookieHandler.put(connection.getURL().toURI(), headerFields);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResponseContent(HttpURLConnection connection) throws IOException {
        String encoding = connection.getContentEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        InputStreamReader reader = new InputStreamReader(Web.getConnectionStream(connection), encoding);
        try {
            int read;
            int contentLength = connection.getContentLength();
            StringBuilder sb = contentLength != -1 ? new StringBuilder(contentLength) : new StringBuilder();
            char[] buf = new char[1024];
            while ((read = reader.read(buf)) != -1) {
                sb.append(buf, 0, read);
            }
            String string2 = sb.toString();
            return string2;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String saveResponseContent(HttpURLConnection connection, String responseFileName, String responseType) throws IOException {
        File file = Web.createFile(responseFileName, responseType);
        BufferedInputStream in = new BufferedInputStream(Web.getConnectionStream(connection), 4096);
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file), 4096);
            try {
                int b;
                while ((b = in.read()) != -1) {
                    out.write(b);
                }
                out.flush();
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
        return file.getAbsolutePath();
    }

    private static InputStream getConnectionStream(HttpURLConnection connection) {
        try {
            return connection.getInputStream();
        }
        catch (IOException e1) {
            return connection.getErrorStream();
        }
    }

    private static File createFile(String fileName, String responseType) throws IOException, FileUtil.FileException {
        String extension;
        if (!TextUtils.isEmpty((CharSequence)fileName)) {
            return FileUtil.getExternalFile(fileName);
        }
        int indexOfSemicolon = responseType.indexOf(59);
        if (indexOfSemicolon != -1) {
            responseType = responseType.substring(0, indexOfSemicolon);
        }
        if ((extension = mimeTypeToExtension.get(responseType)) == null) {
            extension = "tmp";
        }
        return FileUtil.getDownloadFile(extension);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, List<String>> processRequestHeaders(YailList list) throws InvalidRequestHeadersException {
        HashMap<String, List<String>> requestHeadersMap = Maps.newHashMap();
        for (int i = 0; i < list.size(); ++i) {
            Object item = list.getObject(i);
            if (!(item instanceof YailList)) throw new InvalidRequestHeadersException(1110, i + 1);
            YailList sublist = (YailList)item;
            if (sublist.size() != 2) throw new InvalidRequestHeadersException(1111, i + 1);
            String fieldName = sublist.getObject(0).toString();
            Object fieldValues = sublist.getObject(1);
            String key = fieldName;
            ArrayList<String> values = Lists.newArrayList();
            if (fieldValues instanceof YailList) {
                YailList multipleFieldsValues = (YailList)fieldValues;
                for (int j = 0; j < multipleFieldsValues.size(); ++j) {
                    Object value = multipleFieldsValues.getObject(j);
                    values.add(value.toString());
                }
            } else {
                Object singleFieldValue = fieldValues;
                values.add(singleFieldValue.toString());
            }
            requestHeadersMap.put(key, values);
        }
        return requestHeadersMap;
    }

    private CapturedProperties capturePropertyValues(String functionName) {
        try {
            return new CapturedProperties(this);
        }
        catch (MalformedURLException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 1109, this.urlString);
        }
        catch (InvalidRequestHeadersException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, e.errorNumber, e.index);
        }
        return null;
    }

    static {
        mimeTypeToExtension.put("application/pdf", "pdf");
        mimeTypeToExtension.put("application/zip", "zip");
        mimeTypeToExtension.put("audio/mpeg", "mpeg");
        mimeTypeToExtension.put("audio/mp3", "mp3");
        mimeTypeToExtension.put("audio/mp4", "mp4");
        mimeTypeToExtension.put("image/gif", "gif");
        mimeTypeToExtension.put("image/jpeg", "jpg");
        mimeTypeToExtension.put("image/png", "png");
        mimeTypeToExtension.put("image/tiff", "tiff");
        mimeTypeToExtension.put("text/plain", "txt");
        mimeTypeToExtension.put("text/html", "html");
        mimeTypeToExtension.put("text/xml", "xml");
    }

    private static class CapturedProperties {
        final String urlString;
        final URL url;
        final boolean allowCookies;
        final boolean saveResponse;
        final String responseFileName;
        final Map<String, List<String>> requestHeaders;
        final Map<String, List<String>> cookies;

        CapturedProperties(Web web) throws MalformedURLException, InvalidRequestHeadersException {
            this.urlString = web.urlString;
            this.url = new URL(this.urlString);
            this.allowCookies = web.allowCookies;
            this.saveResponse = web.saveResponse;
            this.responseFileName = web.responseFileName;
            this.requestHeaders = Web.processRequestHeaders(web.requestHeaders);
            Map<String, List<String>> cookiesTemp = null;
            if (this.allowCookies && web.cookieHandler != null) {
                try {
                    cookiesTemp = web.cookieHandler.get(this.url.toURI(), this.requestHeaders);
                }
                catch (URISyntaxException uRISyntaxException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.cookies = cookiesTemp;
        }
    }

    static class BuildRequestDataException
    extends Exception {
        final int errorNumber;
        final int index;

        BuildRequestDataException(int errorNumber, int index) {
            this.errorNumber = errorNumber;
            this.index = index;
        }
    }

    private static class InvalidRequestHeadersException
    extends Exception {
        final int errorNumber;
        final int index;

        InvalidRequestHeadersException(int errorNumber, int index) {
            this.errorNumber = errorNumber;
            this.index = index;
        }
    }
}

