/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.app.Activity;
import android.os.Handler;
import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.collect.Lists;
import com.google.appinventor.components.runtime.util.AsyncCallbackPair;
import com.google.appinventor.components.runtime.util.AsynchUtil;
import com.google.appinventor.components.runtime.util.WebServiceUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DesignerComponent(version=1, designerHelpDescription="<p>The Voting component enables users to vote on a question by communicating with a Web service to retrieve a ballot and later sending back users' votes.</p>", category=ComponentCategory.INTERNAL, nonVisible=true, iconName="images/voting.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.INTERNET")
public class Voting
extends AndroidNonvisibleComponent
implements Component {
    private static final String LOG_TAG = "Voting";
    private static final String REQUESTBALLOT_COMMAND = "requestballot";
    private static final String SENDBALLOT_COMMAND = "sendballot";
    private static final String IS_POLLING_PARAMETER = "isPolling";
    private static final String ID_REQUESTED_PARAMETER = "idRequested";
    private static final String BALLOT_QUESTION_PARAMETER = "question";
    private static final String BALLOT_OPTIONS_PARAMETER = "options";
    private static final String USER_CHOICE_PARAMETER = "userchoice";
    private static final String USER_ID_PARAMETER = "userid";
    private Handler androidUIHandler;
    private ComponentContainer theContainer;
    private Activity activityContext;
    private String userId = "";
    private String serviceURL = "http://androvote.appspot.com";
    private String ballotQuestion = "";
    private String ballotOptionsString;
    private ArrayList<String> ballotOptions = new ArrayList();
    private Boolean idRequested = false;
    private String userChoice = "";
    private Boolean isPolling = false;

    public Voting(ComponentContainer container) {
        super(container.$form());
        this.androidUIHandler = new Handler();
        this.theContainer = container;
        this.activityContext = container.$context();
        this.serviceURL = "http://androvote.appspot.com";
    }

    @SimpleProperty(description="The URL of the Voting service", category=PropertyCategory.BEHAVIOR)
    public String ServiceURL() {
        return this.serviceURL;
    }

    @DesignerProperty(editorType="string", defaultValue="http://androvote.appspot.com")
    @SimpleProperty
    public void ServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
    }

    @SimpleProperty(description="The question to be voted on.", category=PropertyCategory.BEHAVIOR)
    public String BallotQuestion() {
        return this.ballotQuestion;
    }

    @SimpleProperty(description="The list of ballot options.", category=PropertyCategory.BEHAVIOR)
    public List<String> BallotOptions() {
        return this.ballotOptions;
    }

    @SimpleProperty(description="A text identifying the voter that is sent to the Voting server along with the vote.  This must be set before <code>SendBallot</code> is called.", category=PropertyCategory.BEHAVIOR)
    public String UserId() {
        return this.userId;
    }

    @SimpleProperty
    public void UserId(String userId) {
        this.userId = userId;
    }

    @SimpleProperty(description="The ballot choice to send to the server, which must be set before <code>SendBallot</code> is called.  This must be one of <code>BallotOptions</code>.", category=PropertyCategory.BEHAVIOR)
    public String UserChoice() {
        return this.userChoice;
    }

    @SimpleProperty
    public void UserChoice(String userChoice) {
        this.userChoice = userChoice;
    }

    @SimpleProperty(description="The email address associated with this device. This property has been deprecated and always returns the empty text value.", category=PropertyCategory.BEHAVIOR)
    public String UserEmailAddress() {
        return "";
    }

    @SimpleFunction(description="Send a request for a ballot to the Web service specified by the property <code>ServiceURL</code>.  When the completes, one of the following events will be raised: <code>GotBallot</code>, <code>NoOpenPoll</code>, or <code>WebServiceError</code>.")
    public void RequestBallot() {
        Runnable call = new Runnable(){

            public void run() {
                Voting.this.postRequestBallot();
            }
        };
        AsynchUtil.runAsynchronously(call);
    }

    private void postRequestBallot() {
        AsyncCallbackPair<JSONObject> myCallback = new AsyncCallbackPair<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                if (result == null) {
                    Voting.this.androidUIHandler.post(new Runnable(){

                        public void run() {
                            Voting.this.WebServiceError("The Web server did not respond to your request for a ballot");
                        }
                    });
                    return;
                }
                try {
                    Log.i((String)Voting.LOG_TAG, (String)("postRequestBallot: ballot retrieved " + result));
                    Voting.this.isPolling = result.getBoolean(Voting.IS_POLLING_PARAMETER);
                    if (Voting.this.isPolling.booleanValue()) {
                        Voting.this.idRequested = result.getBoolean(Voting.ID_REQUESTED_PARAMETER);
                        Voting.this.ballotQuestion = result.getString(Voting.BALLOT_QUESTION_PARAMETER);
                        Voting.this.ballotOptionsString = result.getString(Voting.BALLOT_OPTIONS_PARAMETER);
                        Voting.this.ballotOptions = Voting.this.JSONArrayToArrayList(new JSONArray(Voting.this.ballotOptionsString));
                        Voting.this.androidUIHandler.post(new Runnable(){

                            public void run() {
                                Voting.this.GotBallot();
                            }
                        });
                    } else {
                        Voting.this.androidUIHandler.post(new Runnable(){

                            public void run() {
                                Voting.this.NoOpenPoll();
                            }
                        });
                    }
                }
                catch (JSONException e) {
                    Voting.this.androidUIHandler.post(new Runnable(){

                        public void run() {
                            Voting.this.WebServiceError("The Web server returned a garbled object");
                        }
                    });
                    return;
                }
            }

            @Override
            public void onFailure(final String message) {
                Log.w((String)Voting.LOG_TAG, (String)("postRequestBallot Failure " + message));
                Voting.this.androidUIHandler.post(new Runnable(){

                    public void run() {
                        Voting.this.WebServiceError(message);
                    }
                });
            }
        };
        WebServiceUtil.getInstance().postCommandReturningObject(this.serviceURL, REQUESTBALLOT_COMMAND, null, myCallback);
    }

    private ArrayList<String> JSONArrayToArrayList(JSONArray ja) throws JSONException {
        ArrayList<String> a = new ArrayList<String>();
        for (int i = 0; i < ja.length(); ++i) {
            a.add(ja.getString(i));
        }
        return a;
    }

    @SimpleEvent(description="Event indicating that a ballot was retrieved from the Web service and that the properties <code>BallotQuestion</code> and <code>BallotOptions</code> have been set.  This is always preceded by a call to the method <code>RequestBallot</code>.")
    public void GotBallot() {
        EventDispatcher.dispatchEvent(this, "GotBallot", new Object[0]);
    }

    @SimpleEvent
    public void NoOpenPoll() {
        EventDispatcher.dispatchEvent(this, "NoOpenPoll", new Object[0]);
    }

    @SimpleFunction(description="Send a completed ballot to the Web service.  This should not be called until the properties <code>UserId</code> and <code>UserChoice</code> have been set by the application.")
    public void SendBallot() {
        Runnable call = new Runnable(){

            public void run() {
                Voting.this.postSendBallot(Voting.this.userChoice, Voting.this.userId);
            }
        };
        AsynchUtil.runAsynchronously(call);
    }

    private void postSendBallot(String userChoice, String userId) {
        AsyncCallbackPair<String> myCallback = new AsyncCallbackPair<String>(){

            @Override
            public void onSuccess(String response) {
                Voting.this.androidUIHandler.post(new Runnable(){

                    public void run() {
                        Voting.this.GotBallotConfirmation();
                    }
                });
            }

            @Override
            public void onFailure(final String message) {
                Log.w((String)Voting.LOG_TAG, (String)("postSendBallot Failure " + message));
                Voting.this.androidUIHandler.post(new Runnable(){

                    public void run() {
                        Voting.this.WebServiceError(message);
                    }
                });
            }
        };
        WebServiceUtil.getInstance().postCommand(this.serviceURL, SENDBALLOT_COMMAND, Lists.newArrayList(new BasicNameValuePair(USER_CHOICE_PARAMETER, userChoice), new BasicNameValuePair(USER_ID_PARAMETER, userId)), myCallback);
    }

    @SimpleEvent
    public void GotBallotConfirmation() {
        EventDispatcher.dispatchEvent(this, "GotBallotConfirmation", new Object[0]);
    }

    @SimpleEvent
    public void WebServiceError(String message) {
        EventDispatcher.dispatchEvent(this, "WebServiceError", message);
    }
}

