/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.content.Context;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.widget.MediaController;
import android.widget.VideoView;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidViewComponent;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.OnDestroyListener;
import com.google.appinventor.components.runtime.util.MediaUtil;
import com.google.appinventor.components.runtime.util.SdkLevel;
import java.io.IOException;

@DesignerComponent(version=5, description="A multimedia component capable of playing videos. When the application is run, the VideoPlayer will be displayed as a rectangle on-screen.  If the user touches the rectangle, controls will appear to play/pause, skip ahead, and skip backward within the video.  The application can also control behavior by calling the <code>Start</code>, <code>Pause</code>, and <code>SeekTo</code> methods.  <p>Video files should be in 3GPP (.3gp) or MPEG-4 (.mp4) formats.  For more details about legal formats, see <a href=\"http://developer.android.com/guide/appendix/media-formats.html\" target=\"_blank\">Android Supported Media Formats</a>.</p><p>App Inventor for Android only permits video files under 1 MB and limits the total size of an application to 5 MB, not all of which is available for media (video, audio, and sound) files.  If your media files are too large, you may get errors when packaging or installing your application, in which case you should reduce the number of media files or their sizes.  Most video editing software, such as Windows Movie Maker and Apple iMovie, can help you decrease the size of videos by shortening them or re-encoding the video into a more compact format.</p><p>You can also set the media source to a URL that points to a streaming video, but the URL must point to the video file itself, not to a program that plays the video.", category=ComponentCategory.MEDIA)
@SimpleObject
@UsesPermissions(permissionNames="android.permission.INTERNET")
public final class VideoPlayer
extends AndroidViewComponent
implements OnDestroyListener,
Deleteable,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnPreparedListener {
    private final ResizableVideoView videoView;
    private String sourcePath;
    private boolean inFullScreen = false;
    private boolean mediaReady = false;
    private boolean delayedStart = false;
    private MediaPlayer mPlayer;
    private final Handler androidUIHandler = new Handler();

    public VideoPlayer(ComponentContainer container) {
        super(container);
        container.$form().registerForOnDestroy(this);
        this.videoView = new ResizableVideoView((Context)container.$context());
        this.videoView.setMediaController(new MediaController((Context)container.$context()));
        this.videoView.setOnCompletionListener(this);
        this.videoView.setOnErrorListener(this);
        this.videoView.setOnPreparedListener(this);
        container.$add(this);
        container.setChildWidth(this, 176);
        container.setChildHeight(this, 144);
        container.$form().setVolumeControlStream(3);
        this.sourcePath = "";
    }

    public View getView() {
        return this.videoView;
    }

    @DesignerProperty(editorType="asset", defaultValue="")
    @SimpleProperty(description="The \"path\" to the video.  Usually, this will be the name of the video file, which should be added in the Designer.", category=PropertyCategory.BEHAVIOR)
    public void Source(String path) {
        if (this.inFullScreen) {
            this.container.$form().fullScreenVideoAction(194, this, path);
        } else {
            this.sourcePath = path == null ? "" : path;
            this.videoView.invalidateMediaPlayer(true);
            if (this.videoView.isPlaying()) {
                this.videoView.stopPlayback();
            }
            this.videoView.setVideoURI(null);
            this.videoView.clearAnimation();
            if (this.sourcePath.length() > 0) {
                Log.i((String)"VideoPlayer", (String)("Source path is " + this.sourcePath));
                try {
                    this.mediaReady = false;
                    MediaUtil.loadVideoView(this.videoView, this.container.$form(), this.sourcePath);
                }
                catch (IOException e) {
                    this.container.$form().dispatchErrorOccurredEvent(this, "Source", 701, this.sourcePath);
                    return;
                }
                Log.i((String)"VideoPlayer", (String)"loading video succeeded");
            }
        }
    }

    @SimpleFunction(description="Starts playback of the video.")
    public void Start() {
        Log.i((String)"VideoPlayer", (String)"Calling Start");
        if (this.inFullScreen) {
            this.container.$form().fullScreenVideoAction(191, this, null);
        } else if (this.mediaReady) {
            this.videoView.start();
        } else {
            this.delayedStart = true;
        }
    }

    @DesignerProperty(editorType="non_negative_float", defaultValue="50")
    @SimpleProperty(description="Sets the volume to a number between 0 and 100. Values less than 0 will be treated as 0, and values greater than 100 will be treated as 100.")
    public void Volume(int vol) {
        vol = Math.max(vol, 0);
        vol = Math.min(vol, 100);
        if (this.mPlayer != null) {
            this.mPlayer.setVolume((float)vol / 100.0f, (float)vol / 100.0f);
        }
    }

    public void delayedStart() {
        this.delayedStart = true;
        this.Start();
    }

    @SimpleFunction(description="Pauses playback of the video.  Playback can be resumed at the same location by calling the <code>Start</code> method.")
    public void Pause() {
        Log.i((String)"VideoPlayer", (String)"Calling Pause");
        if (this.inFullScreen) {
            this.container.$form().fullScreenVideoAction(192, this, null);
            this.delayedStart = false;
        } else {
            this.delayedStart = false;
            this.videoView.pause();
        }
    }

    @SimpleFunction(description="Seeks to the requested time (specified in milliseconds) in the video. If the video is paused, the frame shown will not be updated by the seek. The player can jump only to key frames in the video, so seeking to times that differ by short intervals may not actually move to different frames.")
    public void SeekTo(int ms) {
        Log.i((String)"VideoPlayer", (String)"Calling SeekTo");
        if (ms < 0) {
            ms = 0;
        }
        if (this.inFullScreen) {
            this.container.$form().fullScreenVideoAction(190, this, ms);
        } else {
            this.videoView.seekTo(ms);
        }
    }

    @SimpleFunction(description="Returns duration of the video in milliseconds.")
    public int GetDuration() {
        Log.i((String)"VideoPlayer", (String)"Calling GetDuration");
        if (this.inFullScreen) {
            Bundle result = this.container.$form().fullScreenVideoAction(196, this, null);
            if (result.getBoolean("ActionSuccess")) {
                return result.getInt("ActionData");
            }
            return 0;
        }
        return this.videoView.getDuration();
    }

    public void onCompletion(MediaPlayer m) {
        this.Completed();
    }

    @SimpleEvent
    public void Completed() {
        EventDispatcher.dispatchEvent(this, "Completed", new Object[0]);
    }

    public boolean onError(MediaPlayer m, int what, int extra) {
        this.videoView.invalidateMediaPlayer(true);
        this.delayedStart = false;
        this.mediaReady = false;
        Log.e((String)"VideoPlayer", (String)("onError: what is " + what + " 0x" + Integer.toHexString(what) + ", extra is " + extra + " 0x" + Integer.toHexString(extra)));
        this.container.$form().dispatchErrorOccurredEvent(this, "Source", 701, this.sourcePath);
        return true;
    }

    public void onPrepared(MediaPlayer newMediaPlayer) {
        this.mediaReady = true;
        this.delayedStart = false;
        this.mPlayer = newMediaPlayer;
        this.videoView.setMediaPlayer(this.mPlayer, true);
        if (this.delayedStart) {
            this.Start();
        }
    }

    @SimpleEvent(description="The VideoPlayerError event is no longer used. Please use the Screen.ErrorOccurred event instead.", userVisible=false)
    public void VideoPlayerError(String message) {
    }

    public void onDestroy() {
        this.prepareToDie();
    }

    public void onDelete() {
        this.prepareToDie();
    }

    private void prepareToDie() {
        if (this.videoView.isPlaying()) {
            this.videoView.stopPlayback();
        }
        this.videoView.setVideoURI(null);
        this.videoView.clearAnimation();
        this.delayedStart = false;
        this.mediaReady = false;
        if (this.inFullScreen) {
            Bundle data = new Bundle();
            data.putBoolean("FullScreenKey", false);
            this.container.$form().fullScreenVideoAction(195, this, data);
        }
    }

    @SimpleProperty
    public int Width() {
        return super.Width();
    }

    @SimpleProperty(userVisible=true)
    public void Width(int width) {
        super.Width(width);
        this.videoView.changeVideoSize(width, this.videoView.forcedHeight);
    }

    @SimpleProperty
    public int Height() {
        return super.Height();
    }

    @SimpleProperty(userVisible=true)
    public void Height(int height) {
        super.Height(height);
        this.videoView.changeVideoSize(this.videoView.forcedWidth, height);
    }

    @SimpleProperty
    public boolean FullScreen() {
        return this.inFullScreen;
    }

    @SimpleProperty(userVisible=true)
    public void FullScreen(boolean value) {
        if (value && SdkLevel.getLevel() <= 4) {
            this.container.$form().dispatchErrorOccurredEvent(this, "FullScreen(true)", 1303, new Object[0]);
            return;
        }
        if (value != this.inFullScreen) {
            if (value) {
                Bundle data = new Bundle();
                data.putInt("PositionKey", this.videoView.getCurrentPosition());
                data.putBoolean("PlayingKey", this.videoView.isPlaying());
                this.videoView.pause();
                data.putBoolean("FullScreenKey", true);
                data.putString("SourceKey", this.sourcePath);
                Bundle result = this.container.$form().fullScreenVideoAction(195, this, data);
                if (result.getBoolean("ActionSuccess")) {
                    this.inFullScreen = true;
                } else {
                    this.inFullScreen = false;
                    this.container.$form().dispatchErrorOccurredEvent(this, "FullScreen", 1301, "");
                }
            } else {
                Bundle values = new Bundle();
                values.putBoolean("FullScreenKey", false);
                Bundle result = this.container.$form().fullScreenVideoAction(195, this, values);
                if (result.getBoolean("ActionSuccess")) {
                    this.fullScreenKilled(result);
                } else {
                    this.inFullScreen = true;
                    this.container.$form().dispatchErrorOccurredEvent(this, "FullScreen", 1302, "");
                }
            }
        }
    }

    public void fullScreenKilled(Bundle data) {
        this.inFullScreen = false;
        String newSource = data.getString("SourceKey");
        if (!newSource.equals(this.sourcePath)) {
            this.Source(newSource);
        }
        this.videoView.setVisibility(0);
        this.videoView.requestLayout();
        this.SeekTo(data.getInt("PositionKey"));
        if (data.getBoolean("PlayingKey")) {
            this.Start();
        }
    }

    public int getPassedWidth() {
        return this.videoView.forcedWidth;
    }

    public int getPassedHeight() {
        return this.videoView.forcedHeight;
    }

    class ResizableVideoView
    extends VideoView {
        private MediaPlayer mVideoPlayer;
        private Boolean mFoundMediaPlayer;
        public int forcedWidth;
        public int forcedHeight;

        public ResizableVideoView(Context context) {
            super(context);
            this.mFoundMediaPlayer = false;
            this.forcedWidth = -1;
            this.forcedHeight = -1;
        }

        public void onMeasure(int specwidth, int specheight) {
            this.onMeasure(specwidth, specheight, 0);
        }

        private void onMeasure(final int specwidth, final int specheight, final int trycount) {
            boolean scaleHeight = false;
            boolean scaleWidth = false;
            float deviceDensity = VideoPlayer.this.container.$form().deviceDensity();
            Log.i((String)"VideoPlayer..onMeasure", (String)("Device Density = " + deviceDensity));
            Log.i((String)"VideoPlayer..onMeasure", (String)("AI setting dimensions as:" + this.forcedWidth + ":" + this.forcedHeight));
            Log.i((String)"VideoPlayer..onMeasure", (String)("Dimenions from super>>" + View.MeasureSpec.getSize((int)specwidth) + ":" + View.MeasureSpec.getSize((int)specheight)));
            int width = 176;
            int height = 144;
            switch (this.forcedWidth) {
                case -2: {
                    switch (View.MeasureSpec.getMode((int)specwidth)) {
                        case -2147483648: 
                        case 0x40000000: {
                            width = View.MeasureSpec.getSize((int)specwidth);
                            break;
                        }
                        case 0: {
                            try {
                                width = ((View)this.getParent()).getMeasuredWidth();
                                break;
                            }
                            catch (ClassCastException cast) {
                                width = 176;
                                break;
                            }
                            catch (NullPointerException nullParent) {
                                width = 176;
                            }
                        }
                    }
                    break;
                }
                case -1: {
                    if (!this.mFoundMediaPlayer.booleanValue()) break;
                    try {
                        width = this.mVideoPlayer.getVideoWidth();
                        Log.i((String)"VideoPlayer.onMeasure", (String)("Got width from MediaPlayer>" + width));
                    }
                    catch (NullPointerException nullVideoPlayer) {
                        Log.e((String)"VideoPlayer..onMeasure", (String)("Failed to get MediaPlayer for width:\n" + nullVideoPlayer.getMessage()));
                        width = 176;
                    }
                    break;
                }
                default: {
                    scaleWidth = true;
                    width = this.forcedWidth;
                }
            }
            if (this.forcedWidth <= -1000) {
                int cWidth = VideoPlayer.this.container.$form().Width();
                if (cWidth == 0 && trycount < 2) {
                    Log.d((String)"VideoPlayer...onMeasure", (String)("Width not stable... trying again (onMeasure " + trycount + ")"));
                    VideoPlayer.this.androidUIHandler.postDelayed(new Runnable(){

                        public void run() {
                            ResizableVideoView.this.onMeasure(specwidth, specheight, trycount + 1);
                        }
                    }, 100L);
                    this.setMeasuredDimension(100, 100);
                    return;
                }
                width = (int)((float)(cWidth * -(width - -1000) / 100) * deviceDensity);
            } else if (scaleWidth) {
                width = (int)((float)width * deviceDensity);
            }
            block11 : switch (this.forcedHeight) {
                case -2: {
                    switch (View.MeasureSpec.getMode((int)specheight)) {
                        case -2147483648: 
                        case 0x40000000: {
                            height = View.MeasureSpec.getSize((int)specheight);
                            break block11;
                        }
                    }
                    break;
                }
                case -1: {
                    if (!this.mFoundMediaPlayer.booleanValue()) break;
                    try {
                        height = this.mVideoPlayer.getVideoHeight();
                        Log.i((String)"VideoPlayer.onMeasure", (String)("Got height from MediaPlayer>" + height));
                    }
                    catch (NullPointerException nullVideoPlayer) {
                        Log.e((String)"VideoPlayer..onMeasure", (String)("Failed to get MediaPlayer for height:\n" + nullVideoPlayer.getMessage()));
                        height = 144;
                    }
                    break;
                }
                default: {
                    scaleHeight = true;
                    height = this.forcedHeight;
                }
            }
            if (this.forcedHeight <= -1000) {
                int cHeight = VideoPlayer.this.container.$form().Height();
                if (cHeight == 0 && trycount < 2) {
                    Log.d((String)"VideoPlayer...onMeasure", (String)("Height not stable... trying again (onMeasure " + trycount + ")"));
                    VideoPlayer.this.androidUIHandler.postDelayed(new Runnable(){

                        public void run() {
                            ResizableVideoView.this.onMeasure(specwidth, specheight, trycount + 1);
                        }
                    }, 100L);
                    this.setMeasuredDimension(100, 100);
                    return;
                }
                height = (int)((float)(cHeight * -(height - -1000) / 100) * deviceDensity);
            } else if (scaleHeight) {
                height = (int)((float)height * deviceDensity);
            }
            Log.i((String)"VideoPlayer.onMeasure", (String)("Setting dimensions to:" + width + "x" + height));
            this.getHolder().setFixedSize(width, height);
            this.setMeasuredDimension(width, height);
        }

        public void changeVideoSize(int newWidth, int newHeight) {
            this.forcedWidth = newWidth;
            this.forcedHeight = newHeight;
            this.forceLayout();
            this.invalidate();
        }

        public void invalidateMediaPlayer(boolean triggerRedraw) {
            this.mFoundMediaPlayer = false;
            this.mVideoPlayer = null;
            if (triggerRedraw) {
                this.forceLayout();
                this.invalidate();
            }
        }

        public void setMediaPlayer(MediaPlayer newMediaPlayer, boolean triggerRedraw) {
            this.mVideoPlayer = newMediaPlayer;
            this.mFoundMediaPlayer = true;
            if (triggerRedraw) {
                this.forceLayout();
                this.invalidate();
            }
        }
    }
}

