/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.app.Activity;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.AsyncTask;
import android.telephony.SmsManager;
import android.telephony.SmsMessage;
import android.util.Log;
import android.widget.Toast;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleBroadcastReceiver;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesLibraries;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.OnPauseListener;
import com.google.appinventor.components.runtime.OnResumeListener;
import com.google.appinventor.components.runtime.OnStopListener;
import com.google.appinventor.components.runtime.util.OAuth2Helper;
import com.google.appinventor.components.runtime.util.OnInitializeListener;
import com.google.appinventor.components.runtime.util.SdkLevel;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.json.JSONException;
import org.json.JSONObject;

@DesignerComponent(version=3, description="<p>A component that will, when the <code>SendMessage</code> method is called, send the text message specified in the <code>Message</code> property to the phone number specified in the <code>PhoneNumber</code> property.</p> <p>If the <code>ReceivingEnabled</code> property is set to 1 messages will <b>not</b> be received. If <code>ReceivingEnabled</code> is set to 2 messages will be received only when the application is running. Finally if <code>ReceivingEnabled</code> is set to 3, messages will be received when the application is running <b>and</b> when the application is not running they will be queued and a notification displayed to the user.</p> <p>When a message arrives, the <code>MessageReceived</code> event is raised and provides the sending number and message.</p> <p> An app that includes this component will receive messages even when it is in the background (i.e. when it's not visible on the screen) and, moreso, even if the app is not running, so long as it's installed on the phone. If the phone receives a text message when the app is not in the foreground, the phone will show a notification in the notification bar.  Selecting the notification will bring up the app.  As an app developer, you'll probably want to give your users the ability to control ReceivingEnabled so that they can make the phone ignore text messages.</p> <p>If the GoogleVoiceEnabled property is true, messages can be sent over Wifi using Google Voice. This option requires that the user have a Google Voice account and that the mobile Voice app is installed on the phone. The Google Voice option works only on phones that support Android 2.0 (Eclair) or higher.</p> <p>To specify the phone number (e.g., 650-555-1212), set the <code>PhoneNumber</code> property to a Text string with the specified digits (e.g., 6505551212).  Dashes, dots, and parentheses may be included (e.g., (650)-555-1212) but will be ignored; spaces may not be included.</p> <p>Another way for an app to specify a phone number would be to include a <code>PhoneNumberPicker</code> component, which lets the users select a phone numbers from the ones stored in the the phone's contacts.</p>", category=ComponentCategory.SOCIAL, nonVisible=true, iconName="images/texting.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.RECEIVE_SMS, android.permission.SEND_SMS, com.google.android.apps.googlevoice.permission.RECEIVE_SMS, com.google.android.apps.googlevoice.permission.SEND_SMS, android.permission.ACCOUNT_MANAGER, android.permission.MANAGE_ACCOUNTS, android.permission.GET_ACCOUNTS, android.permission.USE_CREDENTIALS")
@UsesLibraries(libraries="google-api-client-beta.jar,google-api-client-android2-beta.jar,google-http-client-beta.jar,google-http-client-android2-beta.jar,google-http-client-android3-beta.jar,google-oauth-client-beta.jar,guava-14.0.1.jar")
@SimpleBroadcastReceiver(className="com.google.appinventor.components.runtime.util.SmsBroadcastReceiver", actions="android.provider.Telephony.SMS_RECEIVED, com.google.android.apps.googlevoice.SMS_RECEIVED")
public class Texting
extends AndroidNonvisibleComponent
implements Component,
OnResumeListener,
OnPauseListener,
OnInitializeListener,
OnStopListener {
    public static final String TAG = "Texting Component";
    public static final String SMS_RECEIVED = "android.provider.Telephony.SMS_RECEIVED";
    public static final String GV_SMS_RECEIVED = "com.google.android.apps.googlevoice.SMS_RECEIVED";
    public static final String PHONE_NUMBER_TAG = "com.google.android.apps.googlevoice.PHONE_NUMBER";
    public static final String MESSAGE_TAG = "com.google.android.apps.googlevoice.TEXT";
    public static final String TELEPHONY_INTENT_FILTER = "android.provider.Telephony.SMS_RECEIVED";
    public static final String GV_INTENT_FILTER = "com.google.android.apps.googlevoice.SMS_RECEIVED";
    public static final String GV_PACKAGE_NAME = "com.google.android.apps.googlevoice";
    public static final String GV_SMS_SEND_URL = "https://www.google.com/voice/b/0/sms/send/";
    public static final String GV_URL = "https://www.google.com/voice/b/0";
    public static final String META_DATA_SMS_KEY = "sms_handler_component";
    public static final String META_DATA_SMS_VALUE = "Texting";
    private static final String GV_SERVICE = "grandcentral";
    private static final String USER_AGENT = "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US) AppleWebKit/525.13 (KHTML, like Gecko) Chrome/0.A.B.C Safari/525.13";
    private static final int SERVER_TIMEOUT_MS = 30000;
    private static final String SENT = "SMS_SENT";
    private static final String UTF8 = "UTF-8";
    private static final String MESSAGE_DELIMITER = "\u0001";
    private static final String PREF_GVENABLED = "gvenabled";
    private static final String PREF_RCVENABLED_LEGACY = "receiving";
    private static final String PREF_RCVENABLED = "receiving2";
    private static final String PREF_FILE = "TextingState";
    private GoogleVoiceUtil gvHelper;
    private static Activity activity;
    private static Component component;
    private String authToken;
    private static int receivingEnabled;
    private SmsManager smsManager;
    private String phoneNumber;
    private String message;
    private boolean googleVoiceEnabled;
    private boolean isInitialized;
    private static boolean isRunning;
    private static final String CACHE_FILE = "textingmsgcache";
    private static int messagesCached;
    private static Object cacheLock;
    private Queue<String> pendingQueue = new ConcurrentLinkedQueue<String>();
    private ComponentContainer container;

    public Texting(ComponentContainer container) {
        super(container.$form());
        Log.d((String)TAG, (String)"Texting constructor");
        this.container = container;
        component = this;
        activity = container.$context();
        SharedPreferences prefs = activity.getSharedPreferences(PREF_FILE, 0);
        if (prefs != null) {
            receivingEnabled = prefs.getInt(PREF_RCVENABLED, -1);
            if (receivingEnabled == -1) {
                receivingEnabled = prefs.getBoolean(PREF_RCVENABLED_LEGACY, true) ? 2 : 1;
            }
            this.googleVoiceEnabled = prefs.getBoolean(PREF_GVENABLED, false);
            Log.i((String)TAG, (String)("Starting with receiving Enabled=" + receivingEnabled + " GV enabled=" + this.googleVoiceEnabled));
        } else {
            receivingEnabled = 2;
            this.googleVoiceEnabled = false;
        }
        if (this.googleVoiceEnabled) {
            new AsyncAuthenticate().execute(new Void[0]);
        }
        this.smsManager = SmsManager.getDefault();
        this.PhoneNumber("");
        this.isInitialized = false;
        isRunning = false;
        container.$form().registerForOnInitialize(this);
        container.$form().registerForOnResume(this);
        container.$form().registerForOnPause(this);
        container.$form().registerForOnStop(this);
    }

    public void onInitialize() {
        Log.i((String)TAG, (String)"onInitialize()");
        this.isInitialized = true;
        isRunning = true;
        this.processCachedMessages();
        NotificationManager nm = (NotificationManager)activity.getSystemService("notification");
        nm.cancel(8647);
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public void PhoneNumber(String phoneNumber) {
        Log.i((String)TAG, (String)("PhoneNumber set: " + phoneNumber));
        this.phoneNumber = phoneNumber;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="The number that the message will be sent to when the SendMessage method is called. The number is a text string with the specified digits (e.g., 6505551212).  Dashes, dots, and parentheses may be included (e.g., (650)-555-1212) but will be ignored; spaces should not be included.")
    public String PhoneNumber() {
        return this.phoneNumber;
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="The message that will be sent when the SendMessage method is called.")
    public void Message(String message) {
        Log.i((String)TAG, (String)("Message set: " + message));
        this.message = message;
    }

    @SimpleProperty
    public String Message() {
        return this.message;
    }

    @SimpleFunction
    public void SendMessage() {
        Log.i((String)TAG, (String)("Sending message " + this.message + " to " + this.phoneNumber));
        String phoneNumber = this.phoneNumber;
        String message = this.message;
        if (this.googleVoiceEnabled) {
            if (this.authToken == null) {
                Log.i((String)TAG, (String)("Need to get an authToken -- enqueing " + phoneNumber + " " + message));
                boolean ok = this.pendingQueue.offer(phoneNumber + ":::" + message);
                if (!ok) {
                    Toast.makeText((Context)activity, (CharSequence)"Pending message queue full. Can't send message", (int)0).show();
                    return;
                }
                if (this.pendingQueue.size() == 1) {
                    new AsyncAuthenticate().execute(new Void[0]);
                }
            } else {
                Log.i((String)TAG, (String)"Creating AsyncSendMessage");
                new AsyncSendMessage().execute(new String[]{phoneNumber, message});
            }
        } else {
            Log.i((String)TAG, (String)"Sending via SMS");
            this.sendViaSms();
        }
    }

    private void processPendingQueue() {
        while (this.pendingQueue.size() != 0) {
            String entry = this.pendingQueue.remove();
            String phoneNumber = entry.substring(0, entry.indexOf(":::"));
            String message = entry.substring(entry.indexOf(":::") + 3);
            Log.i((String)TAG, (String)("Sending queued message " + phoneNumber + " " + message));
            new AsyncSendMessage().execute(new String[]{phoneNumber, message});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SimpleEvent
    public static void MessageReceived(String number, String messageText) {
        if (receivingEnabled > 1) {
            Log.i((String)TAG, (String)("MessageReceived from " + number + ":" + messageText));
            if (EventDispatcher.dispatchEvent(component, "MessageReceived", number, messageText)) {
                Log.i((String)TAG, (String)"Dispatch successful");
            } else {
                Log.i((String)TAG, (String)"Dispatch failed, caching");
                Object object = cacheLock;
                synchronized (object) {
                    Texting.addMessageToCache((Context)activity, number, messageText);
                }
            }
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="If true, then SendMessage will attempt to send messages over Wifi using Google Voice.  This requires that the Google Voice app must be installed and set up on the phone or tablet, with a Google Voice account.  If GoogleVoiceEnabled is false, the device must have phone and texting service in order to send or receive messages with this component.")
    public boolean GoogleVoiceEnabled() {
        return this.googleVoiceEnabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void GoogleVoiceEnabled(boolean enabled) {
        if (SdkLevel.getLevel() >= 5) {
            this.googleVoiceEnabled = enabled;
            SharedPreferences prefs = activity.getSharedPreferences(PREF_FILE, 0);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putBoolean(PREF_GVENABLED, enabled);
            editor.commit();
        } else {
            Toast.makeText((Context)activity, (CharSequence)"Sorry, your phone's system does not support this option.", (int)1).show();
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="If set to 1 (OFF) no messages will be received.  If set to 2 (FOREGROUND) or3 (ALWAYS) the component will respond to messages if it is running. If the app is not running then the message will be discarded if set to 2 (FOREGROUND). If set to 3 (ALWAYS) and the app is not running the phone will show a notification.  Selecting the notification will bring up the app and signal the MessageReceived event.  Messages received when the app is dormant will be queued, and so several MessageReceived events might appear when the app awakens.  As an app developer, it would be a good idea to give your users control over this property, so they can make their phones ignore text messages when your app is installed.")
    public int ReceivingEnabled() {
        return receivingEnabled;
    }

    @DesignerProperty(editorType="text_receiving", defaultValue="2")
    @SimpleProperty
    public void ReceivingEnabled(int enabled) {
        if (enabled < 1 || enabled > 3) {
            this.container.$form().dispatchErrorOccurredEvent(this, META_DATA_SMS_VALUE, 1701, enabled);
            return;
        }
        receivingEnabled = enabled;
        SharedPreferences prefs = activity.getSharedPreferences(PREF_FILE, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putInt(PREF_RCVENABLED, enabled);
        editor.remove(PREF_RCVENABLED_LEGACY);
        editor.commit();
    }

    public static int isReceivingEnabled(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(PREF_FILE, 0);
        int retval = prefs.getInt(PREF_RCVENABLED, -1);
        if (retval == -1) {
            if (prefs.getBoolean(PREF_RCVENABLED_LEGACY, true)) {
                return 2;
            }
            return 1;
        }
        return retval;
    }

    public static SmsMessage[] getMessagesFromIntent(Intent intent) {
        Object[] messages = (Object[])intent.getSerializableExtra("pdus");
        byte[][] pduObjs = new byte[messages.length][];
        for (int i = 0; i < messages.length; ++i) {
            pduObjs[i] = (byte[])messages[i];
        }
        byte[][] pdus = new byte[pduObjs.length][];
        int pduCount = pdus.length;
        SmsMessage[] msgs = new SmsMessage[pduCount];
        for (int i = 0; i < pduCount; ++i) {
            pdus[i] = pduObjs[i];
            msgs[i] = SmsMessage.createFromPdu((byte[])pdus[i]);
        }
        return msgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCachedMessages() {
        String[] messagelist = null;
        Object object = cacheLock;
        synchronized (object) {
            messagelist = this.retrieveCachedMessages();
        }
        if (messagelist == null) {
            return;
        }
        Log.i((String)TAG, (String)("processing " + messagelist.length + " cached messages "));
        for (int k = 0; k < messagelist.length; ++k) {
            String phoneAndMessage = messagelist[k];
            Log.i((String)TAG, (String)("Message + " + k + " " + phoneAndMessage));
            int delim = phoneAndMessage.indexOf(":");
            if (receivingEnabled <= 1 || delim == -1) continue;
            Texting.MessageReceived(phoneAndMessage.substring(0, delim), phoneAndMessage.substring(delim + 1));
        }
    }

    private String[] retrieveCachedMessages() {
        Log.i((String)TAG, (String)"Retrieving cached messages");
        String cache = "";
        try {
            FileInputStream fis = activity.openFileInput(CACHE_FILE);
            byte[] bytes = new byte[8192];
            if (fis == null) {
                Log.e((String)TAG, (String)"Null file stream returned from openFileInput");
                return null;
            }
            int n = fis.read(bytes);
            Log.i((String)TAG, (String)("Read " + n + " bytes from " + CACHE_FILE));
            cache = new String(bytes, 0, n);
            fis.close();
            activity.deleteFile(CACHE_FILE);
            messagesCached = 0;
            Log.i((String)TAG, (String)("Retrieved cache " + cache));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)"No Cache file found -- this is not (usually) an error");
            return null;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"I/O Error reading from cache file");
            e.printStackTrace();
            return null;
        }
        String[] messagelist = cache.split(MESSAGE_DELIMITER);
        return messagelist;
    }

    public static boolean isRunning() {
        return isRunning;
    }

    public static int getCachedMsgCount() {
        return messagesCached;
    }

    public void onResume() {
        Log.i((String)TAG, (String)"onResume()");
        isRunning = true;
        if (this.isInitialized) {
            this.processCachedMessages();
            NotificationManager nm = (NotificationManager)activity.getSystemService("notification");
            nm.cancel(8647);
        }
    }

    public void onPause() {
        Log.i((String)TAG, (String)"onPause()");
        isRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handledReceivedMessage(Context context, String phone, String msg) {
        if (isRunning) {
            Texting.MessageReceived(phone, msg);
        } else {
            Object object = cacheLock;
            synchronized (object) {
                Texting.addMessageToCache(context, phone, msg);
            }
        }
    }

    private static void addMessageToCache(Context context, String phone, String msg) {
        try {
            String cachedMsg = phone + ":" + msg + MESSAGE_DELIMITER;
            Log.i((String)TAG, (String)("Caching " + cachedMsg));
            FileOutputStream fos = context.openFileOutput(CACHE_FILE, 32768);
            fos.write(cachedMsg.getBytes());
            fos.close();
            ++messagesCached;
            Log.i((String)TAG, (String)("Cached " + cachedMsg));
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)"File not found error writing to cache file");
            e.printStackTrace();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"I/O Error writing to cache file");
            e.printStackTrace();
        }
    }

    private synchronized void handleSentMessage(Context context, BroadcastReceiver receiver, int resultCode, String smsMsg) {
        switch (resultCode) {
            case -1: {
                Log.i((String)TAG, (String)("Received OK, msg:" + smsMsg));
                Toast.makeText((Context)activity, (CharSequence)"Message sent", (int)0).show();
                break;
            }
            case 1: {
                Log.e((String)TAG, (String)("Received generic failure, msg:" + smsMsg));
                Toast.makeText((Context)activity, (CharSequence)"Generic failure: message not sent", (int)0).show();
                break;
            }
            case 4: {
                Log.e((String)TAG, (String)("Received no service error, msg:" + smsMsg));
                Toast.makeText((Context)activity, (CharSequence)"No Sms service available. Message not sent.", (int)0).show();
                break;
            }
            case 3: {
                Log.e((String)TAG, (String)("Received null PDU error, msg:" + smsMsg));
                Toast.makeText((Context)activity, (CharSequence)"Received null PDU error. Message not sent.", (int)0).show();
                break;
            }
            case 2: {
                Log.e((String)TAG, (String)("Received radio off error, msg:" + smsMsg));
                Toast.makeText((Context)activity, (CharSequence)"Could not send SMS message: radio off.", (int)1).show();
            }
        }
    }

    private void sendViaSms() {
        Log.i((String)TAG, (String)"Sending via built-in Sms");
        ArrayList parts = this.smsManager.divideMessage(this.message);
        int numParts = parts.size();
        ArrayList<PendingIntent> pendingIntents = new ArrayList<PendingIntent>();
        for (int i = 0; i < numParts; ++i) {
            pendingIntents.add(PendingIntent.getBroadcast((Context)activity, (int)0, (Intent)new Intent(SENT), (int)0));
        }
        BroadcastReceiver sendReceiver = new BroadcastReceiver(){

            public synchronized void onReceive(Context arg0, Intent arg1) {
                try {
                    Texting.this.handleSentMessage(arg0, null, this.getResultCode(), Texting.this.message);
                    activity.unregisterReceiver((BroadcastReceiver)this);
                }
                catch (Exception e) {
                    Log.e((String)"BroadcastReceiver", (String)("Error in onReceive for msgId " + arg1.getAction()));
                    Log.e((String)"BroadcastReceiver", (String)e.getMessage());
                    e.printStackTrace();
                }
            }
        };
        activity.registerReceiver(sendReceiver, new IntentFilter(SENT));
        this.smsManager.sendMultipartTextMessage(this.phoneNumber, null, parts, pendingIntents, null);
    }

    public void onStop() {
        SharedPreferences prefs = activity.getSharedPreferences(PREF_FILE, 0);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putInt(PREF_RCVENABLED, receivingEnabled);
        editor.putBoolean(PREF_GVENABLED, this.googleVoiceEnabled);
        editor.commit();
    }

    static {
        receivingEnabled = 2;
        cacheLock = new Object();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AsyncSendMessage
    extends AsyncTask<String, Void, String> {
        AsyncSendMessage() {
        }

        protected String doInBackground(String ... args) {
            String phoneNumber = args[0];
            String message = args[1];
            String response = "";
            String smsData = "";
            Log.i((String)Texting.TAG, (String)("Async sending phoneNumber = " + phoneNumber + " message = " + message));
            try {
                smsData = URLEncoder.encode("phoneNumber", Texting.UTF8) + "=" + URLEncoder.encode(phoneNumber, Texting.UTF8) + "&" + URLEncoder.encode("text", Texting.UTF8) + "=" + URLEncoder.encode(message, Texting.UTF8);
                if (Texting.this.gvHelper == null) {
                    Texting.this.gvHelper = new GoogleVoiceUtil(Texting.this.authToken);
                }
                if (!Texting.this.gvHelper.isInitialized()) {
                    return "IO Error: unable to create GvHelper";
                }
                response = Texting.this.gvHelper.sendGvSms(smsData);
                Log.i((String)Texting.TAG, (String)("Sent SMS, response = " + response));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return response;
        }

        protected void onPostExecute(String result) {
            super.onPostExecute((Object)result);
            boolean ok = false;
            int code = 0;
            try {
                JSONObject json = new JSONObject(result);
                ok = json.getBoolean("ok");
                code = json.getJSONObject("data").getInt("code");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (ok) {
                Toast.makeText((Context)activity, (CharSequence)"Message sent", (int)0).show();
            } else if (code == 58) {
                Toast.makeText((Context)activity, (CharSequence)"Errcode 58: SMS limit reached", (int)0).show();
            } else if (result.contains("IO Error")) {
                Toast.makeText((Context)activity, (CharSequence)result, (int)0).show();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AsyncAuthenticate
    extends AsyncTask<Void, Void, String> {
        AsyncAuthenticate() {
        }

        protected String doInBackground(Void ... arg0) {
            Log.i((String)Texting.TAG, (String)"Authenticating");
            return new OAuth2Helper().getRefreshedAuthToken(activity, Texting.GV_SERVICE);
        }

        protected void onPostExecute(String result) {
            Log.i((String)Texting.TAG, (String)("authToken = " + result));
            Texting.this.authToken = result;
            Toast.makeText((Context)activity, (CharSequence)"Finished authentication", (int)0).show();
            Texting.this.processPendingQueue();
        }
    }

    class GoogleVoiceUtil {
        private final int MAX_REDIRECTS = 5;
        String general;
        String rnrSEE;
        String authToken;
        int redirectCounter;
        private boolean isInitialized;

        public GoogleVoiceUtil(String authToken) {
            Log.i((String)Texting.TAG, (String)"Creating GV Util");
            this.authToken = authToken;
            try {
                this.general = this.getGeneral();
                Log.i((String)Texting.TAG, (String)("general = " + this.general));
                this.setRNRSEE();
                this.isInitialized = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public boolean isInitialized() {
            return this.isInitialized;
        }

        private String sendGvSms(String smsData) {
            Log.i((String)Texting.TAG, (String)"sendGvSms()");
            String response = "";
            try {
                String line;
                smsData = smsData + "&" + URLEncoder.encode("_rnr_se", Texting.UTF8) + "=" + URLEncoder.encode(this.rnrSEE, Texting.UTF8);
                Log.i((String)Texting.TAG, (String)("smsData = " + smsData));
                URL smsUrl = new URL(Texting.GV_SMS_SEND_URL);
                URLConnection smsConn = smsUrl.openConnection();
                smsConn.setRequestProperty("Authorization", "GoogleLogin auth=" + this.authToken);
                smsConn.setRequestProperty("User-agent", Texting.USER_AGENT);
                smsConn.setDoOutput(true);
                smsConn.setConnectTimeout(30000);
                Log.i((String)Texting.TAG, (String)("sms request = " + smsConn));
                OutputStreamWriter callwr = new OutputStreamWriter(smsConn.getOutputStream());
                callwr.write(smsData);
                callwr.flush();
                BufferedReader callrd = new BufferedReader(new InputStreamReader(smsConn.getInputStream()));
                while ((line = callrd.readLine()) != null) {
                    response = response + line + "\n\r";
                }
                Log.i((String)Texting.TAG, (String)("sendGvSms:  Sent SMS, response = " + response));
                callwr.close();
                callrd.close();
                if (response.equals("")) {
                    throw new IOException("No Response Data Received.");
                }
                return response;
            }
            catch (IOException e) {
                Log.i((String)Texting.TAG, (String)("IO Error on Send " + e.getMessage()));
                e.printStackTrace();
                return "IO Error Message not sent";
            }
        }

        public String getGeneral() throws IOException {
            Log.i((String)Texting.TAG, (String)"getGeneral()");
            return this.get(Texting.GV_URL);
        }

        private void setRNRSEE() throws IOException {
            Log.i((String)Texting.TAG, (String)"setRNRSEE()");
            if (this.general != null) {
                if (!this.general.contains("'_rnr_se': '")) {
                    Log.i((String)Texting.TAG, (String)("Answer did not contain rnr_se! " + this.general));
                    throw new IOException("Answer did not contain rnr_se! " + this.general);
                }
            } else {
                Log.i((String)Texting.TAG, (String)"setRNRSEE(): Answer was null!");
                throw new IOException("setRNRSEE(): Answer was null!");
            }
            String p1 = this.general.split("'_rnr_se': '", 2)[1];
            this.rnrSEE = p1.split("',", 2)[0];
            Log.i((String)Texting.TAG, (String)"Successfully Received rnr_se.");
            Object var1_1 = null;
        }

        String get(String urlString) throws IOException {
            InputStream is;
            URL url = new URL(urlString);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            int responseCode = 0;
            try {
                conn.setRequestProperty("Authorization", "GoogleLogin auth=" + this.authToken);
                conn.setRequestProperty("User-agent", Texting.USER_AGENT);
                conn.setInstanceFollowRedirects(false);
                conn.connect();
                responseCode = conn.getResponseCode();
                Log.i((String)Texting.TAG, (String)(urlString + " - " + conn.getResponseMessage()));
            }
            catch (Exception e) {
                throw new IOException(urlString + " : " + conn.getResponseMessage() + "(" + responseCode + ") : IO Error.");
            }
            if (responseCode == 200) {
                is = conn.getInputStream();
            } else {
                if (responseCode == 301 || responseCode == 302 || responseCode == 303 || responseCode == 307) {
                    ++this.redirectCounter;
                    if (this.redirectCounter > 5) {
                        this.redirectCounter = 0;
                        throw new IOException(urlString + " : " + conn.getResponseMessage() + "(" + responseCode + ") : Too many redirects. exiting.");
                    }
                    String location = conn.getHeaderField("Location");
                    if (location != null && !location.equals("")) {
                        System.out.println(urlString + " - " + responseCode + " - new URL: " + location);
                        return this.get(location);
                    }
                    throw new IOException(urlString + " : " + conn.getResponseMessage() + "(" + responseCode + ") : Received moved answer but no Location. exiting.");
                }
                is = conn.getErrorStream();
            }
            this.redirectCounter = 0;
            if (is == null) {
                throw new IOException(urlString + " : " + conn.getResponseMessage() + "(" + responseCode + ") : InputStream was null : exiting.");
            }
            String result = "";
            try {
                String line;
                BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                StringBuffer sb = new StringBuffer();
                while ((line = rd.readLine()) != null) {
                    sb.append(line + "\n\r");
                }
                rd.close();
                result = sb.toString();
            }
            catch (Exception e) {
                throw new IOException(urlString + " - " + conn.getResponseMessage() + "(" + responseCode + ") - " + e.getLocalizedMessage());
            }
            return result;
        }
    }
}

