/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.OnDestroyListener;
import com.google.appinventor.components.runtime.OnResumeListener;
import com.google.appinventor.components.runtime.OnStopListener;
import com.google.appinventor.components.runtime.collect.Maps;
import com.google.appinventor.components.runtime.util.ExternalTextToSpeech;
import com.google.appinventor.components.runtime.util.ITextToSpeech;
import com.google.appinventor.components.runtime.util.InternalTextToSpeech;
import com.google.appinventor.components.runtime.util.SdkLevel;
import com.google.appinventor.components.runtime.util.YailList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;

@DesignerComponent(version=5, description="The TestToSpeech component speaks a given text aloud.  You can set the pitch and the rate of speech. <p>You can also set a language by supplying a language code.  This changes the pronounciation of words, not the actual language spoken.  For example, setting the language to French and speaking English text will sound like someone speaking English (en) with a French accent.</p> <p>You can also specify a country by supplying a country code. This can affect the pronounciation.  For example, British English (GBR) will sound different from US English (USA).  Not every country code will affect every language.</p> <p>The languages and countries available depend on the particular device, and can be listed with the AvailableLanguages and AvailableCountries properties.</p>", category=ComponentCategory.MEDIA, nonVisible=true, iconName="images/textToSpeech.png")
@SimpleObject
public class TextToSpeech
extends AndroidNonvisibleComponent
implements Component,
OnStopListener,
OnResumeListener,
OnDestroyListener {
    private static final Map<String, Locale> iso3LanguageToLocaleMap = Maps.newHashMap();
    private static final Map<String, Locale> iso3CountryToLocaleMap = Maps.newHashMap();
    private float pitch = 1.0f;
    private float speechRate = 1.0f;
    private static final String LOG_TAG = "TextToSpeech";
    private ArrayList<String> languageList;
    private ArrayList<String> countryList;
    private YailList allLanguages;
    private YailList allCountries;
    private boolean result = false;
    private String language;
    private String country;
    private final ITextToSpeech tts;
    private String iso2Language;
    private String iso2Country;
    private boolean isTtsPrepared;

    private static void initLocaleMaps() {
        Locale[] locales;
        for (Locale locale : locales = Locale.getAvailableLocales()) {
            try {
                String iso3Country = locale.getISO3Country();
                if (iso3Country.length() > 0) {
                    iso3CountryToLocaleMap.put(iso3Country, locale);
                }
            }
            catch (MissingResourceException iso3Country) {
                // empty catch block
            }
            try {
                String iso3Language = locale.getISO3Language();
                if (iso3Language.length() <= 0) continue;
                iso3LanguageToLocaleMap.put(iso3Language, locale);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
    }

    public TextToSpeech(ComponentContainer container) {
        super(container.$form());
        this.Language("");
        this.Country("");
        boolean useExternalLibrary = SdkLevel.getLevel() < 4;
        Log.v((String)LOG_TAG, (String)("Using " + (useExternalLibrary ? "external" : "internal") + " TTS library."));
        ITextToSpeech.TextToSpeechCallback callback = new ITextToSpeech.TextToSpeechCallback(){

            public void onSuccess() {
                TextToSpeech.this.result = true;
                TextToSpeech.this.AfterSpeaking(true);
            }

            public void onFailure() {
                TextToSpeech.this.result = false;
                TextToSpeech.this.AfterSpeaking(false);
            }
        };
        this.tts = useExternalLibrary ? new ExternalTextToSpeech(container, callback) : new InternalTextToSpeech(container.$context(), callback);
        this.form.registerForOnStop(this);
        this.form.registerForOnResume(this);
        this.form.registerForOnDestroy(this);
        this.form.setVolumeControlStream(3);
        this.isTtsPrepared = false;
        this.languageList = new ArrayList();
        this.countryList = new ArrayList();
        this.allLanguages = YailList.makeList(this.languageList);
        this.allCountries = YailList.makeList(this.countryList);
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public boolean Result() {
        return this.result;
    }

    @DesignerProperty(editorType="languages", defaultValue="")
    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="Sets the language for TextToSpeech. This changes the way that words are pronounced, not the actual language that is spoken.  For example setting the language to and speaking English text with sound like someone speaking English with a Frernch accent.")
    public void Language(String language) {
        Locale locale;
        switch (language.length()) {
            case 3: {
                locale = TextToSpeech.iso3LanguageToLocale(language);
                this.language = locale.getISO3Language();
                break;
            }
            case 2: {
                locale = new Locale(language);
                this.language = locale.getLanguage();
                break;
            }
            default: {
                locale = Locale.getDefault();
                this.language = locale.getLanguage();
            }
        }
        this.iso2Language = locale.getLanguage();
    }

    private static Locale iso3LanguageToLocale(String iso3Language) {
        Locale mappedLocale = iso3LanguageToLocaleMap.get(iso3Language);
        if (mappedLocale == null) {
            mappedLocale = iso3LanguageToLocaleMap.get(iso3Language.toLowerCase(Locale.ENGLISH));
        }
        return mappedLocale == null ? Locale.getDefault() : mappedLocale;
    }

    @DesignerProperty(editorType="float", defaultValue="1.0")
    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="Sets the Pitch for TextToSpeech The values should be between 0 and 2 where lower values lower the tone of synthesized voice and greater values raise it.")
    public void Pitch(float pitch) {
        if (pitch < 0.0f || pitch > 2.0f) {
            Log.i((String)LOG_TAG, (String)("Pitch value should be between 0 and 2, but user specified: " + pitch));
            return;
        }
        this.pitch = pitch;
        this.tts.setPitch(pitch == 0.0f ? 0.1f : pitch);
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="Returns current value of Pitch")
    public float Pitch() {
        return this.pitch;
    }

    @DesignerProperty(editorType="float", defaultValue="1.0")
    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="Sets the SpeechRate for TextToSpeech. The values should be between 0 and 2 where lower values slow down the pitch and greater values accelerate it.")
    public void SpeechRate(float speechRate) {
        if (speechRate < 0.0f || speechRate > 2.0f) {
            Log.i((String)LOG_TAG, (String)("speechRate value should be between 0 and 2, but user specified: " + speechRate));
            return;
        }
        this.speechRate = speechRate;
        this.tts.setSpeechRate(speechRate == 0.0f ? 0.1f : speechRate);
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="Returns current value of SpeechRate")
    public float SpeechRate() {
        return this.speechRate;
    }

    @SimpleProperty
    public String Language() {
        return this.language;
    }

    @DesignerProperty(editorType="countries", defaultValue="")
    @SimpleProperty(description="Country code to use for speech generation.  This can affect the pronounciation.  For example, British English (GBR) will sound different from US English (USA).  Not every country code will affect every language.", category=PropertyCategory.BEHAVIOR)
    public void Country(String country) {
        Locale locale;
        switch (country.length()) {
            case 3: {
                locale = TextToSpeech.iso3CountryToLocale(country);
                this.country = locale.getISO3Country();
                break;
            }
            case 2: {
                locale = new Locale(country);
                this.country = locale.getCountry();
                break;
            }
            default: {
                locale = Locale.getDefault();
                this.country = locale.getCountry();
            }
        }
        this.iso2Country = locale.getCountry();
    }

    private static Locale iso3CountryToLocale(String iso3Country) {
        Locale mappedLocale = iso3CountryToLocaleMap.get(iso3Country);
        if (mappedLocale == null) {
            mappedLocale = iso3CountryToLocaleMap.get(iso3Country.toUpperCase(Locale.ENGLISH));
        }
        return mappedLocale == null ? Locale.getDefault() : mappedLocale;
    }

    @SimpleProperty
    public String Country() {
        return this.country;
    }

    @SimpleProperty(description="List of the languages available on this device for use with TextToSpeech.  Check the Android developer documentation under supported languages to find the meanings of these abbreviations.")
    public YailList AvailableLanguages() {
        this.prepareLanguageAndCountryProperties();
        return this.allLanguages;
    }

    @SimpleProperty(description="List of the country codes available on this device for use with TextToSpeech.  Check the Android developer documentation under supported languages to find the meanings of these abbreviations.")
    public YailList AvailableCountries() {
        this.prepareLanguageAndCountryProperties();
        return this.allCountries;
    }

    public void prepareLanguageAndCountryProperties() {
        if (!this.isTtsPrepared) {
            if (!this.tts.isInitialized()) {
                this.form.dispatchErrorOccurredEvent(this, LOG_TAG, 2701, new Object[0]);
                this.Speak("");
            } else {
                this.getLanguageAndCountryLists();
                this.isTtsPrepared = true;
            }
        }
    }

    private void getLanguageAndCountryLists() {
        if (SdkLevel.getLevel() >= 4) {
            for (Locale locale : Locale.getAvailableLocales()) {
                int res = this.tts.isLanguageAvailable(locale);
                if (res == -2) continue;
                String tempLang = locale.getLanguage();
                String tempCountry = locale.getISO3Country();
                if (!tempLang.equals("") && !this.languageList.contains(tempLang)) {
                    this.languageList.add(tempLang);
                }
                if (tempCountry.equals("") || this.countryList.contains(tempCountry)) continue;
                this.countryList.add(tempCountry);
            }
            Collections.sort(this.languageList);
            Collections.sort(this.countryList);
            this.allLanguages = YailList.makeList(this.languageList);
            this.allCountries = YailList.makeList(this.countryList);
        }
    }

    @SimpleFunction
    public void Speak(String message) {
        this.BeforeSpeaking();
        Locale loc = new Locale(this.iso2Language, this.iso2Country);
        this.tts.speak(message, loc);
    }

    @SimpleEvent
    public void BeforeSpeaking() {
        EventDispatcher.dispatchEvent(this, "BeforeSpeaking", new Object[0]);
    }

    @SimpleEvent
    public void AfterSpeaking(boolean result) {
        EventDispatcher.dispatchEvent(this, "AfterSpeaking", result);
    }

    public void onStop() {
        this.tts.onStop();
    }

    public void onResume() {
        this.tts.onResume();
    }

    public void onDestroy() {
        this.tts.onDestroy();
    }

    static {
        TextToSpeech.initLocaleMaps();
    }
}

