/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.runtime.AndroidViewComponent;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.util.TextViewUtil;
import com.google.appinventor.components.runtime.util.ViewUtil;

@SimpleObject
public abstract class TextBoxBase
extends AndroidViewComponent
implements View.OnFocusChangeListener {
    protected final EditText view;
    private int textAlignment;
    private int backgroundColor;
    private int fontTypeface;
    private boolean bold;
    private boolean italic;
    private String hint;
    private int textColor;
    private Drawable defaultTextBoxDrawable;

    public TextBoxBase(ComponentContainer container, EditText textview) {
        super(container);
        this.view = textview;
        this.view.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.defaultTextBoxDrawable = this.view.getBackground();
        container.$add(this);
        container.setChildWidth(this, 160);
        this.TextAlignment(0);
        this.Enabled(true);
        this.fontTypeface = 0;
        TextViewUtil.setFontTypeface((TextView)this.view, this.fontTypeface, this.bold, this.italic);
        this.FontSize(14.0f);
        this.Hint("");
        this.Text("");
        this.TextColor(-16777216);
    }

    public View getView() {
        return this.view;
    }

    @SimpleEvent
    public void GotFocus() {
        EventDispatcher.dispatchEvent(this, "GotFocus", new Object[0]);
    }

    @SimpleEvent
    public void LostFocus() {
        EventDispatcher.dispatchEvent(this, "LostFocus", new Object[0]);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="Whether the text should be left justified, centered, or right justified.  By default, text is left justified.", userVisible=false)
    public int TextAlignment() {
        return this.textAlignment;
    }

    @DesignerProperty(editorType="textalignment", defaultValue="0")
    @SimpleProperty(userVisible=false)
    public void TextAlignment(int alignment) {
        this.textAlignment = alignment;
        TextViewUtil.setAlignment((TextView)this.view, alignment, false);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="The background color of the input box.  You can choose a color by name in the Designer or in the Blocks Editor.  The default background color is 'default' (shaded 3-D look).")
    public int BackgroundColor() {
        return this.backgroundColor;
    }

    @DesignerProperty(editorType="color", defaultValue="&H00000000")
    @SimpleProperty
    public void BackgroundColor(int argb) {
        this.backgroundColor = argb;
        if (argb != 0) {
            TextViewUtil.setBackgroundColor((TextView)this.view, argb);
        } else {
            ViewUtil.setBackgroundDrawable((View)this.view, this.defaultTextBoxDrawable);
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="Whether the user can enter text into this input box.  By default, this is true.")
    public boolean Enabled() {
        return TextViewUtil.isEnabled((TextView)this.view);
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty
    public void Enabled(boolean enabled) {
        TextViewUtil.setEnabled((TextView)this.view, enabled);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, userVisible=false, description="Whether the font for the text should be bold.  By default, it is not.")
    public boolean FontBold() {
        return this.bold;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty(userVisible=false)
    public void FontBold(boolean bold) {
        this.bold = bold;
        TextViewUtil.setFontTypeface((TextView)this.view, this.fontTypeface, bold, this.italic);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="Whether the text should appear in italics.  By default, it does not.", userVisible=false)
    public boolean FontItalic() {
        return this.italic;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty(userVisible=false)
    public void FontItalic(boolean italic) {
        this.italic = italic;
        TextViewUtil.setFontTypeface((TextView)this.view, this.fontTypeface, this.bold, italic);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="The font size for the text.  By default, it is 14.0 points.")
    public float FontSize() {
        return TextViewUtil.getFontSize((TextView)this.view, (Context)this.container.$context());
    }

    @DesignerProperty(editorType="non_negative_float", defaultValue="14.0")
    @SimpleProperty
    public void FontSize(float size) {
        TextViewUtil.setFontSize((TextView)this.view, size);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="The font for the text.  The value can be changed in the Designer.", userVisible=false)
    public int FontTypeface() {
        return this.fontTypeface;
    }

    @DesignerProperty(editorType="typeface", defaultValue="0")
    @SimpleProperty(userVisible=false)
    public void FontTypeface(int typeface) {
        this.fontTypeface = typeface;
        TextViewUtil.setFontTypeface((TextView)this.view, this.fontTypeface, this.bold, this.italic);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="Text that should appear faintly in the input box to provide a hint as to what the user should enter.  This can only be seen if the <code>Text</code> property is empty.")
    public String Hint() {
        return this.hint;
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty
    public void Hint(String hint) {
        this.hint = hint;
        this.view.setHint((CharSequence)hint);
        this.view.invalidate();
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String Text() {
        return TextViewUtil.getText((TextView)this.view);
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="The text in the input box, which can be set by the programmer in the Designer or Blocks Editor, or it can be entered by the user (unless the <code>Enabled</code> property is false).")
    public void Text(String text) {
        TextViewUtil.setText((TextView)this.view, text);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="The color for the text.  You can choose a color by name in the Designer or in the Blocks Editor.  The default text color is black.")
    public int TextColor() {
        return this.textColor;
    }

    @DesignerProperty(editorType="color", defaultValue="&HFF000000")
    @SimpleProperty
    public void TextColor(int argb) {
        this.textColor = argb;
        if (argb != 0) {
            TextViewUtil.setTextColor((TextView)this.view, argb);
        } else {
            TextViewUtil.setTextColor((TextView)this.view, -16777216);
        }
    }

    @SimpleFunction(description="Sets the textbox active.")
    public void RequestFocus() {
        this.view.requestFocus();
    }

    public void onFocusChange(View previouslyFocused, boolean gainFocus) {
        if (gainFocus) {
            this.GotFocus();
        } else {
            this.LostFocus();
        }
    }
}

