/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.content.Context;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.runtime.AndroidViewComponent;
import com.google.appinventor.components.runtime.Layout;

@SimpleObject
public class TableLayout
implements Layout {
    private final android.widget.TableLayout layoutManager;
    private final Handler handler;
    private int numColumns;
    private int numRows;

    TableLayout(Context context, int numColumns, int numRows) {
        this.layoutManager = new android.widget.TableLayout(context);
        this.numColumns = numColumns;
        this.numRows = numRows;
        this.handler = new Handler();
        for (int row = 0; row < numRows; ++row) {
            TableRow tableRow = new TableRow(context);
            for (int col = 0; col < numColumns; ++col) {
                tableRow.addView(this.newEmptyCellView(), col, (ViewGroup.LayoutParams)TableLayout.newEmptyCellLayoutParams());
            }
            this.layoutManager.addView((View)tableRow, row, (ViewGroup.LayoutParams)new TableLayout.LayoutParams());
        }
    }

    int getNumColumns() {
        return this.numColumns;
    }

    void setNumColumns(int newNumColumns) {
        if (newNumColumns > this.numColumns) {
            Context context = this.layoutManager.getContext();
            for (int row = 0; row < this.numRows; ++row) {
                TableRow tableRow = (TableRow)this.layoutManager.getChildAt(row);
                for (int col = this.numColumns; col < newNumColumns; ++col) {
                    tableRow.addView(this.newEmptyCellView(), col, (ViewGroup.LayoutParams)TableLayout.newEmptyCellLayoutParams());
                }
            }
            this.numColumns = newNumColumns;
        } else if (newNumColumns < this.numColumns) {
            for (int row = 0; row < this.numRows; ++row) {
                TableRow tableRow = (TableRow)this.layoutManager.getChildAt(row);
                tableRow.removeViews(newNumColumns, this.numColumns - newNumColumns);
            }
            this.numColumns = newNumColumns;
        }
    }

    int getNumRows() {
        return this.numRows;
    }

    void setNumRows(int newNumRows) {
        if (newNumRows > this.numRows) {
            Context context = this.layoutManager.getContext();
            for (int row = this.numRows; row < newNumRows; ++row) {
                TableRow tableRow = new TableRow(context);
                for (int col = 0; col < this.numColumns; ++col) {
                    tableRow.addView(this.newEmptyCellView(), col, (ViewGroup.LayoutParams)TableLayout.newEmptyCellLayoutParams());
                }
                this.layoutManager.addView((View)tableRow, row, (ViewGroup.LayoutParams)new TableLayout.LayoutParams());
            }
            this.numRows = newNumRows;
        } else if (newNumRows < this.numRows) {
            this.layoutManager.removeViews(newNumRows, this.numRows - newNumRows);
            this.numRows = newNumRows;
        }
    }

    public ViewGroup getLayoutManager() {
        return this.layoutManager;
    }

    public void add(AndroidViewComponent child) {
        child.getView().setLayoutParams((ViewGroup.LayoutParams)TableLayout.newCellLayoutParams());
        this.addChildLater(child);
    }

    private void addChildLater(final AndroidViewComponent child) {
        this.handler.post(new Runnable(){

            public void run() {
                TableLayout.this.addChild(child);
            }
        });
    }

    private void addChild(AndroidViewComponent child) {
        int row = child.Row();
        int col = child.Column();
        if (row == -1 || col == -1) {
            this.addChildLater(child);
        } else if (row >= 0 && row < this.numRows) {
            if (col >= 0 && col < this.numColumns) {
                TableRow tableRow = (TableRow)this.layoutManager.getChildAt(row);
                tableRow.removeViewAt(col);
                View cellView = child.getView();
                tableRow.addView(cellView, col, cellView.getLayoutParams());
            } else {
                Log.e((String)"TableLayout", (String)("Child has illegal Column property: " + child));
            }
        } else {
            Log.e((String)"TableLayout", (String)("Child has illegal Row property: " + child));
        }
    }

    private View newEmptyCellView() {
        return new TextView(this.layoutManager.getContext());
    }

    private static TableRow.LayoutParams newEmptyCellLayoutParams() {
        return new TableRow.LayoutParams(0, 0);
    }

    private static TableRow.LayoutParams newCellLayoutParams() {
        return new TableRow.LayoutParams();
    }
}

