/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.os.Handler;
import android.util.Log;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.runtime.AlarmHandler;
import com.google.appinventor.components.runtime.Canvas;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.Form;
import com.google.appinventor.components.runtime.HandlesEventDispatching;
import com.google.appinventor.components.runtime.OnDestroyListener;
import com.google.appinventor.components.runtime.VisibleComponent;
import com.google.appinventor.components.runtime.errors.AssertionFailure;
import com.google.appinventor.components.runtime.errors.IllegalArgumentError;
import com.google.appinventor.components.runtime.util.BoundingBox;
import com.google.appinventor.components.runtime.util.TimerInternal;
import java.util.HashSet;
import java.util.Set;

@SimpleObject
public abstract class Sprite
extends VisibleComponent
implements AlarmHandler,
OnDestroyListener,
Deleteable {
    private static final String LOG_TAG = "Sprite";
    private static final boolean DEFAULT_ENABLED = true;
    private static final int DEFAULT_HEADING = 0;
    private static final int DEFAULT_INTERVAL = 100;
    private static final float DEFAULT_SPEED = 0.0f;
    private static final boolean DEFAULT_VISIBLE = true;
    private static final double DEFAULT_Z = 1.0;
    protected final Canvas canvas;
    private final TimerInternal timerInternal;
    private final Handler androidUIHandler;
    private final Set<Sprite> registeredCollisions;
    protected boolean initialized = false;
    protected int interval;
    protected boolean visible = true;
    protected double xLeft;
    protected double yTop;
    protected double zLayer;
    protected float speed;
    protected Form form;
    protected double userHeading;
    protected double heading;
    protected double headingRadians;
    protected double headingCos;
    protected double headingSin;

    protected Sprite(ComponentContainer container, Handler handler) {
        this.androidUIHandler = handler;
        if (!(container instanceof Canvas)) {
            throw new IllegalArgumentError("Sprite constructor called with container " + container);
        }
        this.canvas = (Canvas)container;
        this.canvas.addSprite(this);
        this.registeredCollisions = new HashSet<Sprite>();
        this.timerInternal = new TimerInternal(this, true, 100, handler);
        this.form = container.$form();
        this.Heading(0.0);
        this.Enabled(true);
        this.Interval(100);
        this.Speed(0.0f);
        this.Visible(true);
        this.Z(1.0);
        container.$form().registerForOnDestroy(this);
    }

    protected Sprite(ComponentContainer container) {
        this(container, new Handler());
    }

    public void Initialize() {
        this.initialized = true;
        this.canvas.registerChange(this);
    }

    @SimpleProperty(description="Controls whether the sprite moves when its speed is non-zero.", category=PropertyCategory.BEHAVIOR)
    public boolean Enabled() {
        return this.timerInternal.Enabled();
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty
    public void Enabled(boolean enabled) {
        this.timerInternal.Enabled(enabled);
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    @DesignerProperty(editorType="float", defaultValue="0")
    public void Heading(double userHeading) {
        this.userHeading = userHeading;
        this.heading = -userHeading;
        this.headingRadians = Math.toRadians(this.heading);
        this.headingCos = Math.cos(this.headingRadians);
        this.headingSin = Math.sin(this.headingRadians);
        this.registerChange();
    }

    @SimpleProperty(description="Returns the sprite's heading in degrees above the positive x-axis.  Zero degrees is toward the right of the screen; 90 degrees is toward the top of the screen.")
    public double Heading() {
        return this.userHeading;
    }

    @SimpleProperty(description="The interval in milliseconds at which the sprite's position is updated.  For example, if the interval is 50 and the speed is 10, then the sprite will move 10 pixels every 50 milliseconds.", category=PropertyCategory.BEHAVIOR)
    public int Interval() {
        return this.timerInternal.Interval();
    }

    @DesignerProperty(editorType="non_negative_integer", defaultValue="100")
    @SimpleProperty
    public void Interval(int interval) {
        this.timerInternal.Interval(interval);
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    @DesignerProperty(editorType="float", defaultValue="0.0")
    public void Speed(float speed) {
        this.speed = speed;
    }

    @SimpleProperty(description="he speed at which the sprite moves.  The sprite moves this many pixels every interval.")
    public float Speed() {
        return this.speed;
    }

    @SimpleProperty(description="True if the sprite is visible.", category=PropertyCategory.APPEARANCE)
    public boolean Visible() {
        return this.visible;
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty
    public void Visible(boolean visible) {
        this.visible = visible;
        this.registerChange();
    }

    @SimpleProperty(description="The horizontal coordinate of the left edge of the sprite, increasing as the sprite moves to the right.")
    public double X() {
        return this.xLeft;
    }

    @DesignerProperty(editorType="float", defaultValue="0.0")
    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public void X(double x) {
        this.xLeft = x;
        this.registerChange();
    }

    @DesignerProperty(editorType="float", defaultValue="0.0")
    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public void Y(double y) {
        this.yTop = y;
        this.registerChange();
    }

    @SimpleProperty(description="The vertical coordinate of the top of the sprite, increasing as the sprite moves down.")
    public double Y() {
        return this.yTop;
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    @DesignerProperty(editorType="float", defaultValue="1.0")
    public void Z(double layer) {
        this.zLayer = layer;
        this.canvas.changeSpriteLayer(this);
    }

    @SimpleProperty(description="How the sprite should be layered relative to other sprits, with higher-numbered layers in front of lower-numbered layers.")
    public double Z() {
        return this.zLayer;
    }

    protected void postEvent(final Sprite sprite, final String eventName, final Object ... args) {
        this.androidUIHandler.post(new Runnable(){

            public void run() {
                EventDispatcher.dispatchEvent(sprite, eventName, args);
            }
        });
    }

    @SimpleEvent
    public void CollidedWith(Sprite other) {
        if (this.registeredCollisions.contains(other)) {
            Log.e((String)LOG_TAG, (String)("Collision between sprites " + this + " and " + other + " re-registered"));
            return;
        }
        this.registeredCollisions.add(other);
        this.postEvent(this, "CollidedWith", other);
    }

    @SimpleEvent
    public void Dragged(float startX, float startY, float prevX, float prevY, float currentX, float currentY) {
        this.postEvent(this, "Dragged", Float.valueOf(startX), Float.valueOf(startY), Float.valueOf(prevX), Float.valueOf(prevY), Float.valueOf(currentX), Float.valueOf(currentY));
    }

    @SimpleEvent(description="Event handler called when the sprite reaches an edge of the screen. If Bounce is then called with that edge, the sprite will appear to bounce off of the edge it reached.  Edge here is represented as an integer that indicates one of eight directions north(1), northeast(2), east(3), southeast(4), south (-1), southwest(-2), west(-3), and northwest(-4).")
    public void EdgeReached(int edge) {
        if (edge == 0 || edge < -4 || edge > 4) {
            throw new IllegalArgumentException("Illegal argument " + edge + " to Sprite.EdgeReached()");
        }
        this.postEvent(this, "EdgeReached", edge);
    }

    @SimpleEvent(description="Event indicating that a pair of sprites are no longer colliding.")
    public void NoLongerCollidingWith(Sprite other) {
        if (!this.registeredCollisions.contains(other)) {
            Log.e((String)LOG_TAG, (String)("Collision between sprites " + this + " and " + other + " removed but not present"));
        }
        this.registeredCollisions.remove(other);
        this.postEvent(this, "NoLongerCollidingWith", other);
    }

    @SimpleEvent
    public void Touched(float x, float y) {
        this.postEvent(this, "Touched", Float.valueOf(x), Float.valueOf(y));
    }

    @SimpleEvent
    public void Flung(float x, float y, float speed, float heading, float xvel, float yvel) {
        this.postEvent(this, "Flung", Float.valueOf(x), Float.valueOf(y), Float.valueOf(speed), Float.valueOf(heading), Float.valueOf(xvel), Float.valueOf(yvel));
    }

    @SimpleEvent
    public void TouchUp(float x, float y) {
        this.postEvent(this, "TouchUp", Float.valueOf(x), Float.valueOf(y));
    }

    @SimpleEvent
    public void TouchDown(float x, float y) {
        this.postEvent(this, "TouchDown", Float.valueOf(x), Float.valueOf(y));
    }

    @SimpleFunction(description="Makes this sprite bounce, as if off a wall.  For normal bouncing, the edge argument should be the one returned by EdgeReached.")
    public void Bounce(int edge) {
        this.MoveIntoBounds();
        double normalizedAngle = this.userHeading % 360.0;
        if (normalizedAngle < 0.0) {
            normalizedAngle += 360.0;
        }
        if (edge == 3 && (normalizedAngle < 90.0 || normalizedAngle > 270.0) || edge == -3 && normalizedAngle > 90.0 && normalizedAngle < 270.0) {
            this.Heading(180.0 - normalizedAngle);
        } else if (edge == 1 && normalizedAngle > 0.0 && normalizedAngle < 180.0 || edge == -1 && normalizedAngle > 180.0) {
            this.Heading(360.0 - normalizedAngle);
        } else if (edge == 2 && normalizedAngle > 0.0 && normalizedAngle < 90.0 || edge == -4 && normalizedAngle > 90.0 && normalizedAngle < 180.0 || edge == -2 && normalizedAngle > 180.0 && normalizedAngle < 270.0 || edge == 4 && normalizedAngle > 270.0) {
            this.Heading(180.0 + normalizedAngle);
        }
    }

    @SimpleFunction
    public boolean CollidingWith(Sprite other) {
        return this.registeredCollisions.contains(other);
    }

    @SimpleFunction
    public void MoveIntoBounds() {
        this.moveIntoBounds(this.canvas.Width(), this.canvas.Height());
    }

    @SimpleFunction(description="Moves the sprite so that its left top corner is at the specfied x and y coordinates.")
    public void MoveTo(double x, double y) {
        this.xLeft = x;
        this.yTop = y;
        this.registerChange();
    }

    @SimpleFunction(description="Turns the sprite to point towards a designated target sprite. The new heading will be parallel to the line joining the centerpoints of the two sprites.")
    public void PointTowards(Sprite target) {
        this.Heading(-Math.toDegrees(Math.atan2(target.Y() - this.Y() + (double)((target.Height() - this.Height()) / 2), target.X() - this.X() + (double)((target.Width() - this.Width()) / 2))));
    }

    @SimpleFunction(description="Turns the sprite to point towards the point with coordinates as (x, y).")
    public void PointInDirection(double x, double y) {
        this.Heading(-Math.toDegrees(Math.atan2(y - this.Y() - (double)(this.Height() / 2), x - this.X() - (double)(this.Width() / 2))));
    }

    protected void registerChange() {
        if (!this.initialized) {
            this.canvas.getView().invalidate();
            return;
        }
        int edge = this.hitEdge();
        if (edge != 0) {
            this.EdgeReached(edge);
        }
        this.canvas.registerChange(this);
    }

    protected int hitEdge() {
        if (!this.canvas.ready()) {
            return 0;
        }
        return this.hitEdge(this.canvas.Width(), this.canvas.Height());
    }

    @SimpleFunction
    protected final void moveIntoBounds(int canvasWidth, int canvasHeight) {
        boolean moved = false;
        if (this.Width() > canvasWidth) {
            if (this.xLeft != 0.0) {
                this.xLeft = 0.0;
                moved = true;
            }
        } else if (this.overWestEdge()) {
            this.xLeft = 0.0;
            moved = true;
        } else if (this.overEastEdge(canvasWidth)) {
            this.xLeft = canvasWidth - this.Width();
            moved = true;
        }
        if (this.Height() > canvasHeight) {
            if (this.yTop != 0.0) {
                this.yTop = 0.0;
                moved = true;
            }
        } else if (this.overNorthEdge()) {
            this.yTop = 0.0;
            moved = true;
        } else if (this.overSouthEdge(canvasHeight)) {
            this.yTop = canvasHeight - this.Height();
            moved = true;
        }
        if (moved) {
            this.registerChange();
        }
    }

    protected void updateCoordinates() {
        this.xLeft += (double)this.speed * this.headingCos;
        this.yTop += (double)this.speed * this.headingSin;
    }

    private final boolean overWestEdge() {
        return this.xLeft < 0.0;
    }

    private final boolean overEastEdge(int canvasWidth) {
        return this.xLeft + (double)this.Width() > (double)canvasWidth;
    }

    private final boolean overNorthEdge() {
        return this.yTop < 0.0;
    }

    private final boolean overSouthEdge(int canvasHeight) {
        return this.yTop + (double)this.Height() > (double)canvasHeight;
    }

    protected int hitEdge(int canvasWidth, int canvasHeight) {
        boolean west = this.overWestEdge();
        boolean north = this.overNorthEdge();
        boolean east = this.overEastEdge(canvasWidth);
        boolean south = this.overSouthEdge(canvasHeight);
        if (!(north || south || east || west)) {
            return 0;
        }
        this.MoveIntoBounds();
        if (west) {
            if (north) {
                return -4;
            }
            if (south) {
                return -2;
            }
            return -3;
        }
        if (east) {
            if (north) {
                return 2;
            }
            if (south) {
                return 4;
            }
            return 3;
        }
        if (north) {
            return 1;
        }
        if (south) {
            return -1;
        }
        throw new AssertionFailure("Unreachable code hit in Sprite.hitEdge()");
    }

    public BoundingBox getBoundingBox(int border) {
        return new BoundingBox(this.X() - (double)border, this.Y() - (double)border, this.X() + (double)this.Width() - 1.0 + (double)border, this.Y() + (double)this.Height() - 1.0 + (double)border);
    }

    public static boolean colliding(Sprite sprite1, Sprite sprite2) {
        BoundingBox rect2;
        BoundingBox rect1 = sprite1.getBoundingBox(1);
        if (!rect1.intersectDestructively(rect2 = sprite2.getBoundingBox(1))) {
            return false;
        }
        for (double x = rect1.getLeft(); x <= rect1.getRight(); x += 1.0) {
            for (double y = rect1.getTop(); y <= rect1.getBottom(); y += 1.0) {
                if (!sprite1.containsPoint(x, y) || !sprite2.containsPoint(x, y)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean intersectsWith(BoundingBox rect) {
        BoundingBox rect1 = this.getBoundingBox(0);
        if (!rect1.intersectDestructively(rect)) {
            return false;
        }
        for (double x = rect1.getLeft(); x < rect1.getRight(); x += 1.0) {
            for (double y = rect1.getTop(); y < rect1.getBottom(); y += 1.0) {
                if (!this.containsPoint(x, y)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsPoint(double qx, double qy) {
        return qx >= this.xLeft && qx < this.xLeft + (double)this.Width() && qy >= this.yTop && qy < this.yTop + (double)this.Height();
    }

    public void alarm() {
        if (this.initialized && this.speed != 0.0f) {
            this.updateCoordinates();
            this.registerChange();
        }
    }

    public HandlesEventDispatching getDispatchDelegate() {
        return this.canvas.$form();
    }

    public void onDestroy() {
        this.timerInternal.Enabled(false);
    }

    public void onDelete() {
        this.timerInternal.Enabled(false);
        this.canvas.removeSprite(this);
    }

    protected abstract void onDraw(android.graphics.Canvas var1);
}

