/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.content.Context;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidViewComponent;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.util.ElementsUtil;
import com.google.appinventor.components.runtime.util.YailList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DesignerComponent(version=1, description="<p>A spinner component that displays a pop-up with a list of elements. These elements can be set in the Designer or Blocks Editor by setting the<code>ElementsFromString</code> property to a string-separated concatenation (for example, <em>choice 1, choice 2, choice 3</em>) or by setting the <code>Elements</code> property to a List in the Blocks editor. Spinners are created with the first item already selected. So selecting  it does not generate an After Picking event. Consequently it's useful to make the  first Spinner item be a non-choice like \"Select from below...\". </p>", category=ComponentCategory.USERINTERFACE, nonVisible=false, iconName="images/spinner.png")
@SimpleObject
public final class Spinner
extends AndroidViewComponent
implements AdapterView.OnItemSelectedListener {
    private final android.widget.Spinner view;
    private ArrayAdapter<String> adapter;
    private YailList items = new YailList();
    private int oldAdapterCount;
    private int oldSelectionIndex;

    public Spinner(ComponentContainer container) {
        super(container);
        this.view = new android.widget.Spinner((Context)container.$context());
        this.adapter = new ArrayAdapter((Context)container.$context(), 17367048);
        this.adapter.setDropDownViewResource(0x1090009);
        this.view.setAdapter(this.adapter);
        this.view.setOnItemSelectedListener((AdapterView.OnItemSelectedListener)this);
        container.$add(this);
        this.Prompt("");
        this.oldSelectionIndex = this.SelectionIndex();
    }

    @Override
    public View getView() {
        return this.view;
    }

    @SimpleProperty(description="Returns the current selected item in the spinner ", category=PropertyCategory.BEHAVIOR)
    public String Selection() {
        return this.SelectionIndex() == 0 ? "" : (String)this.view.getItemAtPosition(this.SelectionIndex() - 1);
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty(description="Set the selected item in the spinner", category=PropertyCategory.BEHAVIOR)
    public void Selection(String value) {
        this.SelectionIndex(ElementsUtil.setSelectedIndexFromValue(value, this.items));
    }

    @SimpleProperty(description="The index of the currently selected item, starting at 1. If no item is selected, the value will be 0.", category=PropertyCategory.BEHAVIOR)
    public int SelectionIndex() {
        return ElementsUtil.selectionIndex(this.view.getSelectedItemPosition() + 1, this.items);
    }

    @SimpleProperty(description="Set the spinner selection to the element at the given index.If an attempt is made to set this to a number less than 1 or greater than the number of items in the Spinner, SelectionIndex will be set to 0, and Selection will be set to empty.", category=PropertyCategory.BEHAVIOR)
    public void SelectionIndex(int index) {
        this.oldSelectionIndex = this.SelectionIndex();
        this.view.setSelection(ElementsUtil.selectionIndex(index, this.items) - 1);
    }

    @SimpleProperty(description="returns a list of text elements to be picked from.", category=PropertyCategory.BEHAVIOR)
    public YailList Elements() {
        return this.items;
    }

    @SimpleProperty(description="adds the passed text element to the Spinner list", category=PropertyCategory.BEHAVIOR)
    public void Elements(YailList itemList) {
        if (itemList.size() == 0) {
            this.SelectionIndex(0);
        } else if (itemList.size() < this.items.size() && this.SelectionIndex() == this.items.size()) {
            this.SelectionIndex(itemList.size());
        }
        this.items = ElementsUtil.elements(itemList, "Spinner");
        this.setAdapterData(itemList.toStringArray());
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty(description="sets the Spinner list to the elements passed in the comma-separated string", category=PropertyCategory.BEHAVIOR)
    public void ElementsFromString(String itemstring) {
        this.Elements(ElementsUtil.elementsFromString(itemstring));
    }

    private void setAdapterData(String[] theItems) {
        this.oldAdapterCount = this.adapter.getCount();
        this.adapter.clear();
        for (int i = 0; i < theItems.length; ++i) {
            this.adapter.add((Object)theItems[i]);
        }
    }

    @SimpleProperty(description="Text with the current title for the Spinner window", category=PropertyCategory.APPEARANCE)
    public String Prompt() {
        return this.view.getPrompt().toString();
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty(description="sets the Spinner window prompt to the given tittle", category=PropertyCategory.APPEARANCE)
    public void Prompt(String str) {
        this.view.setPrompt((CharSequence)str);
    }

    @SimpleFunction(description="displays the dropdown list for selection, same action as when the user clicks on the spinner.")
    public void DisplayDropdown() {
        this.view.performClick();
    }

    @SimpleEvent(description="Event called after the user selects an item from the dropdown list.")
    public void AfterSelecting(String selection) {
        EventDispatcher.dispatchEvent(this, "AfterSelecting", selection);
    }

    public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
        if (this.oldAdapterCount == 0 && this.adapter.getCount() > 0 && this.oldSelectionIndex == 0 || this.oldAdapterCount > this.adapter.getCount() && this.oldSelectionIndex > this.adapter.getCount()) {
            this.SelectionIndex(position + 1);
            this.oldAdapterCount = this.adapter.getCount();
        } else {
            this.SelectionIndex(position + 1);
            this.AfterSelecting(this.Selection());
        }
    }

    public void onNothingSelected(AdapterView<?> parent) {
        this.view.setSelection(0);
    }
}

