/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.media.MediaRecorder;
import android.os.Environment;
import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.util.FileUtil;
import java.io.IOException;

@DesignerComponent(version=2, description="<p>Multimedia component that records audio.</p>", category=ComponentCategory.MEDIA, nonVisible=true, iconName="images/soundRecorder.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.RECORD_AUDIO,android.permission.WRITE_EXTERNAL_STORAGE,android.permission.READ_EXTERNAL_STORAGE")
public final class SoundRecorder
extends AndroidNonvisibleComponent
implements Component,
MediaRecorder.OnErrorListener,
MediaRecorder.OnInfoListener {
    private static final String TAG = "SoundRecorder";
    private String savedRecording = "";
    private RecordingController controller;

    public SoundRecorder(ComponentContainer container) {
        super(container.$form());
    }

    @SimpleProperty(description="Specifies the path to the file where the recording should be stored. If this proprety is the empty string, then starting a recording will create a file in an appropriate location.  If the property is not the empty string, it should specify a complete path to a file in an existing directory, including a file name with the extension .3gp.", category=PropertyCategory.BEHAVIOR)
    public String SavedRecording() {
        return this.savedRecording;
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty
    public void SavedRecording(String pathName) {
        this.savedRecording = pathName;
    }

    @SimpleFunction
    public void Start() {
        if (this.controller != null) {
            Log.i((String)TAG, (String)("Start() called, but already recording to " + this.controller.file));
            return;
        }
        Log.i((String)TAG, (String)"Start() called");
        if (!Environment.getExternalStorageState().equals("mounted")) {
            this.form.dispatchErrorOccurredEvent(this, "Start", 705, new Object[0]);
            return;
        }
        try {
            this.controller = new RecordingController(this.savedRecording);
        }
        catch (Throwable t) {
            this.form.dispatchErrorOccurredEvent(this, "Start", 802, t.getMessage());
            return;
        }
        try {
            this.controller.start();
        }
        catch (Throwable t) {
            this.controller = null;
            this.form.dispatchErrorOccurredEvent(this, "Start", 802, t.getMessage());
            return;
        }
        this.StartedRecording();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(MediaRecorder affectedRecorder, int what, int extra) {
        if (this.controller == null || affectedRecorder != this.controller.recorder) {
            Log.w((String)TAG, (String)"onError called with wrong recorder. Ignoring.");
            return;
        }
        this.form.dispatchErrorOccurredEvent(this, "onError", 801, new Object[0]);
        try {
            this.controller.stop();
        }
        catch (Throwable e) {
            Log.w((String)TAG, (String)e.getMessage());
        }
        finally {
            this.controller = null;
            this.StoppedRecording();
        }
    }

    public void onInfo(MediaRecorder affectedRecorder, int what, int extra) {
        if (this.controller == null || affectedRecorder != this.controller.recorder) {
            Log.w((String)TAG, (String)"onInfo called with wrong recorder. Ignoring.");
            return;
        }
        Log.i((String)TAG, (String)"Recoverable condition while recording. Will attempt to stop normally.");
        this.controller.recorder.stop();
    }

    @SimpleFunction
    public void Stop() {
        if (this.controller == null) {
            Log.i((String)TAG, (String)"Stop() called, but already stopped.");
            return;
        }
        try {
            Log.i((String)TAG, (String)"Stop() called");
            Log.i((String)TAG, (String)"stopping");
            this.controller.stop();
            Log.i((String)TAG, (String)("Firing AfterSoundRecorded with " + this.controller.file));
            this.AfterSoundRecorded(this.controller.file);
        }
        catch (Throwable t) {
            this.form.dispatchErrorOccurredEvent(this, "Stop", 801, new Object[0]);
        }
        finally {
            this.controller = null;
            this.StoppedRecording();
        }
    }

    @SimpleEvent(description="Provides the location of the newly created sound.")
    public void AfterSoundRecorded(String sound) {
        EventDispatcher.dispatchEvent(this, "AfterSoundRecorded", sound);
    }

    @SimpleEvent(description="Indicates that the recorder has started, and can be stopped.")
    public void StartedRecording() {
        EventDispatcher.dispatchEvent(this, "StartedRecording", new Object[0]);
    }

    @SimpleEvent(description="Indicates that the recorder has stopped, and can be started again.")
    public void StoppedRecording() {
        EventDispatcher.dispatchEvent(this, "StoppedRecording", new Object[0]);
    }

    private class RecordingController {
        final MediaRecorder recorder;
        final String file;

        RecordingController(String savedRecording) throws IOException {
            this.file = savedRecording.equals("") ? FileUtil.getRecordingFile("3gp").getAbsolutePath() : savedRecording;
            this.recorder = new MediaRecorder();
            this.recorder.setAudioSource(1);
            this.recorder.setOutputFormat(1);
            this.recorder.setAudioEncoder(1);
            Log.i((String)SoundRecorder.TAG, (String)("Setting output file to " + this.file));
            this.recorder.setOutputFile(this.file);
            Log.i((String)SoundRecorder.TAG, (String)"preparing");
            this.recorder.prepare();
            this.recorder.setOnErrorListener((MediaRecorder.OnErrorListener)SoundRecorder.this);
            this.recorder.setOnInfoListener((MediaRecorder.OnInfoListener)SoundRecorder.this);
        }

        void start() throws IllegalStateException {
            Log.i((String)SoundRecorder.TAG, (String)"starting");
            try {
                this.recorder.start();
            }
            catch (IllegalStateException e) {
                Log.e((String)SoundRecorder.TAG, (String)"got IllegalStateException. Are there two recorders running?", (Throwable)e);
                throw new IllegalStateException("Is there another recording running?");
            }
        }

        void stop() {
            this.recorder.setOnErrorListener(null);
            this.recorder.setOnInfoListener(null);
            this.recorder.stop();
            this.recorder.reset();
            this.recorder.release();
        }
    }
}

