/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.media.SoundPool;
import android.os.Handler;
import android.os.Vibrator;
import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.OnDestroyListener;
import com.google.appinventor.components.runtime.OnResumeListener;
import com.google.appinventor.components.runtime.OnStopListener;
import com.google.appinventor.components.runtime.util.MediaUtil;
import com.google.appinventor.components.runtime.util.SdkLevel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

@DesignerComponent(version=3, description="<p>A multimedia component that plays sound files and optionally vibrates for the number of milliseconds (thousandths of a second) specified in the Blocks Editor.  The name of the sound file to play can be specified either in the Designer or in the Blocks Editor.</p> <p>For supported sound file formats, see <a href=\"http://developer.android.com/guide/appendix/media-formats.html\" target=\"_blank\">Android Supported Media Formats</a>.</p><p>This <code>Sound</code> component is best for short sound files, such as sound effects, while the <code>Player</code> component is more efficient for longer sounds, such as songs.</p><p>You might get an error if you attempt to play a sound immeditely after setting the source.</p>", category=ComponentCategory.MEDIA, nonVisible=true, iconName="images/soundEffect.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.VIBRATE, android.permission.INTERNET")
public class Sound
extends AndroidNonvisibleComponent
implements Component,
OnResumeListener,
OnStopListener,
OnDestroyListener,
Deleteable {
    private boolean loadComplete = true;
    private static final int MAX_STREAMS = 10;
    private static final int MAX_PLAY_DELAY_RETRIES = 10;
    private static final int PLAY_DELAY_LENGTH = 50;
    private static final float VOLUME_FULL = 1.0f;
    private static final int LOOP_MODE_NO_LOOP = 0;
    private static final float PLAYBACK_RATE_NORMAL = 1.0f;
    private SoundPool soundPool;
    private final Map<String, Integer> soundMap;
    private final boolean waitForLoadToComplete = SdkLevel.getLevel() >= 8;
    private String sourcePath = "";
    private int soundId;
    private int streamId;
    private int minimumInterval;
    private long timeLastPlayed;
    private final Vibrator vibe;
    private final Handler playWaitHandler = new Handler();
    private final Component thisComponent = this;
    private int delayRetries;

    public Sound(ComponentContainer container) {
        super(container.$form());
        this.soundPool = new SoundPool(10, 3, 0);
        this.soundMap = new HashMap<String, Integer>();
        this.vibe = (Vibrator)this.form.getSystemService("vibrator");
        this.form.registerForOnResume(this);
        this.form.registerForOnStop(this);
        this.form.registerForOnDestroy(this);
        this.form.setVolumeControlStream(3);
        this.MinimumInterval(500);
        if (this.waitForLoadToComplete) {
            new OnLoadHelper().setOnloadCompleteListener(this.soundPool);
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="The name of the sound file.  Only certain formats are supported.  See http://developer.android.com/guide/appendix/media-formats.html.")
    public String Source() {
        return this.sourcePath;
    }

    @DesignerProperty(editorType="asset", defaultValue="")
    @SimpleProperty
    public void Source(String path) {
        String string2 = this.sourcePath = path == null ? "" : path;
        if (this.streamId != 0) {
            this.soundPool.stop(this.streamId);
            this.streamId = 0;
        }
        this.soundId = 0;
        if (this.sourcePath.length() != 0) {
            Integer existingSoundId = this.soundMap.get(this.sourcePath);
            if (existingSoundId != null) {
                this.soundId = existingSoundId;
            } else {
                Log.i((String)"Sound", (String)("No existing sound with path " + this.sourcePath + "."));
                try {
                    int newSoundId = MediaUtil.loadSoundPool(this.soundPool, this.form, this.sourcePath);
                    if (newSoundId != 0) {
                        this.soundMap.put(this.sourcePath, newSoundId);
                        Log.i((String)"Sound", (String)("Successfully began loading sound: setting soundId to " + newSoundId + "."));
                        this.soundId = newSoundId;
                        this.loadComplete = false;
                    } else {
                        this.form.dispatchErrorOccurredEvent(this, "Source", 701, this.sourcePath);
                    }
                }
                catch (IOException e) {
                    this.form.dispatchErrorOccurredEvent(this, "Source", 701, this.sourcePath);
                }
            }
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="The minimum interval, in milliseconds, between sounds.  If you play a sound, all further Play() calls will be ignored until the interval has elapsed.")
    public int MinimumInterval() {
        return this.minimumInterval;
    }

    @DesignerProperty(editorType="non_negative_integer", defaultValue="500")
    @SimpleProperty
    public void MinimumInterval(int interval) {
        this.minimumInterval = interval;
    }

    @SimpleFunction(description="Plays the sound specified by the Source property.")
    public void Play() {
        if (this.soundId != 0) {
            long currentTime = System.currentTimeMillis();
            if (this.timeLastPlayed == 0L || currentTime >= this.timeLastPlayed + (long)this.minimumInterval) {
                this.timeLastPlayed = currentTime;
                this.delayRetries = 10;
                this.playWhenLoadComplete();
            } else {
                Log.i((String)"Sound", (String)"Unable to play because MinimumInterval has not elapsed since last play.");
            }
        } else {
            Log.i((String)"Sound", (String)"Sound Id was 0. Did you remember to set the Source property?");
            this.form.dispatchErrorOccurredEvent(this, "Play", 703, this.sourcePath);
        }
    }

    private void playWhenLoadComplete() {
        if (this.loadComplete || !this.waitForLoadToComplete) {
            this.playAndCheckResult();
        } else {
            Log.i((String)"Sound", (String)("Sound not ready:  retrying.  Remaining retries = " + this.delayRetries));
            this.playWaitHandler.postDelayed(new Runnable(){

                public void run() {
                    if (Sound.this.loadComplete) {
                        Sound.this.playAndCheckResult();
                    } else if (Sound.this.delayRetries > 0) {
                        Sound.this.delayRetries--;
                        Sound.this.playWhenLoadComplete();
                    } else {
                        Sound.this.form.dispatchErrorOccurredEvent(Sound.this.thisComponent, "Play", 710, Sound.this.sourcePath);
                    }
                }
            }, 50L);
        }
    }

    private void playAndCheckResult() {
        this.streamId = this.soundPool.play(this.soundId, 1.0f, 1.0f, 0, 0, 1.0f);
        Log.i((String)"Sound", (String)("SoundPool.play returned stream id " + this.streamId));
        if (this.streamId == 0) {
            this.form.dispatchErrorOccurredEvent(this, "Play", 703, this.sourcePath);
        }
    }

    @SimpleFunction(description="Pauses playing the sound if it is being played.")
    public void Pause() {
        if (this.streamId != 0) {
            this.soundPool.pause(this.streamId);
        } else {
            Log.i((String)"Sound", (String)"Unable to pause. Did you remember to call the Play function?");
        }
    }

    @SimpleFunction(description="Resumes playing the sound after a pause.")
    public void Resume() {
        if (this.streamId != 0) {
            this.soundPool.resume(this.streamId);
        } else {
            Log.i((String)"Sound", (String)"Unable to resume. Did you remember to call the Play function?");
        }
    }

    @SimpleFunction(description="Stops playing the sound if it is being played.")
    public void Stop() {
        if (this.streamId != 0) {
            this.soundPool.stop(this.streamId);
            this.streamId = 0;
        } else {
            Log.i((String)"Sound", (String)"Unable to stop. Did you remember to call the Play function?");
        }
    }

    @SimpleFunction(description="Vibrates for the specified number of milliseconds.")
    public void Vibrate(int millisecs) {
        this.vibe.vibrate((long)millisecs);
    }

    @SimpleEvent(description="The SoundError event is no longer used. Please use the Screen.ErrorOccurred event instead.", userVisible=false)
    public void SoundError(String message) {
    }

    public void onStop() {
        Log.i((String)"Sound", (String)"Got onStop");
        if (this.streamId != 0) {
            this.soundPool.pause(this.streamId);
        }
    }

    public void onResume() {
        Log.i((String)"Sound", (String)"Got onResume");
        if (this.streamId != 0) {
            this.soundPool.resume(this.streamId);
        }
    }

    public void onDestroy() {
        this.prepareToDie();
    }

    public void onDelete() {
        this.prepareToDie();
    }

    private void prepareToDie() {
        if (this.streamId != 0) {
            this.soundPool.stop(this.streamId);
            this.soundPool.unload(this.streamId);
        }
        this.soundPool.release();
        this.vibe.cancel();
        this.soundPool = null;
    }

    private class OnLoadHelper {
        private OnLoadHelper() {
        }

        public void setOnloadCompleteListener(SoundPool soundPool) {
            soundPool.setOnLoadCompleteListener(new SoundPool.OnLoadCompleteListener(){

                public void onLoadComplete(SoundPool soundPool, int sampleId, int status) {
                    Sound.this.loadComplete = true;
                }
            });
        }
    }
}

