/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.webkit.MimeTypeMap;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.ComponentContainer;
import java.io.File;

@DesignerComponent(version=1, description="Sharing is a non-visible component that enables sharing files and/or messages between your app and other apps installed on a device. The component will display a list of the installed apps that can handle the information provided, and will allow the user to choose one to share the content with, for instance a mail app, a social network app, a texting app, and so on.<br>The file path can be taken directly from other components such as the Camera or the ImagePicker, but can also be specified directly to read from storage. Be aware that different devices treat storage differently, so a few things to try if, for instance, you have a file called arrow.gif in the folder <code>Appinventor/assets</code>, would be: <ul><li><code>\"file:///sdcard/Appinventor/assets/arrow.gif\"</code></li> or <li><code>\"/storage/Appinventor/assets/arrow.gif\"</code></li></ul>", category=ComponentCategory.SOCIAL, nonVisible=true, iconName="images/sharing.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.READ_EXTERNAL_STORAGE")
public class Sharing
extends AndroidNonvisibleComponent {
    public Sharing(ComponentContainer container) {
        super(container.$form());
    }

    @SimpleFunction(description="Shares a message through any capable application installed on the phone by displaying a list of the available apps and allowing the user to choose one from the list. The selected app will open with the message inserted on it.")
    public void ShareMessage(String message) {
        Intent shareIntent = new Intent("android.intent.action.SEND");
        shareIntent.putExtra("android.intent.extra.TEXT", message);
        shareIntent.setType("text/plain");
        this.form.startActivity(shareIntent);
    }

    @SimpleFunction(description="Shares a file through any capable application installed on the phone by displaying a list of the available apps and allowing the user to choose one from the list. The selected app will open with the file inserted on it.")
    public void ShareFile(String file) {
        this.ShareFileWithMessage(file, "");
    }

    @SimpleFunction(description="Shares both a file and a message through any capable application installed on the phone by displaying a list of available apps and allowing the user to  choose one from the list. The selected app will open with the file and message inserted on it.")
    public void ShareFileWithMessage(String file, String message) {
        Uri uri;
        File imageFile;
        if (!file.startsWith("file://")) {
            file = "file://" + file;
        }
        if ((imageFile = new File((uri = Uri.parse((String)file)).getPath())).isFile()) {
            String fileExtension = file.substring(file.lastIndexOf(".") + 1).toLowerCase();
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            String type = mime.getMimeTypeFromExtension(fileExtension);
            Intent shareIntent = new Intent("android.intent.action.SEND");
            shareIntent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
            shareIntent.setType(type);
            if (message.length() > 0) {
                shareIntent.putExtra("android.intent.extra.TEXT", message);
            }
            this.form.startActivity(shareIntent);
        } else {
            String eventName = "ShareFile";
            if (message.equals("")) {
                eventName = "ShareFileWithMessage";
            }
            this.form.dispatchErrorOccurredEvent(this, eventName, 2001, file);
        }
    }
}

