/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.google.appinventor.components.runtime.util.HoneycombUtil;
import com.google.appinventor.components.runtime.util.SdkLevel;

public class ScaledFrameLayout
extends ViewGroup {
    private int mLeftWidth;
    private int mRightWidth;
    private final Rect mTmpContainerRect = new Rect();
    private final Rect mTmpChildRect = new Rect();
    private float mScale = 1.0f;

    public ScaledFrameLayout(Context context) {
        super(context);
    }

    public ScaledFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScaledFrameLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setClipChildren(false);
    }

    protected void dispatchDraw(Canvas canvas) {
        canvas.save(1);
        canvas.scale(this.mScale, this.mScale);
        super.dispatchDraw(canvas);
        canvas.restore();
    }

    public ViewParent invalidateChildInParent(int[] location, Rect dirty) {
        int[] scaledLocation = new int[]{(int)((float)location[0] * this.mScale), (int)((float)location[1] * this.mScale)};
        Rect scaledDirty = new Rect((int)((float)dirty.left * this.mScale), (int)((float)dirty.top * this.mScale), (int)((float)dirty.right * this.mScale), (int)((float)dirty.bottom * this.mScale));
        this.invalidate(scaledDirty);
        return super.invalidateChildInParent(scaledLocation, scaledDirty);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        ev.setLocation(ev.getX() * (1.0f / this.mScale), ev.getY() * (1.0f / this.mScale));
        super.dispatchTouchEvent(ev);
        return true;
    }

    public void setScale(float scale) {
        this.mScale = scale;
        this.updatePadding(this.getWidth(), this.getHeight());
    }

    private void updatePadding(int width, int height) {
        int paddingRight = (int)((float)width * (this.mScale - 1.0f) / this.mScale);
        int paddingBottom = (int)((float)height * (this.mScale - 1.0f) / this.mScale);
        this.setPadding(0, 0, paddingRight, paddingBottom);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.updatePadding(w, h);
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int count = this.getChildCount();
        this.mLeftWidth = 0;
        this.mRightWidth = 0;
        int maxHeight = 0;
        int maxWidth = 0;
        int childState = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
            this.mLeftWidth += Math.max(maxWidth, child.getMeasuredWidth());
            maxHeight = Math.max(maxHeight, child.getMeasuredHeight());
            if (SdkLevel.getLevel() < 11) continue;
            childState = HoneycombUtil.combineMeasuredStates(this, childState, HoneycombUtil.getMeasuredState(child));
        }
        maxWidth += this.mLeftWidth + this.mRightWidth;
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        maxWidth = Math.max(maxWidth, this.getSuggestedMinimumWidth());
        if (SdkLevel.getLevel() >= 11) {
            this.setMeasuredDimension(HoneycombUtil.resolveSizeAndState(this, maxWidth, widthMeasureSpec, childState), HoneycombUtil.resolveSizeAndState(this, maxHeight, heightMeasureSpec, childState << 16));
        } else {
            this.setMeasuredDimension(ScaledFrameLayout.resolveSize((int)maxWidth, (int)widthMeasureSpec), ScaledFrameLayout.resolveSize((int)maxHeight, (int)heightMeasureSpec));
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int count = this.getChildCount();
        int leftPos = this.getPaddingLeft();
        int parentTop = this.getPaddingTop();
        int parentBottom = bottom - top - this.getPaddingBottom();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            this.mTmpContainerRect.left = leftPos;
            leftPos = this.mTmpContainerRect.right = leftPos;
            this.mTmpContainerRect.top = parentTop;
            this.mTmpContainerRect.bottom = parentBottom;
            Gravity.apply((int)51, (int)width, (int)height, (Rect)this.mTmpContainerRect, (Rect)this.mTmpChildRect);
            child.layout(this.mTmpChildRect.left, this.mTmpChildRect.top, this.mTmpChildRect.right, this.mTmpChildRect.bottom);
        }
    }
}

