/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.app.Application;
import android.content.Context;
import android.util.Log;
import com.google.appinventor.common.version.GitBuildId;
import com.google.appinventor.components.runtime.multidex.MultiDex;
import org.acra.ACRA;
import org.acra.ACRAConfiguration;
import org.acra.annotation.ReportsCrashes;

@ReportsCrashes(formKey="")
public class ReplApplication
extends Application {
    private boolean active = false;
    private static ReplApplication thisInstance;
    public static boolean installed;

    protected void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        installed = MultiDex.install((Context)this, false);
    }

    public void onCreate() {
        super.onCreate();
        thisInstance = this;
        String acraUri = GitBuildId.getAcraUri();
        if (acraUri.equals("")) {
            Log.i((String)"ReplApplication", (String)"ACRA Not Active");
        } else {
            Log.i((String)"ReplApplication", (String)("ACRA Active, URI = " + acraUri));
            ACRAConfiguration config = ACRA.getNewDefaultConfig((Application)this);
            config.setFormUri(acraUri);
            config.setDisableSSLCertValidation(true);
            ACRA.setConfig((ACRAConfiguration)config);
            ACRA.init((Application)this);
            this.active = true;
        }
    }

    public static void reportError(Throwable ex, String reportId) {
        ACRA.getErrorReporter().putCustomData("reportid", reportId);
        ReplApplication.reportError(ex);
    }

    public static void reportError(Throwable ex) {
        if (thisInstance != null && ReplApplication.thisInstance.active) {
            ACRA.getErrorReporter().handleException(ex);
        }
    }

    public static boolean isAcraActive() {
        return thisInstance != null && ReplApplication.thisInstance.active;
    }

    static {
        installed = true;
    }
}

