/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.OnPauseListener;
import com.google.appinventor.components.runtime.OnResumeListener;
import com.google.appinventor.components.runtime.OnStopListener;
import com.google.appinventor.components.runtime.SensorComponent;
import java.util.List;

@DesignerComponent(version=1, description="<p>Non-visible component that can measures the proximity of an object in cm relative to the view screen of a device. This sensor is typically used to determine whether a handset is being held up to a persons ear; i.e. lets you determine how far away an object is from a device. Many devices return the absolute distance, in cm, but some return only near and far values. In this case, the sensor usually reports its maximum range value in the far state and a lesser value in the near state.</p>", category=ComponentCategory.SENSORS, nonVisible=true, iconName="images/proximitysensor.png")
@SimpleObject
public class ProximitySensor
extends AndroidNonvisibleComponent
implements OnStopListener,
OnResumeListener,
SensorComponent,
OnPauseListener,
SensorEventListener,
Deleteable {
    private Sensor proximitySensor;
    private final SensorManager sensorManager;
    private boolean enabled;
    private float distance = 0.0f;
    private boolean keepRunningWhenOnPause;

    public ProximitySensor(ComponentContainer container) {
        super(container.$form());
        this.form.registerForOnResume(this);
        this.form.registerForOnStop(this);
        this.form.registerForOnPause(this);
        this.enabled = true;
        this.sensorManager = (SensorManager)container.$context().getSystemService("sensor");
        this.proximitySensor = this.sensorManager.getDefaultSensor(8);
        this.startListening();
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="Reports whether or not the device has a proximity sensor")
    public boolean Available() {
        List sensors = this.sensorManager.getSensorList(8);
        return sensors.size() > 0;
    }

    public void onResume() {
        if (this.enabled) {
            this.startListening();
        }
    }

    public void onStop() {
        if (this.enabled) {
            this.stopListening();
        }
    }

    public void onDelete() {
        if (this.enabled) {
            this.stopListening();
        }
    }

    public void onPause() {
        if (this.enabled && !this.keepRunningWhenOnPause) {
            this.stopListening();
        }
    }

    private void startListening() {
        this.sensorManager.registerListener((SensorEventListener)this, this.proximitySensor, 3);
    }

    private void stopListening() {
        this.sensorManager.unregisterListener((SensorEventListener)this);
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        if (this.enabled) {
            float[] values = (float[])sensorEvent.values.clone();
            this.distance = values[0];
            this.ProximityChanged(this.distance);
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="Reports the Maximum Range of the device's ProximitySensor")
    public float MaximumRange() {
        return this.proximitySensor.getMaximumRange();
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public boolean Enabled() {
        return this.enabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty(description="If enabled, then device will listen for changes in proximity")
    public void Enabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (enabled) {
            this.startListening();
        } else {
            this.stopListening();
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public boolean KeepRunningWhenOnPause() {
        return this.keepRunningWhenOnPause;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty(description="If set to true, it will keep sensing for proximity changes even when the app is not visible")
    public void KeepRunningWhenOnPause(boolean enabled) {
        this.keepRunningWhenOnPause = enabled;
    }

    @SimpleEvent(description="Triggered when distance (in cm) of the object to the device changes. ")
    public void ProximityChanged(float distance) {
        this.distance = distance;
        EventDispatcher.dispatchEvent(this, "ProximityChanged", Float.valueOf(this.distance));
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="Returns the distance from the object to the device")
    public float Distance() {
        return this.distance;
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }
}

