/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.app.Activity;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Vibrator;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.OnDestroyListener;
import com.google.appinventor.components.runtime.OnPauseListener;
import com.google.appinventor.components.runtime.OnResumeListener;
import com.google.appinventor.components.runtime.OnStopListener;
import com.google.appinventor.components.runtime.errors.IllegalArgumentError;
import com.google.appinventor.components.runtime.util.FroyoUtil;
import com.google.appinventor.components.runtime.util.MediaUtil;
import com.google.appinventor.components.runtime.util.SdkLevel;
import java.io.IOException;

@DesignerComponent(version=6, description="Multimedia component that plays audio and controls phone vibration.  The name of a multimedia field is specified in the <code>Source</code> property, which can be set in the Designer or in the Blocks Editor.  The length of time for a vibration is specified in the Blocks Editor in milliseconds (thousandths of a second).\n<p>For supported audio formats, see <a href=\"http://developer.android.com/guide/appendix/media-formats.html\" target=\"_blank\">Android Supported Media Formats</a>.</p>\n<p>This component is best for long sound files, such as songs, while the <code>Sound</code> component is more efficient for short files, such as sound effects.</p>", category=ComponentCategory.MEDIA, nonVisible=true, iconName="images/player.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.VIBRATE, android.permission.INTERNET")
public final class Player
extends AndroidNonvisibleComponent
implements Component,
MediaPlayer.OnCompletionListener,
OnPauseListener,
OnResumeListener,
OnDestroyListener,
OnStopListener,
Deleteable {
    private MediaPlayer player;
    private final Vibrator vibe;
    public State playerState;
    private String sourcePath;
    private boolean loop;
    private boolean playOnlyInForeground;
    private boolean focusOn;
    private AudioManager am;
    private final Activity activity;
    private static final boolean audioFocusSupported = SdkLevel.getLevel() >= 8;
    private Object afChangeListener;

    public Player(ComponentContainer container) {
        super(container.$form());
        this.activity = container.$context();
        this.sourcePath = "";
        this.vibe = (Vibrator)this.form.getSystemService("vibrator");
        this.form.registerForOnDestroy(this);
        this.form.registerForOnResume(this);
        this.form.registerForOnPause(this);
        this.form.registerForOnStop(this);
        this.form.setVolumeControlStream(3);
        this.loop = false;
        this.playOnlyInForeground = false;
        this.focusOn = false;
        this.am = audioFocusSupported ? FroyoUtil.setAudioManager(this.activity) : null;
        this.afChangeListener = audioFocusSupported ? FroyoUtil.setAudioFocusChangeListener(this) : null;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String Source() {
        return this.sourcePath;
    }

    @DesignerProperty(editorType="asset", defaultValue="")
    @SimpleProperty
    public void Source(String path) {
        String string2 = this.sourcePath = path == null ? "" : path;
        if (this.playerState == State.PREPARED || this.playerState == State.PLAYING || this.playerState == State.PAUSED_BY_USER) {
            this.player.stop();
            this.playerState = State.INITIAL;
        }
        if (this.player != null) {
            this.player.release();
            this.player = null;
        }
        if (this.sourcePath.length() > 0) {
            this.player = new MediaPlayer();
            this.player.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            try {
                MediaUtil.loadMediaPlayer(this.player, this.form, this.sourcePath);
            }
            catch (IOException e) {
                this.player.release();
                this.player = null;
                this.form.dispatchErrorOccurredEvent(this, "Source", 701, this.sourcePath);
                return;
            }
            this.player.setAudioStreamType(3);
            if (audioFocusSupported) {
                this.requestPermanentFocus();
            }
            this.prepare();
        }
    }

    private void requestPermanentFocus() {
        boolean bl = this.focusOn = FroyoUtil.focusRequestGranted(this.am, this.afChangeListener);
        if (!this.focusOn) {
            this.form.dispatchErrorOccurredEvent(this, "Source", 709, this.sourcePath);
        }
    }

    @SimpleProperty(description="Reports whether the media is playing", category=PropertyCategory.BEHAVIOR)
    public boolean IsPlaying() {
        if (this.playerState == State.PREPARED || this.playerState == State.PLAYING) {
            return this.player.isPlaying();
        }
        return false;
    }

    @SimpleProperty(description="If true, the player will loop when it plays. Setting Loop while the player is playing will affect the current playing.", category=PropertyCategory.BEHAVIOR)
    public boolean Loop() {
        return this.loop;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void Loop(boolean shouldLoop) {
        if (this.playerState == State.PREPARED || this.playerState == State.PLAYING || this.playerState == State.PAUSED_BY_USER) {
            this.player.setLooping(shouldLoop);
        }
        this.loop = shouldLoop;
    }

    @DesignerProperty(editorType="non_negative_float", defaultValue="50")
    @SimpleProperty(description="Sets the volume to a number between 0 and 100")
    public void Volume(int vol) {
        if (this.playerState == State.PREPARED || this.playerState == State.PLAYING || this.playerState == State.PAUSED_BY_USER) {
            if (vol > 100 || vol < 0) {
                throw new IllegalArgumentError("Volume must be set to a number between 0 and 100");
            }
            this.player.setVolume((float)vol / 100.0f, (float)vol / 100.0f);
        }
    }

    @SimpleProperty(description="If true, the player will pause playing when leaving the current screen; if false (default option), the player continues playing whenever the current screen is displaying or not.", category=PropertyCategory.BEHAVIOR)
    public boolean PlayOnlyInForeground() {
        return this.playOnlyInForeground;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void PlayOnlyInForeground(boolean shouldForeground) {
        this.playOnlyInForeground = shouldForeground;
    }

    @SimpleFunction
    public void Start() {
        if (audioFocusSupported && !this.focusOn) {
            this.requestPermanentFocus();
        }
        if (this.playerState == State.PREPARED || this.playerState == State.PLAYING || this.playerState == State.PAUSED_BY_USER || this.playerState == State.PAUSED_BY_EVENT) {
            this.player.setLooping(this.loop);
            this.player.start();
            this.playerState = State.PLAYING;
        }
    }

    @SimpleFunction
    public void Pause() {
        if (this.player == null) {
            return;
        }
        boolean wasPlaying = this.player.isPlaying();
        if (this.playerState == State.PLAYING) {
            this.player.pause();
            if (wasPlaying) {
                this.playerState = State.PAUSED_BY_USER;
            }
        }
    }

    public void pause() {
        if (this.player == null) {
            return;
        }
        if (this.playerState == State.PLAYING) {
            this.player.pause();
            this.playerState = State.PAUSED_BY_EVENT;
        }
    }

    @SimpleFunction
    public void Stop() {
        if (audioFocusSupported && this.focusOn) {
            this.abandonFocus();
        }
        if (this.playerState == State.PLAYING || this.playerState == State.PAUSED_BY_USER || this.playerState == State.PAUSED_BY_EVENT) {
            this.player.stop();
            this.prepare();
            if (this.player != null) {
                this.player.seekTo(0);
            }
        }
    }

    private void abandonFocus() {
        FroyoUtil.abandonFocus(this.am, this.afChangeListener);
        this.focusOn = false;
    }

    @SimpleFunction
    public void Vibrate(long milliseconds) {
        this.vibe.vibrate(milliseconds);
    }

    @SimpleEvent(description="The PlayerError event is no longer used. Please use the Screen.ErrorOccurred event instead.", userVisible=false)
    public void PlayerError(String message) {
    }

    private void prepare() {
        try {
            this.player.prepare();
            this.playerState = State.PREPARED;
        }
        catch (IOException ioe) {
            this.player.release();
            this.player = null;
            this.playerState = State.INITIAL;
            this.form.dispatchErrorOccurredEvent(this, "Source", 702, this.sourcePath);
        }
    }

    public void onCompletion(MediaPlayer m) {
        this.Completed();
    }

    @SimpleEvent
    public void Completed() {
        if (audioFocusSupported && this.focusOn) {
            this.abandonFocus();
        }
        EventDispatcher.dispatchEvent(this, "Completed", new Object[0]);
    }

    @SimpleEvent(description="This event is signaled when another player has started (and the current player is playing or paused, but not stopped).")
    public void OtherPlayerStarted() {
        EventDispatcher.dispatchEvent(this, "OtherPlayerStarted", new Object[0]);
    }

    public void onResume() {
        if (this.playOnlyInForeground && this.playerState == State.PAUSED_BY_EVENT) {
            this.Start();
        }
    }

    public void onPause() {
        if (this.player == null) {
            return;
        }
        if (this.playOnlyInForeground && this.player.isPlaying()) {
            this.pause();
        }
    }

    public void onStop() {
        if (this.player == null) {
            return;
        }
        if (this.playOnlyInForeground && this.player.isPlaying()) {
            this.pause();
        }
    }

    public void onDestroy() {
        this.prepareToDie();
    }

    public void onDelete() {
        this.prepareToDie();
    }

    private void prepareToDie() {
        if (audioFocusSupported && this.focusOn) {
            this.abandonFocus();
        }
        if (this.player != null && this.playerState != State.INITIAL) {
            this.player.stop();
        }
        this.playerState = State.INITIAL;
        if (this.player != null) {
            this.player.release();
            this.player = null;
        }
        this.vibe.cancel();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        INITIAL,
        PREPARED,
        PLAYING,
        PAUSED_BY_USER,
        PAUSED_BY_EVENT;

    }
}

