/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.app.Activity;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.Form;
import com.google.appinventor.components.runtime.ReplForm;
import com.google.appinventor.components.runtime.util.AppInvHTTPD;
import com.google.appinventor.components.runtime.util.PackageInstaller;
import java.security.MessageDigest;
import java.util.Formatter;

@DesignerComponent(version=1, description="Component that returns information about the phone.", category=ComponentCategory.INTERNAL, nonVisible=true, iconName="images/phoneip.png")
@SimpleObject
public class PhoneStatus
extends AndroidNonvisibleComponent
implements Component {
    private static Activity activity;
    private static final String LOG_TAG = "PhoneStatus";
    private final Form form;
    private static PhoneStatus mainInstance;

    public PhoneStatus(ComponentContainer container) {
        super(container.$form());
        this.form = container.$form();
        activity = container.$context();
        if (mainInstance == null) {
            mainInstance = this;
        }
    }

    @SimpleFunction(description="Returns the IP address of the phone in the form of a String")
    public static String GetWifiIpAddress() {
        Object wifiManager = activity.getSystemService("wifi");
        DhcpInfo ip = ((WifiManager)wifiManager).getDhcpInfo();
        int s_ipAddress = ip.ipAddress;
        String ipAddress = PhoneStatus.isConnected() ? PhoneStatus.intToIp(s_ipAddress) : "Error: No Wifi Connection";
        return ipAddress;
    }

    @SimpleFunction(description="Returns TRUE if the phone is on Wifi, FALSE otherwise")
    public static boolean isConnected() {
        ConnectivityManager connectivityManager = (ConnectivityManager)activity.getSystemService("connectivity");
        NetworkInfo networkInfo = null;
        if (connectivityManager != null) {
            networkInfo = connectivityManager.getNetworkInfo(1);
        }
        return networkInfo == null ? false : networkInfo.isConnected();
    }

    @SimpleFunction(description="Establish the secret seed for HOTP generation. Return the SHA1 of the provided seed, this will be used to contact the rendezvous server.")
    public String setHmacSeedReturnCode(String seed) {
        MessageDigest Sha1;
        AppInvHTTPD.setHmacKey(seed);
        try {
            Sha1 = MessageDigest.getInstance("SHA1");
        }
        catch (Exception e) {
            Log.e((String)LOG_TAG, (String)"Exception getting SHA1 Instance", (Throwable)e);
            return "";
        }
        Sha1.update(seed.getBytes());
        byte[] result = Sha1.digest();
        StringBuffer sb = new StringBuffer(result.length * 2);
        Formatter formatter = new Formatter(sb);
        for (byte b : result) {
            formatter.format("%02x", b);
        }
        Log.d((String)LOG_TAG, (String)("Seed = " + seed));
        Log.d((String)LOG_TAG, (String)("Code = " + sb.toString()));
        return sb.toString();
    }

    @SimpleFunction(description="Returns true if we are running in the emulator or USB Connection")
    public boolean isDirect() {
        Log.d((String)LOG_TAG, (String)("android.os.Build.VERSION.RELEASE = " + Build.VERSION.RELEASE));
        Log.d((String)LOG_TAG, (String)("android.os.Build.PRODUCT = " + Build.PRODUCT));
        if (Build.PRODUCT.contains("google_sdk")) {
            return true;
        }
        if (this.form instanceof ReplForm) {
            return ((ReplForm)this.form).isDirect();
        }
        return false;
    }

    @SimpleFunction(description="Start the internal AppInvHTTPD to listen for incoming forms. FOR REPL USE ONLY!")
    public void startHTTPD(boolean secure) {
        ReplForm.topform.startHTTPD(secure);
    }

    @SimpleFunction(description="Declare that we have loaded our initial assets and other assets should come from the sdcard")
    public void setAssetsLoaded() {
        if (this.form instanceof ReplForm) {
            ((ReplForm)this.form).setAssetsLoaded();
        }
    }

    @SimpleFunction(description="Causes an Exception, used to debug exception processing.")
    public static void doFault() throws Exception {
        throw new Exception("doFault called!");
    }

    @SimpleFunction(description="Obtain the Android Application Version")
    public String getVersionName() {
        try {
            PackageInfo pInfo = this.form.getPackageManager().getPackageInfo(this.form.getPackageName(), 0);
            return pInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)LOG_TAG, (String)"Exception fetching package name.", (Throwable)e);
            return "";
        }
    }

    @SimpleFunction(description="Downloads the URL and installs it as an Android Package")
    public void installURL(String url) {
        PackageInstaller.doPackageInstall(this.form, url);
    }

    @SimpleFunction(description="Really Exit the Application")
    public void shutdown() {
        this.form.finish();
        System.exit(0);
    }

    @SimpleEvent
    public void OnSettings() {
        EventDispatcher.dispatchEvent(this, "OnSettings", new Object[0]);
    }

    static void doSettings() {
        Log.d((String)LOG_TAG, (String)"doSettings called.");
        if (mainInstance != null) {
            mainInstance.OnSettings();
        } else {
            Log.d((String)LOG_TAG, (String)"mainStance is null on doSettings");
        }
    }

    public static String intToIp(int i) {
        return (i & 0xFF) + "." + (i >> 8 & 0xFF) + "." + (i >> 16 & 0xFF) + "." + (i >> 24 & 0xFF);
    }

    static {
        mainInstance = null;
    }
}

