/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.content.ContentUris;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.provider.Contacts;
import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.ContactPicker;
import com.google.appinventor.components.runtime.util.HoneycombMR1Util;
import com.google.appinventor.components.runtime.util.SdkLevel;
import java.util.ArrayList;

@DesignerComponent(version=4, description="A button that, when clicked on, displays a list of the contacts' phone numbers to choose among. After the user has made a selection, the following properties will be set to information about the chosen contact: <ul>\n<li> <code>ContactName</code>: the contact's name </li>\n <li> <code>PhoneNumber</code>: the contact's phone number </li>\n <li> <code>EmailAddress</code>: the contact's email address </li> <li> <code>Picture</code>: the name of the file containing the contact's image, which can be used as a <code>Picture</code> property value for the <code>Image</code> or <code>ImageSprite</code> component.</li></ul>\n</p><p>Other properties affect the appearance of the button (<code>TextAlignment</code>, <code>BackgroundColor</code>, etc.) and whether it can be clicked on (<code>Enabled</code>).</p>\n<p>The PhoneNumberPicker component may not work on all Android devices. For example, on Android systems before system 3.0, the returned lists of phone numbers and email addresses will be empty.\n", category=ComponentCategory.SOCIAL)
@SimpleObject
@UsesPermissions(permissionNames="android.permission.READ_CONTACTS")
public class PhoneNumberPicker
extends ContactPicker {
    private static String[] NAME_PROJECTION;
    private static String[] DATA_PROJECTION;
    private static final String[] PROJECTION;
    private static final int NAME_INDEX = 0;
    private static final int NUMBER_INDEX = 1;
    private static final int PERSON_INDEX = 2;
    private static final int EMAIL_INDEX = 3;
    private static final String LOG_TAG = "PhoneNumberPicker";

    public PhoneNumberPicker(ComponentContainer container) {
        super(container, Contacts.Phones.CONTENT_URI);
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String PhoneNumber() {
        return this.ensureNotNull(this.phoneNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultReturned(int requestCode, int resultCode, Intent data) {
        if (requestCode == this.requestCode && resultCode == -1) {
            Log.i((String)LOG_TAG, (String)("received intent is " + data));
            Uri phoneUri = data.getData();
            String desiredPhoneUri = "";
            desiredPhoneUri = SdkLevel.getLevel() >= 12 ? "//com.android.contacts/data" : "//contacts/phones";
            if (this.checkContactUri(phoneUri, desiredPhoneUri)) {
                Cursor contactCursor = null;
                Cursor dataCursor = null;
                try {
                    if (SdkLevel.getLevel() >= 12) {
                        NAME_PROJECTION = HoneycombMR1Util.getNameProjection();
                        contactCursor = this.activityContext.getContentResolver().query(phoneUri, NAME_PROJECTION, null, null, null);
                        String id2 = this.postHoneycombGetContactNameAndPicture(contactCursor);
                        DATA_PROJECTION = HoneycombMR1Util.getDataProjection();
                        dataCursor = HoneycombMR1Util.getDataCursor(id2, this.activityContext, DATA_PROJECTION);
                        this.postHoneycombGetContactEmailsAndPhones(dataCursor);
                    } else {
                        contactCursor = this.activityContext.getContentResolver().query(phoneUri, PROJECTION, null, null, null);
                        this.preHoneycombGetContactInfo(contactCursor);
                    }
                    Log.i((String)LOG_TAG, (String)("Contact name = " + this.contactName + ", phone number = " + this.phoneNumber + ", emailAddress = " + this.emailAddress + ", contactPhotoUri = " + this.contactPictureUri));
                }
                catch (Exception e) {
                    Log.e((String)LOG_TAG, (String)"Exception in resultReturned", (Throwable)e);
                    this.puntContactSelection(1107);
                }
                finally {
                    if (contactCursor != null) {
                        contactCursor.close();
                    }
                    if (dataCursor != null) {
                        dataCursor.close();
                    }
                }
            }
            this.AfterPicking();
        }
    }

    public void preHoneycombGetContactInfo(Cursor cursor) {
        if (cursor.moveToFirst()) {
            this.contactName = this.guardCursorGetString(cursor, 0);
            this.phoneNumber = this.guardCursorGetString(cursor, 1);
            int contactId = cursor.getInt(2);
            Uri cUri = ContentUris.withAppendedId((Uri)Contacts.People.CONTENT_URI, (long)contactId);
            this.contactPictureUri = cUri.toString();
            String emailId = this.guardCursorGetString(cursor, 3);
            this.emailAddress = this.getEmailAddress(emailId);
        }
    }

    public String postHoneycombGetContactNameAndPicture(Cursor contactCursor) {
        String id2 = "";
        if (contactCursor.moveToFirst()) {
            int CONTACT_ID_INDEX = HoneycombMR1Util.getContactIdIndex(contactCursor);
            int NAME_INDEX = HoneycombMR1Util.getNameIndex(contactCursor);
            int PHOTO_INDEX = HoneycombMR1Util.getThumbnailIndex(contactCursor);
            int PHONE_INDEX = HoneycombMR1Util.getPhoneIndex(contactCursor);
            this.phoneNumber = this.guardCursorGetString(contactCursor, PHONE_INDEX);
            id2 = this.guardCursorGetString(contactCursor, CONTACT_ID_INDEX);
            this.contactName = this.guardCursorGetString(contactCursor, NAME_INDEX);
            this.contactPictureUri = this.guardCursorGetString(contactCursor, PHOTO_INDEX);
        }
        return id2;
    }

    public void postHoneycombGetContactEmailsAndPhones(Cursor dataCursor) {
        ArrayList<String> phoneListToStore = new ArrayList<String>();
        ArrayList<String> emailListToStore = new ArrayList<String>();
        if (dataCursor.moveToFirst()) {
            int PHONE_INDEX = HoneycombMR1Util.getPhoneIndex(dataCursor);
            int EMAIL_INDEX = HoneycombMR1Util.getEmailIndex(dataCursor);
            int MIME_INDEX = HoneycombMR1Util.getMimeIndex(dataCursor);
            String phoneType = HoneycombMR1Util.getPhoneType();
            String emailType = HoneycombMR1Util.getEmailType();
            while (!dataCursor.isAfterLast()) {
                String type = this.guardCursorGetString(dataCursor, MIME_INDEX);
                if (type.contains(phoneType)) {
                    phoneListToStore.add(this.guardCursorGetString(dataCursor, PHONE_INDEX));
                } else if (type.contains(emailType)) {
                    emailListToStore.add(this.guardCursorGetString(dataCursor, EMAIL_INDEX));
                } else {
                    Log.i((String)"ContactPicker", (String)("Type mismatch: " + type + " not " + phoneType + " or " + emailType));
                }
                dataCursor.moveToNext();
            }
            this.phoneNumberList = phoneListToStore;
            this.emailAddressList = emailListToStore;
            this.emailAddress = !this.emailAddressList.isEmpty() ? (String)this.emailAddressList.get(0) : "";
        }
    }

    static {
        PROJECTION = new String[]{"name", "number", "person", "primary_email"};
    }
}

