/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.OnPauseListener;
import com.google.appinventor.components.runtime.OnResumeListener;
import com.google.appinventor.components.runtime.util.FroyoUtil;
import com.google.appinventor.components.runtime.util.OrientationSensorUtil;
import com.google.appinventor.components.runtime.util.SdkLevel;

@DesignerComponent(version=2, description="<p>Non-visible component providing information about the device's physical orientation in three dimensions: <ul> <li> <strong>Roll</strong>: 0 degrees when the device is level, increases to      90 degrees as the device is tilted up on its left side, and      decreases to -90 degrees when the device is tilted up on its right side.      </li> <li> <strong>Pitch</strong>: 0 degrees when the device is level, up to      90 degrees as the device is tilted so its top is pointing down,      up to 180 degrees as it gets turned over.  Similarly, as the device      is tilted so its bottom points down, pitch decreases to -90      degrees, then further decreases to -180 degrees as it gets turned all the way      over.</li> <li> <strong>Azimuth</strong>: 0 degrees when the top of the device is      pointing north, 90 degrees when it is pointing east, 180 degrees      when it is pointing south, 270 degrees when it is pointing west,      etc.</li></ul>     These measurements assume that the device itself is not moving.</p>", category=ComponentCategory.SENSORS, nonVisible=true, iconName="images/orientationsensor.png")
@SimpleObject
public class OrientationSensor
extends AndroidNonvisibleComponent
implements SensorEventListener,
Deleteable,
OnPauseListener,
OnResumeListener {
    private static final String LOG_TAG = "OrientationSensor";
    private static final int AZIMUTH = 0;
    private static final int PITCH = 1;
    private static final int ROLL = 2;
    private static final int DIMENSIONS = 3;
    private boolean enabled;
    private float azimuth;
    private float pitch;
    private float roll;
    private int accuracy;
    private final SensorManager sensorManager;
    private final Sensor accelerometerSensor;
    private final Sensor magneticFieldSensor;
    private boolean listening;
    private final float[] accels = new float[3];
    private final float[] mags = new float[3];
    private boolean accelsFilled;
    private boolean magsFilled;
    private final float[] rotationMatrix = new float[9];
    private final float[] inclinationMatrix = new float[9];
    private final float[] values = new float[3];

    public OrientationSensor(ComponentContainer container) {
        super(container.$form());
        this.sensorManager = (SensorManager)container.$context().getSystemService("sensor");
        this.accelerometerSensor = this.sensorManager.getDefaultSensor(1);
        this.magneticFieldSensor = this.sensorManager.getDefaultSensor(2);
        this.form.registerForOnResume(this);
        this.form.registerForOnPause(this);
        this.Enabled(true);
    }

    private void startListening() {
        if (!this.listening) {
            this.sensorManager.registerListener((SensorEventListener)this, this.accelerometerSensor, 3);
            this.sensorManager.registerListener((SensorEventListener)this, this.magneticFieldSensor, 3);
            this.listening = true;
        }
    }

    private void stopListening() {
        if (this.listening) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
            this.listening = false;
            this.accelsFilled = false;
            this.magsFilled = false;
        }
    }

    @SimpleEvent
    public void OrientationChanged(float azimuth, float pitch, float roll) {
        EventDispatcher.dispatchEvent(this, "OrientationChanged", Float.valueOf(azimuth), Float.valueOf(pitch), Float.valueOf(roll));
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public boolean Available() {
        return this.sensorManager.getSensorList(1).size() > 0 && this.sensorManager.getSensorList(2).size() > 0;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public boolean Enabled() {
        return this.enabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty
    public void Enabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            if (enabled) {
                this.startListening();
            } else {
                this.stopListening();
            }
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public float Pitch() {
        return this.pitch;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public float Roll() {
        return this.roll;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public float Azimuth() {
        return this.azimuth;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public float Angle() {
        return OrientationSensor.computeAngle(this.pitch, this.roll);
    }

    static float computeAngle(float pitch, float roll) {
        return (float)Math.toDegrees(Math.atan2(Math.toRadians(pitch), -Math.toRadians(roll)));
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public float Magnitude() {
        int MAX_VALUE = 90;
        double npitch = Math.toRadians(Math.min(90.0f, Math.abs(this.pitch)));
        double nroll = Math.toRadians(Math.min(90.0f, Math.abs(this.roll)));
        return (float)(1.0 - Math.cos(npitch) * Math.cos(nroll));
    }

    private int getScreenRotation() {
        Display display = ((WindowManager)this.form.getSystemService("window")).getDefaultDisplay();
        if (SdkLevel.getLevel() >= 8) {
            return FroyoUtil.getRotation(display);
        }
        return display.getOrientation();
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        if (this.enabled) {
            int eventType = sensorEvent.sensor.getType();
            switch (eventType) {
                case 1: {
                    System.arraycopy(sensorEvent.values, 0, this.accels, 0, 3);
                    this.accelsFilled = true;
                    this.accuracy = sensorEvent.accuracy;
                    break;
                }
                case 2: {
                    System.arraycopy(sensorEvent.values, 0, this.mags, 0, 3);
                    this.magsFilled = true;
                    break;
                }
                default: {
                    Log.e((String)LOG_TAG, (String)("Unexpected sensor type: " + eventType));
                    return;
                }
            }
            if (this.accelsFilled && this.magsFilled) {
                SensorManager.getRotationMatrix((float[])this.rotationMatrix, (float[])this.inclinationMatrix, (float[])this.accels, (float[])this.mags);
                SensorManager.getOrientation((float[])this.rotationMatrix, (float[])this.values);
                this.azimuth = OrientationSensorUtil.normalizeAzimuth((float)Math.toDegrees(this.values[0]));
                this.pitch = OrientationSensorUtil.normalizePitch((float)Math.toDegrees(this.values[1]));
                this.roll = OrientationSensorUtil.normalizeRoll((float)(-Math.toDegrees(this.values[2])));
                int rotation = this.getScreenRotation();
                switch (rotation) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        float temp = -this.pitch;
                        this.pitch = -this.roll;
                        this.roll = temp;
                        break;
                    }
                    case 2: {
                        this.roll = -this.roll;
                        break;
                    }
                    case 3: {
                        float temp = this.pitch;
                        this.pitch = this.roll;
                        this.roll = temp;
                        break;
                    }
                    default: {
                        Log.e((String)LOG_TAG, (String)("Illegal value for getScreenRotation(): " + rotation));
                    }
                }
                this.OrientationChanged(this.azimuth, this.pitch, this.roll);
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onDelete() {
        this.stopListening();
    }

    public void onPause() {
        this.stopListening();
    }

    public void onResume() {
        if (this.enabled) {
            this.startListening();
        }
    }
}

