/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.os.Handler;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.LegoMindstormsNxtSensor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DesignerComponent(version=1, description="A component that provides a high-level interface to an ultrasonic sensor on a LEGO MINDSTORMS NXT robot.", category=ComponentCategory.LEGOMINDSTORMS, nonVisible=true, iconName="images/legoMindstormsNxt.png")
@SimpleObject
public class NxtUltrasonicSensor
extends LegoMindstormsNxtSensor
implements Deleteable {
    private static final String DEFAULT_SENSOR_PORT = "4";
    private static final int DEFAULT_BOTTOM_OF_RANGE = 30;
    private static final int DEFAULT_TOP_OF_RANGE = 90;
    private Handler handler = new Handler();
    private final Runnable sensorReader;
    private State previousState = State.UNKNOWN;
    private int bottomOfRange;
    private int topOfRange;
    private boolean belowRangeEventEnabled;
    private boolean withinRangeEventEnabled;
    private boolean aboveRangeEventEnabled;

    public NxtUltrasonicSensor(ComponentContainer container) {
        super(container, "NxtUltrasonicSensor");
        this.sensorReader = new Runnable(){

            public void run() {
                if (NxtUltrasonicSensor.this.bluetooth != null && NxtUltrasonicSensor.this.bluetooth.IsConnected()) {
                    LegoMindstormsNxtSensor.SensorValue sensorValue = NxtUltrasonicSensor.this.getDistanceValue("");
                    if (sensorValue.valid) {
                        State currentState = (Integer)sensorValue.value < NxtUltrasonicSensor.this.bottomOfRange ? State.BELOW_RANGE : ((Integer)sensorValue.value > NxtUltrasonicSensor.this.topOfRange ? State.ABOVE_RANGE : State.WITHIN_RANGE);
                        if (currentState != NxtUltrasonicSensor.this.previousState) {
                            if (currentState == State.BELOW_RANGE && NxtUltrasonicSensor.this.belowRangeEventEnabled) {
                                NxtUltrasonicSensor.this.BelowRange();
                            }
                            if (currentState == State.WITHIN_RANGE && NxtUltrasonicSensor.this.withinRangeEventEnabled) {
                                NxtUltrasonicSensor.this.WithinRange();
                            }
                            if (currentState == State.ABOVE_RANGE && NxtUltrasonicSensor.this.aboveRangeEventEnabled) {
                                NxtUltrasonicSensor.this.AboveRange();
                            }
                        }
                        NxtUltrasonicSensor.this.previousState = currentState;
                    }
                }
                if (NxtUltrasonicSensor.this.isHandlerNeeded()) {
                    NxtUltrasonicSensor.this.handler.post(NxtUltrasonicSensor.this.sensorReader);
                }
            }
        };
        this.SensorPort(DEFAULT_SENSOR_PORT);
        this.BottomOfRange(30);
        this.TopOfRange(90);
        this.BelowRangeEventEnabled(false);
        this.WithinRangeEventEnabled(false);
        this.AboveRangeEventEnabled(false);
    }

    @Override
    protected void initializeSensor(String functionName) {
        this.setInputMode(functionName, this.port, 11, 0);
        this.configureUltrasonicSensor(functionName);
    }

    private void configureUltrasonicSensor(String functionName) {
        byte[] data = new byte[]{2, 65, 2};
        this.lsWrite(functionName, this.port, data, 0);
    }

    @Override
    @DesignerProperty(editorType="lego_nxt_sensor_port", defaultValue="4")
    @SimpleProperty(userVisible=false)
    public void SensorPort(String sensorPortLetter) {
        this.setSensorPort(sensorPortLetter);
    }

    @SimpleFunction(description="Returns the current distance in centimeters as a value between 0 and 254, or -1 if the distance can not be read.")
    public int GetDistance() {
        String functionName = "GetDistance";
        if (!this.checkBluetooth(functionName)) {
            return -1;
        }
        LegoMindstormsNxtSensor.SensorValue<Integer> sensorValue = this.getDistanceValue(functionName);
        if (sensorValue.valid) {
            return (Integer)sensorValue.value;
        }
        return -1;
    }

    private LegoMindstormsNxtSensor.SensorValue<Integer> getDistanceValue(String functionName) {
        byte[] data = new byte[]{2, 66};
        this.lsWrite(functionName, this.port, data, 1);
        for (int i = 0; i < 3; ++i) {
            int value;
            int countAvailableBytes = this.lsGetStatus(functionName, this.port);
            if (countAvailableBytes <= 0) continue;
            byte[] returnPackage = this.lsRead(functionName, this.port);
            if (returnPackage == null || (value = this.getUBYTEValueFromBytes(returnPackage, 4)) < 0 || value > 254) break;
            return new LegoMindstormsNxtSensor.SensorValue<Integer>(true, value);
        }
        return new LegoMindstormsNxtSensor.SensorValue<Object>(false, null);
    }

    @SimpleProperty(description="The bottom of the range used for the BelowRange, WithinRange, and AboveRange events.", category=PropertyCategory.BEHAVIOR)
    public int BottomOfRange() {
        return this.bottomOfRange;
    }

    @DesignerProperty(editorType="non_negative_integer", defaultValue="30")
    @SimpleProperty
    public void BottomOfRange(int bottomOfRange) {
        this.bottomOfRange = bottomOfRange;
        this.previousState = State.UNKNOWN;
    }

    @SimpleProperty(description="The top of the range used for the BelowRange, WithinRange, and AboveRange events.", category=PropertyCategory.BEHAVIOR)
    public int TopOfRange() {
        return this.topOfRange;
    }

    @DesignerProperty(editorType="non_negative_integer", defaultValue="90")
    @SimpleProperty
    public void TopOfRange(int topOfRange) {
        this.topOfRange = topOfRange;
        this.previousState = State.UNKNOWN;
    }

    @SimpleProperty(description="Whether the BelowRange event should fire when the distance goes below the BottomOfRange.", category=PropertyCategory.BEHAVIOR)
    public boolean BelowRangeEventEnabled() {
        return this.belowRangeEventEnabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void BelowRangeEventEnabled(boolean enabled) {
        boolean handlerWasNeeded = this.isHandlerNeeded();
        this.belowRangeEventEnabled = enabled;
        boolean handlerIsNeeded = this.isHandlerNeeded();
        if (handlerWasNeeded && !handlerIsNeeded) {
            this.handler.removeCallbacks(this.sensorReader);
        }
        if (!handlerWasNeeded && handlerIsNeeded) {
            this.previousState = State.UNKNOWN;
            this.handler.post(this.sensorReader);
        }
    }

    @SimpleEvent(description="Distance has gone below the range.")
    public void BelowRange() {
        EventDispatcher.dispatchEvent(this, "BelowRange", new Object[0]);
    }

    @SimpleProperty(description="Whether the WithinRange event should fire when the distance goes between the BottomOfRange and the TopOfRange.", category=PropertyCategory.BEHAVIOR)
    public boolean WithinRangeEventEnabled() {
        return this.withinRangeEventEnabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void WithinRangeEventEnabled(boolean enabled) {
        boolean handlerWasNeeded = this.isHandlerNeeded();
        this.withinRangeEventEnabled = enabled;
        boolean handlerIsNeeded = this.isHandlerNeeded();
        if (handlerWasNeeded && !handlerIsNeeded) {
            this.handler.removeCallbacks(this.sensorReader);
        }
        if (!handlerWasNeeded && handlerIsNeeded) {
            this.previousState = State.UNKNOWN;
            this.handler.post(this.sensorReader);
        }
    }

    @SimpleEvent(description="Distance has gone within the range.")
    public void WithinRange() {
        EventDispatcher.dispatchEvent(this, "WithinRange", new Object[0]);
    }

    @SimpleProperty(description="Whether the AboveRange event should fire when the distance goes above the TopOfRange.", category=PropertyCategory.BEHAVIOR)
    public boolean AboveRangeEventEnabled() {
        return this.aboveRangeEventEnabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void AboveRangeEventEnabled(boolean enabled) {
        boolean handlerWasNeeded = this.isHandlerNeeded();
        this.aboveRangeEventEnabled = enabled;
        boolean handlerIsNeeded = this.isHandlerNeeded();
        if (handlerWasNeeded && !handlerIsNeeded) {
            this.handler.removeCallbacks(this.sensorReader);
        }
        if (!handlerWasNeeded && handlerIsNeeded) {
            this.previousState = State.UNKNOWN;
            this.handler.post(this.sensorReader);
        }
    }

    @SimpleEvent(description="Distance has gone above the range.")
    public void AboveRange() {
        EventDispatcher.dispatchEvent(this, "AboveRange", new Object[0]);
    }

    private boolean isHandlerNeeded() {
        return this.belowRangeEventEnabled || this.withinRangeEventEnabled || this.aboveRangeEventEnabled;
    }

    @Override
    public void onDelete() {
        this.handler.removeCallbacks(this.sensorReader);
        super.onDelete();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        UNKNOWN,
        BELOW_RANGE,
        WITHIN_RANGE,
        ABOVE_RANGE;

    }
}

