/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.os.Handler;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.LegoMindstormsNxtSensor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DesignerComponent(version=1, description="A component that provides a high-level interface to a touch sensor on a LEGO MINDSTORMS NXT robot.", category=ComponentCategory.LEGOMINDSTORMS, nonVisible=true, iconName="images/legoMindstormsNxt.png")
@SimpleObject
public class NxtTouchSensor
extends LegoMindstormsNxtSensor
implements Deleteable {
    private static final String DEFAULT_SENSOR_PORT = "1";
    private Handler handler = new Handler();
    private State previousState = State.UNKNOWN;
    private final Runnable sensorReader = new Runnable(){

        public void run() {
            if (NxtTouchSensor.this.bluetooth != null && NxtTouchSensor.this.bluetooth.IsConnected()) {
                LegoMindstormsNxtSensor.SensorValue sensorValue = NxtTouchSensor.this.getPressedValue("");
                if (sensorValue.valid) {
                    State currentState;
                    State state = currentState = (Boolean)sensorValue.value != false ? State.PRESSED : State.RELEASED;
                    if (currentState != NxtTouchSensor.this.previousState) {
                        if (currentState == State.PRESSED && NxtTouchSensor.this.pressedEventEnabled) {
                            NxtTouchSensor.this.Pressed();
                        }
                        if (currentState == State.RELEASED && NxtTouchSensor.this.releasedEventEnabled) {
                            NxtTouchSensor.this.Released();
                        }
                    }
                    NxtTouchSensor.this.previousState = currentState;
                }
            }
            if (NxtTouchSensor.this.isHandlerNeeded()) {
                NxtTouchSensor.this.handler.post(NxtTouchSensor.this.sensorReader);
            }
        }
    };
    private boolean pressedEventEnabled;
    private boolean releasedEventEnabled;

    public NxtTouchSensor(ComponentContainer container) {
        super(container, "NxtTouchSensor");
        this.SensorPort(DEFAULT_SENSOR_PORT);
        this.PressedEventEnabled(false);
        this.ReleasedEventEnabled(false);
    }

    @Override
    protected void initializeSensor(String functionName) {
        this.setInputMode(functionName, this.port, 1, 32);
    }

    @Override
    @DesignerProperty(editorType="lego_nxt_sensor_port", defaultValue="1")
    @SimpleProperty(userVisible=false)
    public void SensorPort(String sensorPortLetter) {
        this.setSensorPort(sensorPortLetter);
    }

    @SimpleFunction(description="Returns true if the touch sensor is pressed.")
    public boolean IsPressed() {
        String functionName = "IsPressed";
        if (!this.checkBluetooth(functionName)) {
            return false;
        }
        LegoMindstormsNxtSensor.SensorValue<Boolean> sensorValue = this.getPressedValue(functionName);
        if (sensorValue.valid) {
            return (Boolean)sensorValue.value;
        }
        return false;
    }

    private LegoMindstormsNxtSensor.SensorValue<Boolean> getPressedValue(String functionName) {
        boolean valid;
        byte[] returnPackage = this.getInputValues(functionName, this.port);
        if (returnPackage != null && (valid = this.getBooleanValueFromBytes(returnPackage, 4))) {
            int scaledValue = this.getSWORDValueFromBytes(returnPackage, 12);
            return new LegoMindstormsNxtSensor.SensorValue<Boolean>(true, scaledValue != 0);
        }
        return new LegoMindstormsNxtSensor.SensorValue<Object>(false, null);
    }

    @SimpleProperty(description="Whether the Pressed event should fire when the touch sensor is pressed.", category=PropertyCategory.BEHAVIOR)
    public boolean PressedEventEnabled() {
        return this.pressedEventEnabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void PressedEventEnabled(boolean enabled) {
        boolean handlerWasNeeded = this.isHandlerNeeded();
        this.pressedEventEnabled = enabled;
        boolean handlerIsNeeded = this.isHandlerNeeded();
        if (handlerWasNeeded && !handlerIsNeeded) {
            this.handler.removeCallbacks(this.sensorReader);
        }
        if (!handlerWasNeeded && handlerIsNeeded) {
            this.previousState = State.UNKNOWN;
            this.handler.post(this.sensorReader);
        }
    }

    @SimpleEvent(description="Touch sensor has been pressed.")
    public void Pressed() {
        EventDispatcher.dispatchEvent(this, "Pressed", new Object[0]);
    }

    @SimpleProperty(description="Whether the Released event should fire when the touch sensor is released.", category=PropertyCategory.BEHAVIOR)
    public boolean ReleasedEventEnabled() {
        return this.releasedEventEnabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void ReleasedEventEnabled(boolean enabled) {
        boolean handlerWasNeeded = this.isHandlerNeeded();
        this.releasedEventEnabled = enabled;
        boolean handlerIsNeeded = this.isHandlerNeeded();
        if (handlerWasNeeded && !handlerIsNeeded) {
            this.handler.removeCallbacks(this.sensorReader);
        }
        if (!handlerWasNeeded && handlerIsNeeded) {
            this.previousState = State.UNKNOWN;
            this.handler.post(this.sensorReader);
        }
    }

    @SimpleEvent(description="Touch sensor has been released.")
    public void Released() {
        EventDispatcher.dispatchEvent(this, "Released", new Object[0]);
    }

    private boolean isHandlerNeeded() {
        return this.pressedEventEnabled || this.releasedEventEnabled;
    }

    @Override
    public void onDelete() {
        this.handler.removeCallbacks(this.sensorReader);
        super.onDelete();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        UNKNOWN,
        PRESSED,
        RELEASED;

    }
}

