/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.os.Handler;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.LegoMindstormsNxtSensor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DesignerComponent(version=1, description="A component that provides a high-level interface to a light sensor on a LEGO MINDSTORMS NXT robot.", category=ComponentCategory.LEGOMINDSTORMS, nonVisible=true, iconName="images/legoMindstormsNxt.png")
@SimpleObject
public class NxtLightSensor
extends LegoMindstormsNxtSensor
implements Deleteable {
    private static final String DEFAULT_SENSOR_PORT = "3";
    private static final int DEFAULT_BOTTOM_OF_RANGE = 256;
    private static final int DEFAULT_TOP_OF_RANGE = 767;
    private Handler handler = new Handler();
    private final Runnable sensorReader;
    private State previousState = State.UNKNOWN;
    private int bottomOfRange;
    private int topOfRange;
    private boolean belowRangeEventEnabled;
    private boolean withinRangeEventEnabled;
    private boolean aboveRangeEventEnabled;
    private boolean generateLight;

    public NxtLightSensor(ComponentContainer container) {
        super(container, "NxtLightSensor");
        this.sensorReader = new Runnable(){

            public void run() {
                if (NxtLightSensor.this.bluetooth != null && NxtLightSensor.this.bluetooth.IsConnected()) {
                    LegoMindstormsNxtSensor.SensorValue sensorValue = NxtLightSensor.this.getLightValue("");
                    if (sensorValue.valid) {
                        State currentState = (Integer)sensorValue.value < NxtLightSensor.this.bottomOfRange ? State.BELOW_RANGE : ((Integer)sensorValue.value > NxtLightSensor.this.topOfRange ? State.ABOVE_RANGE : State.WITHIN_RANGE);
                        if (currentState != NxtLightSensor.this.previousState) {
                            if (currentState == State.BELOW_RANGE && NxtLightSensor.this.belowRangeEventEnabled) {
                                NxtLightSensor.this.BelowRange();
                            }
                            if (currentState == State.WITHIN_RANGE && NxtLightSensor.this.withinRangeEventEnabled) {
                                NxtLightSensor.this.WithinRange();
                            }
                            if (currentState == State.ABOVE_RANGE && NxtLightSensor.this.aboveRangeEventEnabled) {
                                NxtLightSensor.this.AboveRange();
                            }
                        }
                        NxtLightSensor.this.previousState = currentState;
                    }
                }
                if (NxtLightSensor.this.isHandlerNeeded()) {
                    NxtLightSensor.this.handler.post(NxtLightSensor.this.sensorReader);
                }
            }
        };
        this.SensorPort(DEFAULT_SENSOR_PORT);
        this.BottomOfRange(256);
        this.TopOfRange(767);
        this.BelowRangeEventEnabled(false);
        this.WithinRangeEventEnabled(false);
        this.AboveRangeEventEnabled(false);
        this.GenerateLight(false);
    }

    @Override
    protected void initializeSensor(String functionName) {
        this.setInputMode(functionName, this.port, this.generateLight ? 5 : 6, 128);
    }

    @Override
    @DesignerProperty(editorType="lego_nxt_sensor_port", defaultValue="3")
    @SimpleProperty(userVisible=false)
    public void SensorPort(String sensorPortLetter) {
        this.setSensorPort(sensorPortLetter);
    }

    @SimpleProperty(description="Whether the light sensor should generate light.", category=PropertyCategory.BEHAVIOR)
    public boolean GenerateLight() {
        return this.generateLight;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void GenerateLight(boolean generateLight) {
        this.generateLight = generateLight;
        if (this.bluetooth != null && this.bluetooth.IsConnected()) {
            this.initializeSensor("GenerateLight");
        }
    }

    @SimpleFunction(description="Returns the current light level as a value between 0 and 1023, or -1 if the light level can not be read.")
    public int GetLightLevel() {
        String functionName = "GetLightLevel";
        if (!this.checkBluetooth(functionName)) {
            return -1;
        }
        LegoMindstormsNxtSensor.SensorValue<Integer> sensorValue = this.getLightValue(functionName);
        if (sensorValue.valid) {
            return (Integer)sensorValue.value;
        }
        return -1;
    }

    private LegoMindstormsNxtSensor.SensorValue<Integer> getLightValue(String functionName) {
        boolean valid;
        byte[] returnPackage = this.getInputValues(functionName, this.port);
        if (returnPackage != null && (valid = this.getBooleanValueFromBytes(returnPackage, 4))) {
            int normalizedValue = this.getUWORDValueFromBytes(returnPackage, 10);
            return new LegoMindstormsNxtSensor.SensorValue<Integer>(true, normalizedValue);
        }
        return new LegoMindstormsNxtSensor.SensorValue<Object>(false, null);
    }

    @SimpleProperty(description="The bottom of the range used for the BelowRange, WithinRange, and AboveRange events.", category=PropertyCategory.BEHAVIOR)
    public int BottomOfRange() {
        return this.bottomOfRange;
    }

    @DesignerProperty(editorType="non_negative_integer", defaultValue="256")
    @SimpleProperty
    public void BottomOfRange(int bottomOfRange) {
        this.bottomOfRange = bottomOfRange;
        this.previousState = State.UNKNOWN;
    }

    @SimpleProperty(description="The top of the range used for the BelowRange, WithinRange, and AboveRange events.", category=PropertyCategory.BEHAVIOR)
    public int TopOfRange() {
        return this.topOfRange;
    }

    @DesignerProperty(editorType="non_negative_integer", defaultValue="767")
    @SimpleProperty
    public void TopOfRange(int topOfRange) {
        this.topOfRange = topOfRange;
        this.previousState = State.UNKNOWN;
    }

    @SimpleProperty(description="Whether the BelowRange event should fire when the light level goes below the BottomOfRange.", category=PropertyCategory.BEHAVIOR)
    public boolean BelowRangeEventEnabled() {
        return this.belowRangeEventEnabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void BelowRangeEventEnabled(boolean enabled) {
        boolean handlerWasNeeded = this.isHandlerNeeded();
        this.belowRangeEventEnabled = enabled;
        boolean handlerIsNeeded = this.isHandlerNeeded();
        if (handlerWasNeeded && !handlerIsNeeded) {
            this.handler.removeCallbacks(this.sensorReader);
        }
        if (!handlerWasNeeded && handlerIsNeeded) {
            this.previousState = State.UNKNOWN;
            this.handler.post(this.sensorReader);
        }
    }

    @SimpleEvent(description="Light level has gone below the range.")
    public void BelowRange() {
        EventDispatcher.dispatchEvent(this, "BelowRange", new Object[0]);
    }

    @SimpleProperty(description="Whether the WithinRange event should fire when the light level goes between the BottomOfRange and the TopOfRange.", category=PropertyCategory.BEHAVIOR)
    public boolean WithinRangeEventEnabled() {
        return this.withinRangeEventEnabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void WithinRangeEventEnabled(boolean enabled) {
        boolean handlerWasNeeded = this.isHandlerNeeded();
        this.withinRangeEventEnabled = enabled;
        boolean handlerIsNeeded = this.isHandlerNeeded();
        if (handlerWasNeeded && !handlerIsNeeded) {
            this.handler.removeCallbacks(this.sensorReader);
        }
        if (!handlerWasNeeded && handlerIsNeeded) {
            this.previousState = State.UNKNOWN;
            this.handler.post(this.sensorReader);
        }
    }

    @SimpleEvent(description="Light level has gone within the range.")
    public void WithinRange() {
        EventDispatcher.dispatchEvent(this, "WithinRange", new Object[0]);
    }

    @SimpleProperty(description="Whether the AboveRange event should fire when the light level goes above the TopOfRange.", category=PropertyCategory.BEHAVIOR)
    public boolean AboveRangeEventEnabled() {
        return this.aboveRangeEventEnabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void AboveRangeEventEnabled(boolean enabled) {
        boolean handlerWasNeeded = this.isHandlerNeeded();
        this.aboveRangeEventEnabled = enabled;
        boolean handlerIsNeeded = this.isHandlerNeeded();
        if (handlerWasNeeded && !handlerIsNeeded) {
            this.handler.removeCallbacks(this.sensorReader);
        }
        if (!handlerWasNeeded && handlerIsNeeded) {
            this.previousState = State.UNKNOWN;
            this.handler.post(this.sensorReader);
        }
    }

    @SimpleEvent(description="Light level has gone above the range.")
    public void AboveRange() {
        EventDispatcher.dispatchEvent(this, "AboveRange", new Object[0]);
    }

    private boolean isHandlerNeeded() {
        return this.belowRangeEventEnabled || this.withinRangeEventEnabled || this.aboveRangeEventEnabled;
    }

    @Override
    public void onDelete() {
        this.handler.removeCallbacks(this.sensorReader);
        super.onDelete();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        UNKNOWN,
        BELOW_RANGE,
        WITHIN_RANGE,
        ABOVE_RANGE;

    }
}

